/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.dto;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.rocketmq.schema.registry.common.dto.SubjectDto;
import org.apache.rocketmq.schema.registry.common.model.Dependency;
import org.apache.rocketmq.schema.registry.common.model.SchemaType;

public class SchemaRecordDto {
    @ApiModelProperty(value="Schema name", required=true)
    private String schema;
    @ApiModelProperty(value="Schema unique id", required=true)
    private long schemaId;
    @ApiModelProperty(value="Version of this schema record")
    private long version;
    @ApiModelProperty(value="Schema record unique id")
    private long recordId;
    @ApiModelProperty(value="IDL of this schema record", required=true)
    private String idl;
    @ApiModelProperty(value="Dependency of this schema record")
    private Dependency dependency;
    @ApiModelProperty(value="Subjects of this record binding")
    private List<SubjectDto> subjects;
    @ApiModelProperty(value="Schema type")
    private SchemaType type;

    public static SchemaRecordDtoBuilder builder() {
        return new SchemaRecordDtoBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public long getSchemaId() {
        return this.schemaId;
    }

    public long getVersion() {
        return this.version;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public String getIdl() {
        return this.idl;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public List<SubjectDto> getSubjects() {
        return this.subjects;
    }

    public SchemaType getType() {
        return this.type;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setSchemaId(long schemaId) {
        this.schemaId = schemaId;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    public void setIdl(String idl) {
        this.idl = idl;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public void setSubjects(List<SubjectDto> subjects) {
        this.subjects = subjects;
    }

    public void setType(SchemaType type) {
        this.type = type;
    }

    public String toString() {
        return "SchemaRecordDto(schema=" + this.getSchema() + ", schemaId=" + this.getSchemaId() + ", version=" + this.getVersion() + ", recordId=" + this.getRecordId() + ", idl=" + this.getIdl() + ", dependency=" + this.getDependency() + ", subjects=" + this.getSubjects() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaRecordDto)) {
            return false;
        }
        SchemaRecordDto other = (SchemaRecordDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSchemaId() != other.getSchemaId()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getRecordId() != other.getRecordId()) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$idl = this.getIdl();
        String other$idl = other.getIdl();
        if (this$idl == null ? other$idl != null : !this$idl.equals(other$idl)) {
            return false;
        }
        Dependency this$dependency = this.getDependency();
        Dependency other$dependency = other.getDependency();
        if (this$dependency == null ? other$dependency != null : !((Object)this$dependency).equals(other$dependency)) {
            return false;
        }
        List<SubjectDto> this$subjects = this.getSubjects();
        List<SubjectDto> other$subjects = other.getSubjects();
        if (this$subjects == null ? other$subjects != null : !((Object)this$subjects).equals(other$subjects)) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaRecordDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $schemaId = this.getSchemaId();
        result = result * 59 + (int)($schemaId >>> 32 ^ $schemaId);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $recordId = this.getRecordId();
        result = result * 59 + (int)($recordId >>> 32 ^ $recordId);
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $idl = this.getIdl();
        result = result * 59 + ($idl == null ? 43 : $idl.hashCode());
        Dependency $dependency = this.getDependency();
        result = result * 59 + ($dependency == null ? 43 : ((Object)$dependency).hashCode());
        List<SubjectDto> $subjects = this.getSubjects();
        result = result * 59 + ($subjects == null ? 43 : ((Object)$subjects).hashCode());
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public SchemaRecordDto(String schema, long schemaId, long version, long recordId, String idl, Dependency dependency, List<SubjectDto> subjects, SchemaType type) {
        this.schema = schema;
        this.schemaId = schemaId;
        this.version = version;
        this.recordId = recordId;
        this.idl = idl;
        this.dependency = dependency;
        this.subjects = subjects;
        this.type = type;
    }

    public SchemaRecordDto() {
    }

    public static class SchemaRecordDtoBuilder {
        private String schema;
        private long schemaId;
        private long version;
        private long recordId;
        private String idl;
        private Dependency dependency;
        private List<SubjectDto> subjects;
        private SchemaType type;

        SchemaRecordDtoBuilder() {
        }

        public SchemaRecordDtoBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public SchemaRecordDtoBuilder schemaId(long schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public SchemaRecordDtoBuilder version(long version) {
            this.version = version;
            return this;
        }

        public SchemaRecordDtoBuilder recordId(long recordId) {
            this.recordId = recordId;
            return this;
        }

        public SchemaRecordDtoBuilder idl(String idl) {
            this.idl = idl;
            return this;
        }

        public SchemaRecordDtoBuilder dependency(Dependency dependency) {
            this.dependency = dependency;
            return this;
        }

        public SchemaRecordDtoBuilder subjects(List<SubjectDto> subjects) {
            this.subjects = subjects;
            return this;
        }

        public SchemaRecordDtoBuilder type(SchemaType type) {
            this.type = type;
            return this;
        }

        public SchemaRecordDto build() {
            return new SchemaRecordDto(this.schema, this.schemaId, this.version, this.recordId, this.idl, this.dependency, this.subjects, this.type);
        }

        public String toString() {
            return "SchemaRecordDto.SchemaRecordDtoBuilder(schema=" + this.schema + ", schemaId=" + this.schemaId + ", version=" + this.version + ", recordId=" + this.recordId + ", idl=" + this.idl + ", dependency=" + this.dependency + ", subjects=" + this.subjects + ", type=" + (Object)((Object)this.type) + ")";
        }
    }
}

