/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import org.apache.rocketmq.schema.registry.common.QualifiedName;
import org.apache.rocketmq.schema.registry.common.dto.AuditDto;
import org.apache.rocketmq.schema.registry.common.dto.BaseDto;
import org.apache.rocketmq.schema.registry.common.dto.SchemaDetailDto;
import org.apache.rocketmq.schema.registry.common.dto.SchemaMetaDto;
import org.apache.rocketmq.schema.registry.common.dto.SchemaStorageDto;

@ApiModel(description="Schema detail information")
public class SchemaDto
extends BaseDto {
    private static final long serialVersionUID = -441512542075118183L;
    @ApiModelProperty(value="The qualified name of this entity")
    private QualifiedName qualifiedName;
    @ApiModelProperty(value="Information about schema changes")
    private AuditDto audit;
    @ApiModelProperty(value="Information about schema meta", required=true)
    private SchemaMetaDto meta;
    @ApiModelProperty(value="Information about schema details", required=true)
    private SchemaDetailDto details;
    @ApiModelProperty(value="Information about schema persistence")
    private SchemaStorageDto storage;
    @ApiModelProperty(value="Extra schema parameters")
    private Map<String, String> extras;

    public SchemaDto setQualifiedName(QualifiedName qualifiedName) {
        this.qualifiedName = qualifiedName;
        return this;
    }

    public static SchemaDtoBuilder builder() {
        return new SchemaDtoBuilder();
    }

    public QualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    public AuditDto getAudit() {
        return this.audit;
    }

    public SchemaMetaDto getMeta() {
        return this.meta;
    }

    public SchemaDetailDto getDetails() {
        return this.details;
    }

    public SchemaStorageDto getStorage() {
        return this.storage;
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public void setAudit(AuditDto audit) {
        this.audit = audit;
    }

    public void setMeta(SchemaMetaDto meta) {
        this.meta = meta;
    }

    public void setDetails(SchemaDetailDto details) {
        this.details = details;
    }

    public void setStorage(SchemaStorageDto storage) {
        this.storage = storage;
    }

    public void setExtras(Map<String, String> extras) {
        this.extras = extras;
    }

    @Override
    public String toString() {
        return "SchemaDto(qualifiedName=" + this.getQualifiedName() + ", audit=" + this.getAudit() + ", meta=" + this.getMeta() + ", details=" + this.getDetails() + ", storage=" + this.getStorage() + ", extras=" + this.getExtras() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaDto)) {
            return false;
        }
        SchemaDto other = (SchemaDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QualifiedName this$qualifiedName = this.getQualifiedName();
        QualifiedName other$qualifiedName = other.getQualifiedName();
        if (this$qualifiedName == null ? other$qualifiedName != null : !((Object)this$qualifiedName).equals(other$qualifiedName)) {
            return false;
        }
        AuditDto this$audit = this.getAudit();
        AuditDto other$audit = other.getAudit();
        if (this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit)) {
            return false;
        }
        SchemaMetaDto this$meta = this.getMeta();
        SchemaMetaDto other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        SchemaDetailDto this$details = this.getDetails();
        SchemaDetailDto other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        SchemaStorageDto this$storage = this.getStorage();
        SchemaStorageDto other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        Map<String, String> this$extras = this.getExtras();
        Map<String, String> other$extras = other.getExtras();
        return !(this$extras == null ? other$extras != null : !((Object)this$extras).equals(other$extras));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QualifiedName $qualifiedName = this.getQualifiedName();
        result = result * 59 + ($qualifiedName == null ? 43 : ((Object)$qualifiedName).hashCode());
        AuditDto $audit = this.getAudit();
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        SchemaMetaDto $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        SchemaDetailDto $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        SchemaStorageDto $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        Map<String, String> $extras = this.getExtras();
        result = result * 59 + ($extras == null ? 43 : ((Object)$extras).hashCode());
        return result;
    }

    public SchemaDto() {
    }

    public SchemaDto(QualifiedName qualifiedName, AuditDto audit, SchemaMetaDto meta, SchemaDetailDto details, SchemaStorageDto storage, Map<String, String> extras) {
        this.qualifiedName = qualifiedName;
        this.audit = audit;
        this.meta = meta;
        this.details = details;
        this.storage = storage;
        this.extras = extras;
    }

    public static class SchemaDtoBuilder {
        private QualifiedName qualifiedName;
        private AuditDto audit;
        private SchemaMetaDto meta;
        private SchemaDetailDto details;
        private SchemaStorageDto storage;
        private Map<String, String> extras;

        SchemaDtoBuilder() {
        }

        public SchemaDtoBuilder qualifiedName(QualifiedName qualifiedName) {
            this.qualifiedName = qualifiedName;
            return this;
        }

        public SchemaDtoBuilder audit(AuditDto audit) {
            this.audit = audit;
            return this;
        }

        public SchemaDtoBuilder meta(SchemaMetaDto meta) {
            this.meta = meta;
            return this;
        }

        public SchemaDtoBuilder details(SchemaDetailDto details) {
            this.details = details;
            return this;
        }

        public SchemaDtoBuilder storage(SchemaStorageDto storage) {
            this.storage = storage;
            return this;
        }

        public SchemaDtoBuilder extras(Map<String, String> extras) {
            this.extras = extras;
            return this;
        }

        public SchemaDto build() {
            return new SchemaDto(this.qualifiedName, this.audit, this.meta, this.details, this.storage, this.extras);
        }

        public String toString() {
            return "SchemaDto.SchemaDtoBuilder(qualifiedName=" + this.qualifiedName + ", audit=" + this.audit + ", meta=" + this.meta + ", details=" + this.details + ", storage=" + this.storage + ", extras=" + this.extras + ")";
        }
    }
}

