/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.dto;

import io.swagger.annotations.ApiModelProperty;
import org.apache.rocketmq.schema.registry.common.dto.BaseDto;
import org.apache.rocketmq.schema.registry.common.model.Compatibility;
import org.apache.rocketmq.schema.registry.common.model.SchemaType;

public class RegisterSchemaRequest
extends BaseDto {
    private static final long serialVersionUID = 7890248374919863930L;
    @ApiModelProperty(value="First IDL of this schema", example="{\"type\": \"string\"}", required=true)
    private String schemaIdl;
    @ApiModelProperty(value="Schema type")
    private SchemaType schemaType = SchemaType.AVRO;
    @ApiModelProperty(value="Schema owner", example="li")
    private String owner = "";
    @ApiModelProperty(value="Schema compatibility")
    private Compatibility compatibility = Compatibility.BACKWARD;
    @ApiModelProperty(value="Schema description", example="my first schema")
    private String desc = "";

    public static RegisterSchemaRequestBuilder builder() {
        return new RegisterSchemaRequestBuilder();
    }

    public String getSchemaIdl() {
        return this.schemaIdl;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public String getOwner() {
        return this.owner;
    }

    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setSchemaIdl(String schemaIdl) {
        this.schemaIdl = schemaIdl;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCompatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String toString() {
        return "RegisterSchemaRequest(schemaIdl=" + this.getSchemaIdl() + ", schemaType=" + (Object)((Object)this.getSchemaType()) + ", owner=" + this.getOwner() + ", compatibility=" + (Object)((Object)this.getCompatibility()) + ", desc=" + this.getDesc() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisterSchemaRequest)) {
            return false;
        }
        RegisterSchemaRequest other = (RegisterSchemaRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schemaIdl = this.getSchemaIdl();
        String other$schemaIdl = other.getSchemaIdl();
        if (this$schemaIdl == null ? other$schemaIdl != null : !this$schemaIdl.equals(other$schemaIdl)) {
            return false;
        }
        SchemaType this$schemaType = this.getSchemaType();
        SchemaType other$schemaType = other.getSchemaType();
        if (this$schemaType == null ? other$schemaType != null : !((Object)((Object)this$schemaType)).equals((Object)other$schemaType)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Compatibility this$compatibility = this.getCompatibility();
        Compatibility other$compatibility = other.getCompatibility();
        if (this$compatibility == null ? other$compatibility != null : !((Object)((Object)this$compatibility)).equals((Object)other$compatibility)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisterSchemaRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schemaIdl = this.getSchemaIdl();
        result = result * 59 + ($schemaIdl == null ? 43 : $schemaIdl.hashCode());
        SchemaType $schemaType = this.getSchemaType();
        result = result * 59 + ($schemaType == null ? 43 : ((Object)((Object)$schemaType)).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Compatibility $compatibility = this.getCompatibility();
        result = result * 59 + ($compatibility == null ? 43 : ((Object)((Object)$compatibility)).hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        return result;
    }

    public RegisterSchemaRequest() {
    }

    public RegisterSchemaRequest(String schemaIdl, SchemaType schemaType, String owner, Compatibility compatibility, String desc) {
        this.schemaIdl = schemaIdl;
        this.schemaType = schemaType;
        this.owner = owner;
        this.compatibility = compatibility;
        this.desc = desc;
    }

    public static class RegisterSchemaRequestBuilder {
        private String schemaIdl;
        private SchemaType schemaType;
        private String owner;
        private Compatibility compatibility;
        private String desc;

        RegisterSchemaRequestBuilder() {
        }

        public RegisterSchemaRequestBuilder schemaIdl(String schemaIdl) {
            this.schemaIdl = schemaIdl;
            return this;
        }

        public RegisterSchemaRequestBuilder schemaType(SchemaType schemaType) {
            this.schemaType = schemaType;
            return this;
        }

        public RegisterSchemaRequestBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public RegisterSchemaRequestBuilder compatibility(Compatibility compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        public RegisterSchemaRequestBuilder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public RegisterSchemaRequest build() {
            return new RegisterSchemaRequest(this.schemaIdl, this.schemaType, this.owner, this.compatibility, this.desc);
        }

        public String toString() {
            return "RegisterSchemaRequest.RegisterSchemaRequestBuilder(schemaIdl=" + this.schemaIdl + ", schemaType=" + (Object)((Object)this.schemaType) + ", owner=" + this.owner + ", compatibility=" + (Object)((Object)this.compatibility) + ", desc=" + this.desc + ")";
        }
    }
}

