/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.dto;

import io.swagger.annotations.ApiModelProperty;
import org.apache.rocketmq.schema.registry.common.QualifiedName;
import org.apache.rocketmq.schema.registry.common.dto.BaseDto;
import org.apache.rocketmq.schema.registry.common.model.Dependency;
import org.apache.rocketmq.schema.registry.common.model.SchemaRecordInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaType;
import org.apache.rocketmq.schema.registry.common.utils.CommonUtil;

public class GetSchemaResponse
extends BaseDto {
    private static final long serialVersionUID = -4612593696179069203L;
    @ApiModelProperty(value="Schema dependency")
    private String subjectFullName;
    @ApiModelProperty(value="Schema full name")
    private String schemaFullName;
    @ApiModelProperty(value="Version of this schema record")
    private long version;
    @ApiModelProperty(value="Schema record unique id", required=true)
    private long recordId;
    @ApiModelProperty(value="Schema idl")
    private String idl;
    @ApiModelProperty(value="Schema dependency")
    private Dependency dependency;
    @ApiModelProperty(value="Schema type")
    private SchemaType type;

    public GetSchemaResponse(QualifiedName name, SchemaRecordInfo schemaRecordInfo) {
        this.subjectFullName = name.subjectFullName();
        this.schemaFullName = schemaRecordInfo.getSchema();
        this.version = schemaRecordInfo.getVersion();
        this.recordId = CommonUtil.getSchemaRecordId(schemaRecordInfo.getSchemaId(), schemaRecordInfo.getVersion());
        this.idl = schemaRecordInfo.getIdl();
        this.dependency = schemaRecordInfo.getDependency();
        this.type = schemaRecordInfo.getType();
    }

    public static GetSchemaResponseBuilder builder() {
        return new GetSchemaResponseBuilder();
    }

    public String getSubjectFullName() {
        return this.subjectFullName;
    }

    public String getSchemaFullName() {
        return this.schemaFullName;
    }

    public long getVersion() {
        return this.version;
    }

    public long getRecordId() {
        return this.recordId;
    }

    public String getIdl() {
        return this.idl;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public SchemaType getType() {
        return this.type;
    }

    public void setSubjectFullName(String subjectFullName) {
        this.subjectFullName = subjectFullName;
    }

    public void setSchemaFullName(String schemaFullName) {
        this.schemaFullName = schemaFullName;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    public void setIdl(String idl) {
        this.idl = idl;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    public void setType(SchemaType type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "GetSchemaResponse(subjectFullName=" + this.getSubjectFullName() + ", schemaFullName=" + this.getSchemaFullName() + ", version=" + this.getVersion() + ", recordId=" + this.getRecordId() + ", idl=" + this.getIdl() + ", dependency=" + this.getDependency() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetSchemaResponse)) {
            return false;
        }
        GetSchemaResponse other = (GetSchemaResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getRecordId() != other.getRecordId()) {
            return false;
        }
        String this$subjectFullName = this.getSubjectFullName();
        String other$subjectFullName = other.getSubjectFullName();
        if (this$subjectFullName == null ? other$subjectFullName != null : !this$subjectFullName.equals(other$subjectFullName)) {
            return false;
        }
        String this$schemaFullName = this.getSchemaFullName();
        String other$schemaFullName = other.getSchemaFullName();
        if (this$schemaFullName == null ? other$schemaFullName != null : !this$schemaFullName.equals(other$schemaFullName)) {
            return false;
        }
        String this$idl = this.getIdl();
        String other$idl = other.getIdl();
        if (this$idl == null ? other$idl != null : !this$idl.equals(other$idl)) {
            return false;
        }
        Dependency this$dependency = this.getDependency();
        Dependency other$dependency = other.getDependency();
        if (this$dependency == null ? other$dependency != null : !((Object)this$dependency).equals(other$dependency)) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetSchemaResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        long $recordId = this.getRecordId();
        result = result * 59 + (int)($recordId >>> 32 ^ $recordId);
        String $subjectFullName = this.getSubjectFullName();
        result = result * 59 + ($subjectFullName == null ? 43 : $subjectFullName.hashCode());
        String $schemaFullName = this.getSchemaFullName();
        result = result * 59 + ($schemaFullName == null ? 43 : $schemaFullName.hashCode());
        String $idl = this.getIdl();
        result = result * 59 + ($idl == null ? 43 : $idl.hashCode());
        Dependency $dependency = this.getDependency();
        result = result * 59 + ($dependency == null ? 43 : ((Object)$dependency).hashCode());
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public GetSchemaResponse() {
    }

    public GetSchemaResponse(String subjectFullName, String schemaFullName, long version, long recordId, String idl, Dependency dependency, SchemaType type) {
        this.subjectFullName = subjectFullName;
        this.schemaFullName = schemaFullName;
        this.version = version;
        this.recordId = recordId;
        this.idl = idl;
        this.dependency = dependency;
        this.type = type;
    }

    public static class GetSchemaResponseBuilder {
        private String subjectFullName;
        private String schemaFullName;
        private long version;
        private long recordId;
        private String idl;
        private Dependency dependency;
        private SchemaType type;

        GetSchemaResponseBuilder() {
        }

        public GetSchemaResponseBuilder subjectFullName(String subjectFullName) {
            this.subjectFullName = subjectFullName;
            return this;
        }

        public GetSchemaResponseBuilder schemaFullName(String schemaFullName) {
            this.schemaFullName = schemaFullName;
            return this;
        }

        public GetSchemaResponseBuilder version(long version) {
            this.version = version;
            return this;
        }

        public GetSchemaResponseBuilder recordId(long recordId) {
            this.recordId = recordId;
            return this;
        }

        public GetSchemaResponseBuilder idl(String idl) {
            this.idl = idl;
            return this;
        }

        public GetSchemaResponseBuilder dependency(Dependency dependency) {
            this.dependency = dependency;
            return this;
        }

        public GetSchemaResponseBuilder type(SchemaType type) {
            this.type = type;
            return this;
        }

        public GetSchemaResponse build() {
            return new GetSchemaResponse(this.subjectFullName, this.schemaFullName, this.version, this.recordId, this.idl, this.dependency, this.type);
        }

        public String toString() {
            return "GetSchemaResponse.GetSchemaResponseBuilder(subjectFullName=" + this.subjectFullName + ", schemaFullName=" + this.schemaFullName + ", version=" + this.version + ", recordId=" + this.recordId + ", idl=" + this.idl + ", dependency=" + this.dependency + ", type=" + (Object)((Object)this.type) + ")";
        }
    }
}

