/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.json;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.rocketmq.schema.registry.client.SchemaRegistryClient;
import org.apache.rocketmq.schema.registry.client.serde.json.JsonDeserializer;
import org.apache.rocketmq.schema.registry.client.serde.json.JsonSerializer;

public class JsonSerde<T>
implements Closeable {
    private final JsonSerializer<T> serializer;
    private final JsonDeserializer<T> deserializer;

    public JsonSerde() {
        this.serializer = new JsonSerializer();
        this.deserializer = new JsonDeserializer();
    }

    public JsonSerde(SchemaRegistryClient registryClient) {
        this.serializer = new JsonSerializer(registryClient);
        this.deserializer = new JsonDeserializer(registryClient);
    }

    public void configure(Map<String, Object> configs) {
        this.serializer.configure(configs);
        this.deserializer.configure(configs);
    }

    public JsonSerializer<T> serializer() {
        return this.serializer;
    }

    public JsonDeserializer<T> deserializer() {
        return this.deserializer;
    }

    @Override
    public void close() throws IOException {
    }
}

