/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.rocketmq.schema.registry.client.SchemaRegistryClient;
import org.apache.rocketmq.schema.registry.client.exceptions.RestClientException;
import org.apache.rocketmq.schema.registry.client.exceptions.SerializationException;
import org.apache.rocketmq.schema.registry.client.serde.Serializer;
import org.apache.rocketmq.schema.registry.common.dto.GetSchemaResponse;

public class AvroSerializer<T>
implements Serializer<T> {
    protected SchemaRegistryClient schemaRegistry;
    private final EncoderFactory encoderFactory = EncoderFactory.get();

    public AvroSerializer() {
    }

    public AvroSerializer(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistry = schemaRegistryClient;
    }

    @Override
    public void configure(Map<String, Object> configs) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(String subject, T record) throws SerializationException {
        if (this.schemaRegistry == null) {
            throw new SerializationException("please initialize the schema registry client first");
        }
        if (record == null) {
            return null;
        }
        String purposeSchema = record instanceof GenericRecord ? ((GenericContainer)record).getSchema().toString() : SpecificData.get().getSchema(record.getClass()).toString();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
            GetSchemaResponse response = this.schemaRegistry.getTargetSchema(subject, purposeSchema);
            if (response == null) {
                throw new SerializationException("there's no corresponding schema version equals to given schema : " + purposeSchema);
            }
            long schemaRecordId = response.getRecordId();
            String schemaIdl = response.getIdl();
            Schema schema = new Schema.Parser().parse(schemaIdl);
            ByteBuffer buffer = ByteBuffer.allocate(8);
            encoder.writeBytes(buffer.putLong(schemaRecordId).array());
            Object datumWriter = record instanceof SpecificRecord ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
            datumWriter.write(record, (Encoder)encoder);
            encoder.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("serialize Avro message failed", e);
        }
        catch (RestClientException e) {
            throw new SerializationException("get target schema failed", e);
        }
    }

    @Override
    public void close() {
    }
}

