/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.EtcdMetadataStore;
import org.apache.pulsar.metadata.impl.LocalMemoryMetadataStore;
import org.apache.pulsar.metadata.impl.RocksdbMetadataStore;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;

public class MetadataStoreFactoryImpl {
    public static MetadataStore create(String metadataURL, MetadataStoreConfig metadataStoreConfig) throws MetadataStoreException {
        return MetadataStoreFactoryImpl.newInstance(metadataURL, metadataStoreConfig, false);
    }

    public static MetadataStoreExtended createExtended(String metadataURL, MetadataStoreConfig metadataStoreConfig) throws MetadataStoreException {
        MetadataStore store = MetadataStoreFactoryImpl.newInstance(metadataURL, metadataStoreConfig, true);
        if (!(store instanceof MetadataStoreExtended)) {
            throw new MetadataStoreException.InvalidImplementationException("Implementation does not comply with " + MetadataStoreExtended.class.getName());
        }
        return (MetadataStoreExtended)store;
    }

    private static MetadataStore newInstance(String metadataURL, MetadataStoreConfig metadataStoreConfig, boolean enableSessionWatcher) throws MetadataStoreException {
        if (metadataURL.startsWith("memory:")) {
            return new LocalMemoryMetadataStore(metadataURL, metadataStoreConfig);
        }
        if (metadataURL.startsWith("rocksdb:")) {
            return RocksdbMetadataStore.get(metadataURL, metadataStoreConfig);
        }
        if (metadataURL.startsWith("etcd:")) {
            return new EtcdMetadataStore(metadataURL, metadataStoreConfig, enableSessionWatcher);
        }
        if (metadataURL.startsWith("zk:")) {
            return new ZKMetadataStore(metadataURL.substring("zk:".length()), metadataStoreConfig, enableSessionWatcher);
        }
        return new ZKMetadataStore(metadataURL, metadataStoreConfig, enableSessionWatcher);
    }

    public static String removeIdentifierFromMetadataURL(String metadataURL) {
        if (metadataURL.startsWith("memory:")) {
            return metadataURL.substring("memory:".length());
        }
        if (metadataURL.startsWith("rocksdb:")) {
            return metadataURL.substring("rocksdb:".length());
        }
        if (metadataURL.startsWith("etcd:")) {
            return metadataURL.substring("etcd:".length());
        }
        if (metadataURL.startsWith("zk:")) {
            return metadataURL.substring("zk:".length());
        }
        return metadataURL;
    }

    public static boolean isBasedOnZookeeper(String metadataURL) {
        if (!metadataURL.contains("://")) {
            return true;
        }
        return metadataURL.startsWith("zk");
    }
}

