/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.common.protocol.schema.SchemaHash;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SchemaInfoImpl
implements SchemaInfo {
    private String name;
    private byte[] schema;
    private SchemaType type;
    private long timestamp;
    private Map<String, String> properties = Collections.emptyMap();
    @JsonIgnore
    private transient SchemaHash schemaHash;

    public SchemaInfoImpl(String name, byte[] schema, SchemaType type, long timestamp, Map<String, String> properties) {
        this.name = name;
        this.schema = schema;
        this.type = type;
        this.timestamp = timestamp;
        this.properties = properties == null ? Collections.emptyMap() : properties;
        this.schemaHash = SchemaHash.of(this.schema, this.type);
    }

    public String getSchemaDefinition() {
        if (null == this.schema) {
            return "";
        }
        switch (this.type) {
            case AVRO: 
            case JSON: 
            case PROTOBUF: 
            case PROTOBUF_NATIVE: {
                return new String(this.schema, StandardCharsets.UTF_8);
            }
            case KEY_VALUE: {
                KeyValue<SchemaInfo, SchemaInfo> schemaInfoKeyValue = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(this);
                return SchemaUtils.jsonifyKeyValueSchemaInfo(schemaInfoKeyValue);
            }
        }
        return Base64.getEncoder().encodeToString(this.schema);
    }

    public SchemaHash getSchemaHash() {
        if (this.schemaHash == null) {
            this.schemaHash = SchemaHash.of(this.schema, this.type);
        }
        return this.schemaHash;
    }

    public String toString() {
        return SchemaUtils.jsonifySchemaInfo(this);
    }

    public static SchemaInfoImplBuilder builder() {
        return new SchemaInfoImplBuilder();
    }

    public String getName() {
        return this.name;
    }

    public byte[] getSchema() {
        return this.schema;
    }

    public SchemaType getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public SchemaInfoImpl setName(String name) {
        this.name = name;
        return this;
    }

    public SchemaInfoImpl setSchema(byte[] schema) {
        this.schema = schema;
        return this;
    }

    public SchemaInfoImpl setType(SchemaType type) {
        this.type = type;
        return this;
    }

    public SchemaInfoImpl setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public SchemaInfoImpl setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    @JsonIgnore
    public SchemaInfoImpl setSchemaHash(SchemaHash schemaHash) {
        this.schemaHash = schemaHash;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaInfoImpl)) {
            return false;
        }
        SchemaInfoImpl other = (SchemaInfoImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (!Arrays.equals(this.getSchema(), other.getSchema())) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaInfoImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + Arrays.hashCode(this.getSchema());
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public SchemaInfoImpl() {
    }

    public static class SchemaInfoImplBuilder {
        private String name;
        private byte[] schema;
        private SchemaType type;
        private long timestamp;
        private Map<String, String> properties;

        SchemaInfoImplBuilder() {
        }

        public SchemaInfoImplBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SchemaInfoImplBuilder schema(byte[] schema) {
            this.schema = schema;
            return this;
        }

        public SchemaInfoImplBuilder type(SchemaType type) {
            this.type = type;
            return this;
        }

        public SchemaInfoImplBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SchemaInfoImplBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public SchemaInfoImpl build() {
            return new SchemaInfoImpl(this.name, this.schema, this.type, this.timestamp, this.properties);
        }

        public String toString() {
            return "SchemaInfoImpl.SchemaInfoImplBuilder(name=" + this.name + ", schema=" + Arrays.toString(this.schema) + ", type=" + this.type + ", timestamp=" + this.timestamp + ", properties=" + this.properties + ")";
        }
    }
}

