/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Properties;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Tenants;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class TenantsImpl
extends BaseResource
implements Tenants,
Properties {
    private final WebTarget adminTenants;

    public TenantsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminTenants = web.path("/admin/v2/tenants");
    }

    public List<String> getTenants() throws PulsarAdminException {
        return (List)this.sync(() -> this.getTenantsAsync());
    }

    public CompletableFuture<List<String>> getTenantsAsync() {
        return this.asyncGetRequest(this.adminTenants, new BaseResource.FutureCallback<List<String>>(){});
    }

    public TenantInfo getTenantInfo(String tenant) throws PulsarAdminException {
        return (TenantInfo)this.sync(() -> this.getTenantInfoAsync(tenant));
    }

    public CompletableFuture<TenantInfo> getTenantInfoAsync(String tenant) {
        WebTarget path = this.adminTenants.path(tenant);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TenantInfoImpl>(){}).thenApply(tenantInfo -> tenantInfo);
    }

    public void createTenant(String tenant, TenantInfo config) throws PulsarAdminException {
        this.sync(() -> this.createTenantAsync(tenant, config));
    }

    public CompletableFuture<Void> createTenantAsync(String tenant, TenantInfo config) {
        WebTarget path = this.adminTenants.path(tenant);
        return this.asyncPutRequest(path, Entity.entity(config, "application/json"));
    }

    public void updateTenant(String tenant, TenantInfo config) throws PulsarAdminException {
        this.sync(() -> this.updateTenantAsync(tenant, config));
    }

    public CompletableFuture<Void> updateTenantAsync(String tenant, TenantInfo config) {
        WebTarget path = this.adminTenants.path(tenant);
        return this.asyncPostRequest(path, Entity.entity((TenantInfoImpl)config, "application/json"));
    }

    public void deleteTenant(String tenant) throws PulsarAdminException {
        this.sync(() -> this.deleteTenantAsync(tenant));
    }

    public void deleteTenant(String tenant, boolean force) throws PulsarAdminException {
        this.sync(() -> this.deleteTenantAsync(tenant, force));
    }

    public CompletableFuture<Void> deleteTenantAsync(String tenant) {
        return this.deleteTenantAsync(tenant, false);
    }

    public CompletableFuture<Void> deleteTenantAsync(String tenant, boolean force) {
        WebTarget path = this.adminTenants.path(tenant);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    public void createProperty(String tenant, TenantInfo config) throws PulsarAdminException {
        this.createTenant(tenant, config);
    }

    public void updateProperty(String tenant, TenantInfo config) throws PulsarAdminException {
        this.updateTenant(tenant, config);
    }

    public void deleteProperty(String tenant) throws PulsarAdminException {
        this.deleteTenant(tenant);
    }

    public List<String> getProperties() throws PulsarAdminException {
        return this.getTenants();
    }

    public TenantInfo getPropertyAdmin(String tenant) throws PulsarAdminException {
        return this.getTenantInfo(tenant);
    }

    public WebTarget getWebTarget() {
        return this.adminTenants;
    }
}

