/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.admin.ListNamespaceTopicsOptions;
import org.apache.pulsar.client.admin.Namespaces;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.TopicHashPositions;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class NamespacesImpl
extends BaseResource
implements Namespaces {
    private final WebTarget adminNamespaces;
    private final WebTarget adminV2Namespaces;

    public NamespacesImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminNamespaces = web.path("/admin/namespaces");
        this.adminV2Namespaces = web.path("/admin/v2/namespaces");
    }

    public List<String> getNamespaces(String tenant) throws PulsarAdminException {
        return (List)this.sync(() -> this.getNamespacesAsync(tenant));
    }

    public CompletableFuture<List<String>> getNamespacesAsync(String tenant) {
        WebTarget path = this.adminV2Namespaces.path(tenant);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public List<String> getNamespaces(String tenant, String cluster) throws PulsarAdminException {
        return (List)this.sync(() -> this.getNamespacesAsync(tenant, cluster));
    }

    public CompletableFuture<List<String>> getNamespacesAsync(String tenant, String cluster) {
        WebTarget path = this.adminNamespaces.path(tenant).path(cluster);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public List<String> getTopics(String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.getTopicsAsync(namespace));
    }

    public BundlesData getBundles(String namespace) throws PulsarAdminException {
        return (BundlesData)this.sync(() -> this.getBundlesAsync(namespace));
    }

    public CompletableFuture<BundlesData> getBundlesAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<BundlesData>(){}, namespace, "bundles");
    }

    public CompletableFuture<List<String>> getTopicsAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<List<String>>(){}, namespace, NamespaceName.get(namespace).isV2() ? "topics" : "destinations");
    }

    public List<String> getTopics(String namespace, ListNamespaceTopicsOptions options) throws PulsarAdminException {
        return (List)this.sync(() -> this.getTopicsAsync(namespace, options));
    }

    public CompletableFuture<List<String>> getTopicsAsync(String namespace, ListNamespaceTopicsOptions options) {
        NamespaceName ns = NamespaceName.get(namespace);
        String action = ns.isV2() ? "topics" : "destinations";
        WebTarget path = this.namespacePath(ns, action);
        path = path.queryParam("mode", options.getMode()).queryParam("includeSystemTopic", options.isIncludeSystemTopic());
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public Policies getPolicies(String namespace) throws PulsarAdminException {
        return (Policies)this.sync(() -> this.getPoliciesAsync(namespace));
    }

    public CompletableFuture<Policies> getPoliciesAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Policies>(){}, namespace, new String[0]);
    }

    public void createNamespace(String namespace, Set<String> clusters) throws PulsarAdminException {
        this.sync(() -> this.createNamespaceAsync(namespace, clusters));
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace, Set<String> clusters) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        if (ns.isV2()) {
            Policies policies = new Policies();
            policies.replication_clusters = clusters;
            return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
        }
        return this.asyncPutRequest(path, Entity.entity("", "application/json")).thenAccept(ignore -> this.setNamespaceReplicationClustersAsync(namespace, clusters));
    }

    public void createNamespace(String namespace, int numBundles) throws PulsarAdminException {
        this.createNamespace(namespace, BundlesData.builder().numBundles(numBundles).build());
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace, int numBundles) {
        return this.createNamespaceAsync(namespace, BundlesData.builder().numBundles(numBundles).build());
    }

    public void createNamespace(String namespace, Policies policies) throws PulsarAdminException {
        this.sync(() -> this.createNamespaceAsync(namespace, policies));
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace, Policies policies) {
        NamespaceName ns = NamespaceName.get(namespace);
        Preconditions.checkArgument(ns.isV2(), "Create namespace with policies is only supported on newer namespaces");
        WebTarget path = this.namespacePath(ns, new String[0]);
        return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
    }

    public void createNamespace(String namespace, BundlesData bundlesData) throws PulsarAdminException {
        this.sync(() -> this.createNamespaceAsync(namespace, bundlesData));
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace, BundlesData bundlesData) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        if (ns.isV2()) {
            Policies policies = new Policies();
            policies.bundles = bundlesData;
            return this.asyncPutRequest(path, Entity.entity(policies, "application/json"));
        }
        return this.asyncPutRequest(path, Entity.entity(bundlesData, "application/json"));
    }

    public void createNamespace(String namespace) throws PulsarAdminException {
        this.sync(() -> this.createNamespaceAsync(namespace));
    }

    public CompletableFuture<Void> createNamespaceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public void deleteNamespace(String namespace) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceAsync(namespace));
    }

    public void deleteNamespace(String namespace, boolean force) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceAsync(namespace, force));
    }

    public CompletableFuture<Void> deleteNamespaceAsync(String namespace) {
        return this.deleteNamespaceAsync(namespace, false);
    }

    public CompletableFuture<Void> deleteNamespaceAsync(String namespace, boolean force) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, new String[0]);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    public void deleteNamespaceBundle(String namespace, String bundleRange) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceBundleAsync(namespace, bundleRange));
    }

    public void deleteNamespaceBundle(String namespace, String bundleRange, boolean force) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceBundleAsync(namespace, bundleRange, force));
    }

    public CompletableFuture<Void> deleteNamespaceBundleAsync(String namespace, String bundleRange) {
        return this.deleteNamespaceBundleAsync(namespace, bundleRange, false);
    }

    public CompletableFuture<Void> deleteNamespaceBundleAsync(String namespace, String bundleRange, boolean force) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundleRange);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, Set<AuthAction>> getPermissions(String namespace) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getPermissionsAsync(namespace));
    }

    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Map<String, Set<AuthAction>>>(){}, namespace, "permissions");
    }

    public void grantPermissionOnNamespace(String namespace, String role, Set<AuthAction> actions) throws PulsarAdminException {
        this.sync(() -> this.grantPermissionOnNamespaceAsync(namespace, role, actions));
    }

    public CompletableFuture<Void> grantPermissionOnNamespaceAsync(String namespace, String role, Set<AuthAction> actions) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", role);
        return this.asyncPostRequest(path, Entity.entity(actions, "application/json"));
    }

    public void revokePermissionsOnNamespace(String namespace, String role) throws PulsarAdminException {
        this.sync(() -> this.revokePermissionsOnNamespaceAsync(namespace, role));
    }

    public CompletableFuture<Void> revokePermissionsOnNamespaceAsync(String namespace, String role) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", role);
        return this.asyncDeleteRequest(path);
    }

    public Map<String, Set<String>> getPermissionOnSubscription(String namespace) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getPermissionOnSubscriptionAsync(namespace));
    }

    public CompletableFuture<Map<String, Set<String>>> getPermissionOnSubscriptionAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Map<String, Set<String>>>(){}, namespace, "permissions", "subscription");
    }

    public void grantPermissionOnSubscription(String namespace, String subscription, Set<String> roles) throws PulsarAdminException {
        this.sync(() -> this.grantPermissionOnSubscriptionAsync(namespace, subscription, roles));
    }

    public CompletableFuture<Void> grantPermissionOnSubscriptionAsync(String namespace, String subscription, Set<String> roles) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", "subscription", subscription);
        return this.asyncPostRequest(path, Entity.entity(roles, "application/json"));
    }

    public void revokePermissionOnSubscription(String namespace, String subscription, String role) throws PulsarAdminException {
        this.sync(() -> this.revokePermissionOnSubscriptionAsync(namespace, subscription, role));
    }

    public CompletableFuture<Void> revokePermissionOnSubscriptionAsync(String namespace, String subscription, String role) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "permissions", subscription, role);
        return this.asyncDeleteRequest(path);
    }

    public List<String> getNamespaceReplicationClusters(String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.getNamespaceReplicationClustersAsync(namespace));
    }

    public CompletableFuture<List<String>> getNamespaceReplicationClustersAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<List<String>>(){}, namespace, "replication");
    }

    public void setNamespaceReplicationClusters(String namespace, Set<String> clusterIds) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceReplicationClustersAsync(namespace, clusterIds));
    }

    public CompletableFuture<Void> setNamespaceReplicationClustersAsync(String namespace, Set<String> clusterIds) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replication");
        return this.asyncPostRequest(path, Entity.entity(clusterIds, "application/json"));
    }

    public Integer getNamespaceMessageTTL(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getNamespaceMessageTTLAsync(namespace));
    }

    public CompletableFuture<Integer> getNamespaceMessageTTLAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "messageTTL");
    }

    public void setNamespaceMessageTTL(String namespace, int ttlInSeconds) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceMessageTTLAsync(namespace, ttlInSeconds));
    }

    public CompletableFuture<Void> setNamespaceMessageTTLAsync(String namespace, int ttlInSeconds) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "messageTTL");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(ttlInSeconds), "application/json"));
    }

    public void removeNamespaceMessageTTL(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeNamespaceMessageTTLAsync(namespace));
    }

    public CompletableFuture<Void> removeNamespaceMessageTTLAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "messageTTL");
        return this.asyncDeleteRequest(path);
    }

    public Integer getSubscriptionExpirationTime(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getSubscriptionExpirationTimeAsync(namespace));
    }

    public CompletableFuture<Integer> getSubscriptionExpirationTimeAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "subscriptionExpirationTime");
    }

    public void setSubscriptionExpirationTime(String namespace, int expirationTime) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionExpirationTimeAsync(namespace, expirationTime));
    }

    public CompletableFuture<Void> setSubscriptionExpirationTimeAsync(String namespace, int expirationTime) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionExpirationTime");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(expirationTime), "application/json"));
    }

    public void removeSubscriptionExpirationTime(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionExpirationTimeAsync(namespace));
    }

    public CompletableFuture<Void> removeSubscriptionExpirationTimeAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionExpirationTime");
        return this.asyncDeleteRequest(path);
    }

    public void setNamespaceAntiAffinityGroup(String namespace, String namespaceAntiAffinityGroup) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceAntiAffinityGroupAsync(namespace, namespaceAntiAffinityGroup));
    }

    public CompletableFuture<Void> setNamespaceAntiAffinityGroupAsync(String namespace, String namespaceAntiAffinityGroup) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "antiAffinity");
        return this.asyncPostRequest(path, Entity.entity(namespaceAntiAffinityGroup, "application/json"));
    }

    public String getNamespaceAntiAffinityGroup(String namespace) throws PulsarAdminException {
        return (String)this.sync(() -> this.getNamespaceAntiAffinityGroupAsync(namespace));
    }

    public CompletableFuture<String> getNamespaceAntiAffinityGroupAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<String>(){}, namespace, "antiAffinity");
    }

    public List<String> getAntiAffinityNamespaces(String tenant, String cluster, String namespaceAntiAffinityGroup) throws PulsarAdminException {
        return (List)this.sync(() -> this.getAntiAffinityNamespacesAsync(tenant, cluster, namespaceAntiAffinityGroup));
    }

    public CompletableFuture<List<String>> getAntiAffinityNamespacesAsync(String tenant, String cluster, String namespaceAntiAffinityGroup) {
        WebTarget path = this.adminNamespaces.path(cluster).path("antiAffinity").path(namespaceAntiAffinityGroup).queryParam("property", tenant);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public void deleteNamespaceAntiAffinityGroup(String namespace) throws PulsarAdminException {
        this.sync(() -> this.deleteNamespaceAntiAffinityGroupAsync(namespace));
    }

    public CompletableFuture<Void> deleteNamespaceAntiAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "antiAffinity");
        return this.asyncDeleteRequest(path);
    }

    public void removeDeduplicationStatus(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeDeduplicationStatusAsync(namespace));
    }

    public CompletableFuture<Void> removeDeduplicationStatusAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplication");
        return this.asyncDeleteRequest(path);
    }

    public Boolean getDeduplicationStatus(String namespace) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getDeduplicationStatusAsync(namespace));
    }

    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Boolean>(){}, namespace, "deduplication");
    }

    public void setDeduplicationStatus(String namespace, boolean enableDeduplication) throws PulsarAdminException {
        this.sync(() -> this.setDeduplicationStatusAsync(namespace, enableDeduplication));
    }

    public CompletableFuture<Void> setDeduplicationStatusAsync(String namespace, boolean enableDeduplication) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplication");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(enableDeduplication), "application/json"));
    }

    public void setAutoTopicCreation(String namespace, AutoTopicCreationOverride autoTopicCreationOverride) throws PulsarAdminException {
        this.sync(() -> this.setAutoTopicCreationAsync(namespace, autoTopicCreationOverride));
    }

    public CompletableFuture<Void> setAutoTopicCreationAsync(String namespace, AutoTopicCreationOverride autoTopicCreationOverride) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoTopicCreation");
        return this.asyncPostRequest(path, Entity.entity(autoTopicCreationOverride, "application/json"));
    }

    public AutoTopicCreationOverride getAutoTopicCreation(String namespace) throws PulsarAdminException {
        return (AutoTopicCreationOverride)this.sync(() -> this.getAutoTopicCreationAsync(namespace));
    }

    public CompletableFuture<AutoTopicCreationOverride> getAutoTopicCreationAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<AutoTopicCreationOverride>(){}, namespace, "autoTopicCreation");
    }

    public void removeAutoTopicCreation(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeAutoTopicCreationAsync(namespace));
    }

    public CompletableFuture<Void> removeAutoTopicCreationAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoTopicCreation");
        return this.asyncDeleteRequest(path);
    }

    public void setAutoSubscriptionCreation(String namespace, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) throws PulsarAdminException {
        this.sync(() -> this.setAutoSubscriptionCreationAsync(namespace, autoSubscriptionCreationOverride));
    }

    public CompletableFuture<Void> setAutoSubscriptionCreationAsync(String namespace, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoSubscriptionCreation");
        return this.asyncPostRequest(path, Entity.entity(autoSubscriptionCreationOverride, "application/json"));
    }

    public AutoSubscriptionCreationOverride getAutoSubscriptionCreation(String namespace) throws PulsarAdminException {
        return (AutoSubscriptionCreationOverride)this.sync(() -> this.getAutoSubscriptionCreationAsync(namespace));
    }

    public CompletableFuture<AutoSubscriptionCreationOverride> getAutoSubscriptionCreationAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<AutoSubscriptionCreationOverride>(){}, namespace, "autoSubscriptionCreation");
    }

    public void setSubscriptionTypesEnabled(String namespace, Set<SubscriptionType> subscriptionTypesEnabled) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionTypesEnabledAsync(namespace, subscriptionTypesEnabled));
    }

    public CompletableFuture<Void> setSubscriptionTypesEnabledAsync(String namespace, Set<SubscriptionType> subscriptionTypes) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionTypesEnabled");
        return this.asyncPostRequest(path, Entity.entity(subscriptionTypes, "application/json"));
    }

    public Set<SubscriptionType> getSubscriptionTypesEnabled(String namespace) throws PulsarAdminException {
        return (Set)this.sync(() -> this.getSubscriptionTypesEnabledAsync(namespace));
    }

    public CompletableFuture<Set<SubscriptionType>> getSubscriptionTypesEnabledAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Set<SubscriptionType>>(){}, namespace, "subscriptionTypesEnabled");
    }

    public void removeSubscriptionTypesEnabled(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionTypesEnabledAsync(namespace));
    }

    public CompletableFuture<Void> removeSubscriptionTypesEnabledAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionTypesEnabled");
        return this.asyncDeleteRequest(path);
    }

    public void removeAutoSubscriptionCreation(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeAutoSubscriptionCreationAsync(namespace));
    }

    public CompletableFuture<Void> removeAutoSubscriptionCreationAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "autoSubscriptionCreation");
        return this.asyncDeleteRequest(path);
    }

    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String namespace) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getBacklogQuotaMapAsync(namespace));
    }

    public CompletableFuture<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>> getBacklogQuotaMapAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>(){}, namespace, "backlogQuotaMap");
    }

    public void setBacklogQuota(String namespace, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        this.sync(() -> this.setBacklogQuotaAsync(namespace, backlogQuota, backlogQuotaType));
    }

    public CompletableFuture<Void> setBacklogQuotaAsync(String namespace, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "backlogQuota");
        return this.asyncPostRequest(path.queryParam("backlogQuotaType", backlogQuotaType.toString()), Entity.entity(backlogQuota, "application/json"));
    }

    public void removeBacklogQuota(String namespace, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        this.sync(() -> this.removeBacklogQuotaAsync(namespace, backlogQuotaType));
    }

    public void removeInactiveTopicPolicies(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeInactiveTopicPoliciesAsync(namespace));
    }

    public CompletableFuture<Void> removeInactiveTopicPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "inactiveTopicPolicies");
        return this.asyncDeleteRequest(path);
    }

    public CompletableFuture<Void> removeBacklogQuotaAsync(String namespace, BacklogQuota.BacklogQuotaType backlogQuotaType) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "backlogQuota").queryParam("backlogQuotaType", backlogQuotaType.toString());
        return this.asyncDeleteRequest(path);
    }

    public void removePersistence(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removePersistenceAsync(namespace));
    }

    public CompletableFuture<Void> removePersistenceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence");
        return this.asyncDeleteRequest(path);
    }

    public void setPersistence(String namespace, PersistencePolicies persistence) throws PulsarAdminException {
        this.sync(() -> this.setPersistenceAsync(namespace, persistence));
    }

    public CompletableFuture<Void> setPersistenceAsync(String namespace, PersistencePolicies persistence) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence");
        return this.asyncPostRequest(path, Entity.entity(persistence, "application/json"));
    }

    public void setBookieAffinityGroup(String namespace, BookieAffinityGroupData bookieAffinityGroup) throws PulsarAdminException {
        this.sync(() -> this.setBookieAffinityGroupAsync(namespace, bookieAffinityGroup));
    }

    public CompletableFuture<Void> setBookieAffinityGroupAsync(String namespace, BookieAffinityGroupData bookieAffinityGroup) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
        return this.asyncPostRequest(path, Entity.entity(bookieAffinityGroup, "application/json"));
    }

    public void deleteBookieAffinityGroup(String namespace) throws PulsarAdminException {
        this.sync(() -> this.deleteBookieAffinityGroupAsync(namespace));
    }

    public CompletableFuture<Void> deleteBookieAffinityGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "persistence", "bookieAffinity");
        return this.asyncDeleteRequest(path);
    }

    public BookieAffinityGroupData getBookieAffinityGroup(String namespace) throws PulsarAdminException {
        return (BookieAffinityGroupData)this.sync(() -> this.getBookieAffinityGroupAsync(namespace));
    }

    public CompletableFuture<BookieAffinityGroupData> getBookieAffinityGroupAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<BookieAffinityGroupData>(){}, namespace, "persistence", "bookieAffinity");
    }

    public PersistencePolicies getPersistence(String namespace) throws PulsarAdminException {
        return (PersistencePolicies)this.sync(() -> this.getPersistenceAsync(namespace));
    }

    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<PersistencePolicies>(){}, namespace, "persistence");
    }

    public void setRetention(String namespace, RetentionPolicies retention) throws PulsarAdminException {
        this.sync(() -> this.setRetentionAsync(namespace, retention));
    }

    public CompletableFuture<Void> setRetentionAsync(String namespace, RetentionPolicies retention) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "retention");
        return this.asyncPostRequest(path, Entity.entity(retention, "application/json"));
    }

    public void removeRetention(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeRetentionAsync(namespace));
    }

    public CompletableFuture<Void> removeRetentionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "retention");
        return this.asyncDeleteRequest(path);
    }

    public RetentionPolicies getRetention(String namespace) throws PulsarAdminException {
        return (RetentionPolicies)this.sync(() -> this.getRetentionAsync(namespace));
    }

    public CompletableFuture<RetentionPolicies> getRetentionAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<RetentionPolicies>(){}, namespace, "retention");
    }

    public void unload(String namespace) throws PulsarAdminException {
        this.sync(() -> this.unloadAsync(namespace));
    }

    public CompletableFuture<Void> unloadAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public String getReplicationConfigVersion(String namespace) throws PulsarAdminException {
        return (String)this.sync(() -> this.getReplicationConfigVersionAsync(namespace));
    }

    public CompletableFuture<String> getReplicationConfigVersionAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<String>(){}, namespace, "configversion");
    }

    public void unloadNamespaceBundle(String namespace, String bundle) throws PulsarAdminException {
        this.sync(() -> this.unloadNamespaceBundleAsync(namespace, bundle));
    }

    public CompletableFuture<Void> unloadNamespaceBundleAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public void splitNamespaceBundle(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName) throws PulsarAdminException {
        this.splitNamespaceBundle(namespace, bundle, unloadSplitBundles, splitAlgorithmName, null);
    }

    public CompletableFuture<Void> splitNamespaceBundleAsync(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName) {
        return this.splitNamespaceBundleAsync(namespace, bundle, unloadSplitBundles, splitAlgorithmName, null);
    }

    public void splitNamespaceBundle(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName, List<Long> splitBoundaries) throws PulsarAdminException {
        this.sync(() -> this.splitNamespaceBundleAsync(namespace, bundle, unloadSplitBundles, splitAlgorithmName, splitBoundaries));
    }

    public CompletableFuture<Void> splitNamespaceBundleAsync(String namespace, String bundle, boolean unloadSplitBundles, String splitAlgorithmName, List<Long> splitBoundaries) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "split").queryParam("unload", Boolean.toString(unloadSplitBundles)).queryParam("splitAlgorithmName", splitAlgorithmName);
        return splitBoundaries == null || splitBoundaries.size() == 0 ? this.asyncPutRequest(path, Entity.entity("", "application/json")) : this.asyncPutRequest(path, Entity.entity(splitBoundaries, "application/json"));
    }

    public TopicHashPositions getTopicHashPositions(String namespace, String bundle, List<String> topics) throws PulsarAdminException {
        return (TopicHashPositions)this.sync(() -> this.getTopicHashPositionsAsync(namespace, bundle, topics));
    }

    public CompletableFuture<TopicHashPositions> getTopicHashPositionsAsync(String namespace, String bundle, List<String> topics) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "topicHashPositions");
        if (topics != null && topics.size() > 0) {
            path = path.queryParam("topics", topics.stream().map(Codec::encode).toArray());
        }
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<TopicHashPositions>(){});
    }

    public void setPublishRate(String namespace, PublishRate publishMsgRate) throws PulsarAdminException {
        this.sync(() -> this.setPublishRateAsync(namespace, publishMsgRate));
    }

    public void removePublishRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removePublishRateAsync(namespace));
    }

    public CompletableFuture<Void> setPublishRateAsync(String namespace, PublishRate publishMsgRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "publishRate");
        return this.asyncPostRequest(path, Entity.entity(publishMsgRate, "application/json"));
    }

    public CompletableFuture<Void> removePublishRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "publishRate");
        return this.asyncDeleteRequest(path);
    }

    public PublishRate getPublishRate(String namespace) throws PulsarAdminException {
        return (PublishRate)this.sync(() -> this.getPublishRateAsync(namespace));
    }

    public CompletableFuture<PublishRate> getPublishRateAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<PublishRate>(){}, namespace, "publishRate");
    }

    public void removeDispatchRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeDispatchRateAsync(namespace));
    }

    public CompletableFuture<Void> removeDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "dispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public void setDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setDispatchRateAsync(namespace, dispatchRate));
    }

    public CompletableFuture<Void> setDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "dispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public DispatchRate getDispatchRate(String namespace) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getDispatchRateAsync(namespace));
    }

    public CompletableFuture<DispatchRate> getDispatchRateAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<DispatchRate>(){}, namespace, "dispatchRate");
    }

    public void setSubscribeRate(String namespace, SubscribeRate subscribeRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscribeRateAsync(namespace, subscribeRate));
    }

    public CompletableFuture<Void> setSubscribeRateAsync(String namespace, SubscribeRate subscribeRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscribeRate");
        return this.asyncPostRequest(path, Entity.entity(subscribeRate, "application/json"));
    }

    public void removeSubscribeRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeSubscribeRateAsync(namespace));
    }

    public CompletableFuture<Void> removeSubscribeRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscribeRate");
        return this.asyncDeleteRequest(path);
    }

    public SubscribeRate getSubscribeRate(String namespace) throws PulsarAdminException {
        return (SubscribeRate)this.sync(() -> this.getSubscribeRateAsync(namespace));
    }

    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<SubscribeRate>(){}, namespace, "subscribeRate");
    }

    public void removeSubscriptionDispatchRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionDispatchRateAsync(namespace));
    }

    public CompletableFuture<Void> removeSubscriptionDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public void setSubscriptionDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionDispatchRateAsync(namespace, dispatchRate));
    }

    public CompletableFuture<Void> setSubscriptionDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public DispatchRate getSubscriptionDispatchRate(String namespace) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getSubscriptionDispatchRateAsync(namespace));
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<DispatchRate>(){}, namespace, "subscriptionDispatchRate");
    }

    public void setReplicatorDispatchRate(String namespace, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setReplicatorDispatchRateAsync(namespace, dispatchRate));
    }

    public CompletableFuture<Void> setReplicatorDispatchRateAsync(String namespace, DispatchRate dispatchRate) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public void removeReplicatorDispatchRate(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeReplicatorDispatchRateAsync(namespace));
    }

    public CompletableFuture<Void> removeReplicatorDispatchRateAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "replicatorDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getReplicatorDispatchRate(String namespace) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getReplicatorDispatchRateAsync(namespace));
    }

    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<DispatchRate>(){}, namespace, "replicatorDispatchRate");
    }

    public void clearNamespaceBacklog(String namespace) throws PulsarAdminException {
        this.sync(() -> this.clearNamespaceBacklogAsync(namespace));
    }

    public CompletableFuture<Void> clearNamespaceBacklogAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "clearBacklog");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void clearNamespaceBacklogForSubscription(String namespace, String subscription) throws PulsarAdminException {
        this.sync(() -> this.clearNamespaceBacklogForSubscriptionAsync(namespace, subscription));
    }

    public CompletableFuture<Void> clearNamespaceBacklogForSubscriptionAsync(String namespace, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "clearBacklog", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void clearNamespaceBundleBacklog(String namespace, String bundle) throws PulsarAdminException {
        this.sync(() -> this.clearNamespaceBundleBacklogAsync(namespace, bundle));
    }

    public CompletableFuture<Void> clearNamespaceBundleBacklogAsync(String namespace, String bundle) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "clearBacklog");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void clearNamespaceBundleBacklogForSubscription(String namespace, String bundle, String subscription) throws PulsarAdminException {
        this.sync(() -> this.clearNamespaceBundleBacklogForSubscriptionAsync(namespace, bundle, subscription));
    }

    public CompletableFuture<Void> clearNamespaceBundleBacklogForSubscriptionAsync(String namespace, String bundle, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "clearBacklog", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void unsubscribeNamespace(String namespace, String subscription) throws PulsarAdminException {
        this.sync(() -> this.unsubscribeNamespaceAsync(namespace, subscription));
    }

    public CompletableFuture<Void> unsubscribeNamespaceAsync(String namespace, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "unsubscribe", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void unsubscribeNamespaceBundle(String namespace, String bundle, String subscription) throws PulsarAdminException {
        this.sync(() -> this.unsubscribeNamespaceBundleAsync(namespace, bundle, subscription));
    }

    public CompletableFuture<Void> unsubscribeNamespaceBundleAsync(String namespace, String bundle, String subscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, bundle, "unsubscribe", subscription);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void setSubscriptionAuthMode(String namespace, SubscriptionAuthMode subscriptionAuthMode) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionAuthModeAsync(namespace, subscriptionAuthMode));
    }

    public CompletableFuture<Void> setSubscriptionAuthModeAsync(String namespace, SubscriptionAuthMode subscriptionAuthMode) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "subscriptionAuthMode");
        return this.asyncPostRequest(path, Entity.entity(subscriptionAuthMode, "application/json"));
    }

    public SubscriptionAuthMode getSubscriptionAuthMode(String namespace) throws PulsarAdminException {
        return (SubscriptionAuthMode)this.sync(() -> this.getSubscriptionAuthModeAsync(namespace));
    }

    public CompletableFuture<SubscriptionAuthMode> getSubscriptionAuthModeAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<SubscriptionAuthMode>(){}, namespace, "subscriptionAuthMode");
    }

    public void setEncryptionRequiredStatus(String namespace, boolean encryptionRequired) throws PulsarAdminException {
        this.sync(() -> this.setEncryptionRequiredStatusAsync(namespace, encryptionRequired));
    }

    public CompletableFuture<Void> setEncryptionRequiredStatusAsync(String namespace, boolean encryptionRequired) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "encryptionRequired");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(encryptionRequired), "application/json"));
    }

    public Boolean getEncryptionRequiredStatus(String namespace) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getEncryptionRequiredStatusAsync(namespace));
    }

    public CompletableFuture<Boolean> getEncryptionRequiredStatusAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Boolean>(){}, namespace, "encryptionRequired");
    }

    public DelayedDeliveryPolicies getDelayedDelivery(String namespace) throws PulsarAdminException {
        return (DelayedDeliveryPolicies)this.sync(() -> this.getDelayedDeliveryAsync(namespace));
    }

    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<DelayedDeliveryPolicies>(){}, namespace, "delayedDelivery");
    }

    public void setDelayedDeliveryMessages(String namespace, DelayedDeliveryPolicies delayedDeliveryPolicies) throws PulsarAdminException {
        this.sync(() -> this.setDelayedDeliveryMessagesAsync(namespace, delayedDeliveryPolicies));
    }

    public CompletableFuture<Void> setDelayedDeliveryMessagesAsync(String namespace, DelayedDeliveryPolicies delayedDeliveryPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "delayedDelivery");
        return this.asyncPostRequest(path, Entity.entity(delayedDeliveryPolicies, "application/json"));
    }

    public void removeDelayedDeliveryMessages(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeDelayedDeliveryMessagesAsync(namespace));
    }

    public CompletableFuture<Void> removeDelayedDeliveryMessagesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "delayedDelivery");
        return this.asyncDeleteRequest(path);
    }

    public InactiveTopicPolicies getInactiveTopicPolicies(String namespace) throws PulsarAdminException {
        return (InactiveTopicPolicies)this.sync(() -> this.getInactiveTopicPoliciesAsync(namespace));
    }

    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<InactiveTopicPolicies>(){}, namespace, "inactiveTopicPolicies");
    }

    public void setInactiveTopicPolicies(String namespace, InactiveTopicPolicies inactiveTopicPolicies) throws PulsarAdminException {
        this.sync(() -> this.setInactiveTopicPoliciesAsync(namespace, inactiveTopicPolicies));
    }

    public CompletableFuture<Void> setInactiveTopicPoliciesAsync(String namespace, InactiveTopicPolicies inactiveTopicPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "inactiveTopicPolicies");
        return this.asyncPostRequest(path, Entity.entity(inactiveTopicPolicies, "application/json"));
    }

    public Integer getDeduplicationSnapshotInterval(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getDeduplicationSnapshotIntervalAsync(namespace));
    }

    public CompletableFuture<Integer> getDeduplicationSnapshotIntervalAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "deduplicationSnapshotInterval");
    }

    public void setDeduplicationSnapshotInterval(String namespace, Integer interval) throws PulsarAdminException {
        this.sync(() -> this.setDeduplicationSnapshotIntervalAsync(namespace, interval));
    }

    public CompletableFuture<Void> setDeduplicationSnapshotIntervalAsync(String namespace, Integer interval) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "deduplicationSnapshotInterval");
        return this.asyncPostRequest(path, Entity.entity(interval, "application/json"));
    }

    public void removeDeduplicationSnapshotInterval(String namespace) throws PulsarAdminException {
        this.setDeduplicationSnapshotInterval(namespace, null);
    }

    public CompletableFuture<Void> removeDeduplicationSnapshotIntervalAsync(String namespace) {
        return this.setDeduplicationSnapshotIntervalAsync(namespace, null);
    }

    public Integer getMaxSubscriptionsPerTopic(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxSubscriptionsPerTopicAsync(namespace));
    }

    public CompletableFuture<Integer> getMaxSubscriptionsPerTopicAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "maxSubscriptionsPerTopic");
    }

    public void setMaxSubscriptionsPerTopic(String namespace, int maxSubscriptionsPerTopic) throws PulsarAdminException {
        this.sync(() -> this.setMaxSubscriptionsPerTopicAsync(namespace, maxSubscriptionsPerTopic));
    }

    public CompletableFuture<Void> setMaxSubscriptionsPerTopicAsync(String namespace, int maxSubscriptionsPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxSubscriptionsPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxSubscriptionsPerTopic), "application/json"));
    }

    public void removeMaxSubscriptionsPerTopic(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxSubscriptionsPerTopicAsync(namespace));
    }

    public CompletableFuture<Void> removeMaxSubscriptionsPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxSubscriptionsPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxProducersPerTopic(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxProducersPerTopicAsync(namespace));
    }

    public CompletableFuture<Integer> getMaxProducersPerTopicAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "maxProducersPerTopic");
    }

    public void setMaxProducersPerTopic(String namespace, int maxProducersPerTopic) throws PulsarAdminException {
        this.sync(() -> this.setMaxProducersPerTopicAsync(namespace, maxProducersPerTopic));
    }

    public CompletableFuture<Void> setMaxProducersPerTopicAsync(String namespace, int maxProducersPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxProducersPerTopic), "application/json"));
    }

    public void removeMaxProducersPerTopic(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxProducersPerTopicAsync(namespace));
    }

    public CompletableFuture<Void> removeMaxProducersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxProducersPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumersPerTopic(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxConsumersPerTopicAsync(namespace));
    }

    public CompletableFuture<Integer> getMaxConsumersPerTopicAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "maxConsumersPerTopic");
    }

    public void setMaxConsumersPerTopic(String namespace, int maxConsumersPerTopic) throws PulsarAdminException {
        this.sync(() -> this.setMaxConsumersPerTopicAsync(namespace, maxConsumersPerTopic));
    }

    public CompletableFuture<Void> setMaxConsumersPerTopicAsync(String namespace, int maxConsumersPerTopic) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumersPerTopic), "application/json"));
    }

    public void removeMaxConsumersPerTopic(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxConsumersPerTopicAsync(namespace));
    }

    public CompletableFuture<Void> removeMaxConsumersPerTopicAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumersPerSubscription(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxConsumersPerSubscriptionAsync(namespace));
    }

    public CompletableFuture<Integer> getMaxConsumersPerSubscriptionAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "maxConsumersPerSubscription");
    }

    public void setMaxConsumersPerSubscription(String namespace, int maxConsumersPerSubscription) throws PulsarAdminException {
        this.sync(() -> this.setMaxConsumersPerSubscriptionAsync(namespace, maxConsumersPerSubscription));
    }

    public CompletableFuture<Void> setMaxConsumersPerSubscriptionAsync(String namespace, int maxConsumersPerSubscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumersPerSubscription), "application/json"));
    }

    public void removeMaxConsumersPerSubscription(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxConsumersPerSubscriptionAsync(namespace));
    }

    public CompletableFuture<Void> removeMaxConsumersPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxConsumersPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxUnackedMessagesPerConsumer(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxUnackedMessagesPerConsumerAsync(namespace));
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesPerConsumerAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "maxUnackedMessagesPerConsumer");
    }

    public void setMaxUnackedMessagesPerConsumer(String namespace, int maxUnackedMessagesPerConsumer) throws PulsarAdminException {
        this.sync(() -> this.setMaxUnackedMessagesPerConsumerAsync(namespace, maxUnackedMessagesPerConsumer));
    }

    public CompletableFuture<Void> setMaxUnackedMessagesPerConsumerAsync(String namespace, int maxUnackedMessagesPerConsumer) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerConsumer");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxUnackedMessagesPerConsumer), "application/json"));
    }

    public void removeMaxUnackedMessagesPerConsumer(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxUnackedMessagesPerConsumerAsync(namespace));
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesPerConsumerAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerConsumer");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxUnackedMessagesPerSubscription(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxUnackedMessagesPerSubscriptionAsync(namespace));
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesPerSubscriptionAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "maxUnackedMessagesPerSubscription");
    }

    public void setMaxUnackedMessagesPerSubscription(String namespace, int maxUnackedMessagesPerSubscription) throws PulsarAdminException {
        this.sync(() -> this.setMaxUnackedMessagesPerSubscriptionAsync(namespace, maxUnackedMessagesPerSubscription));
    }

    public CompletableFuture<Void> setMaxUnackedMessagesPerSubscriptionAsync(String namespace, int maxUnackedMessagesPerSubscription) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxUnackedMessagesPerSubscription), "application/json"));
    }

    public void removeMaxUnackedMessagesPerSubscription(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxUnackedMessagesPerSubscriptionAsync(namespace));
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesPerSubscriptionAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxUnackedMessagesPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    public Long getCompactionThreshold(String namespace) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getCompactionThresholdAsync(namespace));
    }

    public CompletableFuture<Long> getCompactionThresholdAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Long>(){}, namespace, "compactionThreshold");
    }

    public void setCompactionThreshold(String namespace, long compactionThreshold) throws PulsarAdminException {
        this.sync(() -> this.setCompactionThresholdAsync(namespace, compactionThreshold));
    }

    public CompletableFuture<Void> setCompactionThresholdAsync(String namespace, long compactionThreshold) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "compactionThreshold");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(compactionThreshold), "application/json"));
    }

    public void removeCompactionThreshold(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeCompactionThresholdAsync(namespace));
    }

    public CompletableFuture<Void> removeCompactionThresholdAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "compactionThreshold");
        return this.asyncDeleteRequest(path);
    }

    public long getOffloadThreshold(String namespace) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getOffloadThresholdAsync(namespace));
    }

    public CompletableFuture<Long> getOffloadThresholdAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Long>(){}, namespace, "offloadThreshold");
    }

    public void setOffloadThreshold(String namespace, long offloadThreshold) throws PulsarAdminException {
        this.sync(() -> this.setOffloadThresholdAsync(namespace, offloadThreshold));
    }

    public CompletableFuture<Void> setOffloadThresholdAsync(String namespace, long offloadThreshold) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadThreshold");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(offloadThreshold), "application/json"));
    }

    public Long getOffloadDeleteLagMs(String namespace) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getOffloadDeleteLagMsAsync(namespace));
    }

    public CompletableFuture<Long> getOffloadDeleteLagMsAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Long>(){}, namespace, "offloadDeletionLagMs");
    }

    public void setOffloadDeleteLag(String namespace, long lag, TimeUnit unit) throws PulsarAdminException {
        this.sync(() -> this.setOffloadDeleteLagAsync(namespace, lag, unit));
    }

    public CompletableFuture<Void> setOffloadDeleteLagAsync(String namespace, long lag, TimeUnit unit) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
        return this.asyncPutRequest(path, Entity.entity(Long.valueOf(TimeUnit.MILLISECONDS.convert(lag, unit)), "application/json"));
    }

    public void clearOffloadDeleteLag(String namespace) throws PulsarAdminException {
        this.sync(() -> this.clearOffloadDeleteLagAsync(namespace));
    }

    public CompletableFuture<Void> clearOffloadDeleteLagAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadDeletionLagMs");
        return this.asyncDeleteRequest(path);
    }

    public SchemaAutoUpdateCompatibilityStrategy getSchemaAutoUpdateCompatibilityStrategy(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaAutoUpdateCompatibilityStrategy");
            return this.request(path).get(SchemaAutoUpdateCompatibilityStrategy.class);
        }
        catch (Exception e) {
            throw NamespacesImpl.getApiException(e);
        }
    }

    public void setSchemaAutoUpdateCompatibilityStrategy(String namespace, SchemaAutoUpdateCompatibilityStrategy strategy) throws PulsarAdminException {
        try {
            NamespaceName ns = NamespaceName.get(namespace);
            WebTarget path = this.namespacePath(ns, "schemaAutoUpdateCompatibilityStrategy");
            this.request(path).put(Entity.entity(strategy, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw NamespacesImpl.getApiException(e);
        }
    }

    public boolean getSchemaValidationEnforced(String namespace) throws PulsarAdminException {
        return this.getSchemaValidationEnforced(namespace, false);
    }

    public CompletableFuture<Boolean> getSchemaValidationEnforcedAsync(String namespace) {
        return this.getSchemaValidationEnforcedAsync(namespace, false);
    }

    public boolean getSchemaValidationEnforced(String namespace, boolean applied) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getSchemaValidationEnforcedAsync(namespace, applied));
    }

    public CompletableFuture<Boolean> getSchemaValidationEnforcedAsync(String namespace, boolean applied) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaValidationEnforced");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Boolean>(){});
    }

    public void setSchemaValidationEnforced(String namespace, boolean schemaValidationEnforced) throws PulsarAdminException {
        this.sync(() -> this.setSchemaValidationEnforcedAsync(namespace, schemaValidationEnforced));
    }

    public CompletableFuture<Void> setSchemaValidationEnforcedAsync(String namespace, boolean schemaValidationEnforced) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaValidationEnforced");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(schemaValidationEnforced), "application/json"));
    }

    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy(String namespace) throws PulsarAdminException {
        return (SchemaCompatibilityStrategy)this.sync(() -> this.getSchemaCompatibilityStrategyAsync(namespace));
    }

    public CompletableFuture<SchemaCompatibilityStrategy> getSchemaCompatibilityStrategyAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<SchemaCompatibilityStrategy>(){}, namespace, "schemaCompatibilityStrategy");
    }

    public void setSchemaCompatibilityStrategy(String namespace, SchemaCompatibilityStrategy strategy) throws PulsarAdminException {
        this.sync(() -> this.setSchemaCompatibilityStrategyAsync(namespace, strategy));
    }

    public CompletableFuture<Void> setSchemaCompatibilityStrategyAsync(String namespace, SchemaCompatibilityStrategy strategy) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "schemaCompatibilityStrategy");
        return this.asyncPutRequest(path, Entity.entity(strategy, "application/json"));
    }

    public boolean getIsAllowAutoUpdateSchema(String namespace) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getIsAllowAutoUpdateSchemaAsync(namespace));
    }

    public CompletableFuture<Boolean> getIsAllowAutoUpdateSchemaAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Boolean>(){}, namespace, "isAllowAutoUpdateSchema");
    }

    public void setIsAllowAutoUpdateSchema(String namespace, boolean isAllowAutoUpdateSchema) throws PulsarAdminException {
        this.sync(() -> this.setIsAllowAutoUpdateSchemaAsync(namespace, isAllowAutoUpdateSchema));
    }

    public CompletableFuture<Void> setIsAllowAutoUpdateSchemaAsync(String namespace, boolean isAllowAutoUpdateSchema) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "isAllowAutoUpdateSchema");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(isAllowAutoUpdateSchema), "application/json"));
    }

    public void setOffloadPolicies(String namespace, OffloadPolicies offloadPolicies) throws PulsarAdminException {
        this.sync(() -> this.setOffloadPoliciesAsync(namespace, offloadPolicies));
    }

    public void removeOffloadPolicies(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeOffloadPoliciesAsync(namespace));
    }

    public CompletableFuture<Void> setOffloadPoliciesAsync(String namespace, OffloadPolicies offloadPolicies) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "offloadPolicies");
        return this.asyncPostRequest(path, Entity.entity(offloadPolicies, "application/json"));
    }

    public CompletableFuture<Void> removeOffloadPoliciesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "removeOffloadPolicies");
        return this.asyncDeleteRequest(path);
    }

    public OffloadPolicies getOffloadPolicies(String namespace) throws PulsarAdminException {
        return (OffloadPolicies)this.sync(() -> this.getOffloadPoliciesAsync(namespace));
    }

    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<OffloadPoliciesImpl>(){}, namespace, "offloadPolicies").thenApply(policies -> policies);
    }

    public int getMaxTopicsPerNamespace(String namespace) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxTopicsPerNamespaceAsync(namespace));
    }

    public CompletableFuture<Integer> getMaxTopicsPerNamespaceAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Integer>(){}, namespace, "maxTopicsPerNamespace");
    }

    public void setMaxTopicsPerNamespace(String namespace, int maxTopicsPerNamespace) throws PulsarAdminException {
        this.sync(() -> this.setMaxTopicsPerNamespaceAsync(namespace, maxTopicsPerNamespace));
    }

    public CompletableFuture<Void> setMaxTopicsPerNamespaceAsync(String namespace, int maxTopicsPerNamespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxTopicsPerNamespace");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxTopicsPerNamespace), "application/json"));
    }

    public void removeMaxTopicsPerNamespace(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeMaxTopicsPerNamespaceAsync(namespace));
    }

    public CompletableFuture<Void> removeMaxTopicsPerNamespaceAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "maxTopicsPerNamespace");
        return this.asyncDeleteRequest(path);
    }

    public CompletableFuture<Void> setPropertyAsync(String namespace, String key, String value) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "property", key, value);
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public void setProperty(String namespace, String key, String value) throws PulsarAdminException {
        this.sync(() -> this.setPropertyAsync(namespace, key, value));
    }

    public CompletableFuture<Void> setPropertiesAsync(String namespace, Map<String, String> properties) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "properties");
        return this.asyncPutRequest(path, Entity.entity(properties, "application/json"));
    }

    public void setProperties(String namespace, Map<String, String> properties) throws PulsarAdminException {
        this.sync(() -> this.setPropertiesAsync(namespace, properties));
    }

    public String getNamespaceResourceGroup(String namespace) throws PulsarAdminException {
        return (String)this.sync(() -> this.getNamespaceResourceGroupAsync(namespace));
    }

    public CompletableFuture<String> getPropertyAsync(String namespace, String key) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<String>(){}, namespace, "property", key).thenApply(value -> StringUtils.isEmpty(value) ? null : value);
    }

    public String getProperty(String namespace, String key) throws PulsarAdminException {
        return (String)this.sync(() -> this.getPropertyAsync(namespace, key));
    }

    public CompletableFuture<Map<String, String>> getPropertiesAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<Map<String, String>>(){}, namespace, "properties");
    }

    public CompletableFuture<String> getNamespaceResourceGroupAsync(String namespace) {
        return this.asyncGetNamespaceParts(new BaseResource.FutureCallback<String>(){}, namespace, "resourcegroup");
    }

    public Map<String, String> getProperties(String namespace) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getPropertiesAsync(namespace));
    }

    public void setNamespaceResourceGroup(String namespace, String resourcegroupname) throws PulsarAdminException {
        this.sync(() -> this.setNamespaceResourceGroupAsync(namespace, resourcegroupname));
    }

    public CompletableFuture<String> removePropertyAsync(String namespace, String key) {
        NamespaceName ns = NamespaceName.get(namespace);
        final CompletableFuture<String> future = new CompletableFuture<String>();
        WebTarget path = this.namespacePath(ns, "property", key);
        this.asyncDeleteRequest(path, new InvocationCallback<String>(){

            @Override
            public void completed(String value) {
                future.complete(StringUtils.isEmpty(value) ? null : value);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally((Throwable)BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public String removeProperty(String namespace, String key) throws PulsarAdminException {
        return (String)this.sync(() -> this.removePropertyAsync(namespace, key));
    }

    public CompletableFuture<Void> setNamespaceResourceGroupAsync(String namespace, String resourcegroupname) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "resourcegroup", resourcegroupname);
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void removeNamespaceResourceGroup(String namespace) throws PulsarAdminException {
        this.sync(() -> this.removeNamespaceResourceGroupAsync(namespace));
    }

    public CompletableFuture<Void> clearPropertiesAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        CompletableFuture future = new CompletableFuture();
        WebTarget path = this.namespacePath(ns, "properties");
        return this.asyncDeleteRequest(path);
    }

    public void clearProperties(String namespace) throws PulsarAdminException {
        this.sync(() -> this.clearPropertiesAsync(namespace));
    }

    public CompletableFuture<Void> removeNamespaceResourceGroupAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, "resourcegroup");
        return this.asyncDeleteRequest(path);
    }

    private WebTarget namespacePath(NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2Namespaces : this.adminNamespaces;
        WebTarget namespacePath = base.path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }

    private <T> CompletableFuture<T> asyncGetNamespaceParts(BaseResource.FutureCallback<T> callback, String namespace, String ... parts) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath(ns, parts);
        return this.asyncGetRequest(path, callback);
    }
}

