/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.Map;
import java.util.UUID;
import org.apache.bookkeeper.mledger.LedgerOffloader;

public class OffloadSegmentInfoImpl {
    public final UUID uuid;
    public final long beginLedgerId;
    public final long beginEntryId;
    public final String driverName;
    private volatile long endLedgerId;
    private volatile long endEntryId;
    volatile boolean closed = false;
    public final Map<String, String> driverMetadata;

    public OffloadSegmentInfoImpl(UUID uuid, long beginLedgerId, long beginEntryId, String driverName, Map<String, String> driverMetadata) {
        this.uuid = uuid;
        this.beginLedgerId = beginLedgerId;
        this.beginEntryId = beginEntryId;
        this.driverName = driverName;
        this.driverMetadata = driverMetadata;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void closeSegment(long endLedger, long endEntry) {
        this.endLedgerId = endLedger;
        this.endEntryId = endEntry;
        this.closed = true;
    }

    public LedgerOffloader.OffloadResult result() {
        return new LedgerOffloader.OffloadResult(this.beginLedgerId, this.beginEntryId, this.endLedgerId, this.endEntryId);
    }

    public String toString() {
        return "OffloadSegmentInfoImpl(uuid=" + this.uuid + ", beginLedgerId=" + this.beginLedgerId + ", beginEntryId=" + this.beginEntryId + ", driverName=" + this.driverName + ", endLedgerId=" + this.endLedgerId + ", endEntryId=" + this.endEntryId + ", closed=" + this.isClosed() + ", driverMetadata=" + this.driverMetadata + ")";
    }
}

