/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.TimestampOracle;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSOStateManagerImpl
implements TSOStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(TSOStateManagerImpl.class);
    private List<TSOStateManager.StateObserver> stateObservers = new ArrayList<TSOStateManager.StateObserver>();
    private TSOStateManager.TSOState state;
    private TimestampOracle timestampOracle;

    @Inject
    public TSOStateManagerImpl(TimestampOracle timestampOracle) {
        this.timestampOracle = timestampOracle;
    }

    @Override
    public synchronized void register(TSOStateManager.StateObserver newObserver) {
        Preconditions.checkNotNull((Object)newObserver, (Object)"Trying to register a null observer");
        if (!this.stateObservers.contains(newObserver)) {
            this.stateObservers.add(newObserver);
        }
    }

    @Override
    public synchronized void unregister(TSOStateManager.StateObserver observer) {
        this.stateObservers.remove(observer);
    }

    @Override
    public TSOStateManager.TSOState initialize() throws Exception {
        long lowWatermark;
        LOG.info("Initializing TSO Server state...");
        this.timestampOracle.initialize();
        long epoch = lowWatermark = this.timestampOracle.getLast();
        this.state = new TSOStateManager.TSOState(lowWatermark, epoch);
        for (TSOStateManager.StateObserver stateObserver : this.stateObservers) {
            stateObserver.update(this.state);
        }
        LOG.info("TSO Server state {}", (Object)this.state);
        return this.state;
    }
}

