/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.omid.committable.CommitTable;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.metrics.MetricsUtils;
import org.apache.omid.metrics.Timer;
import org.apache.omid.tso.LowWatermarkWriter;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowWatermarkWriterImpl
implements LowWatermarkWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LowWatermarkWriterImpl.class);
    private final Timer lwmWriteTimer;
    private final CommitTable.Writer lowWatermarkWriter;
    private final ExecutorService lowWatermarkWriterExecutor;
    private MetricsRegistry metrics;

    @Inject
    LowWatermarkWriterImpl(TSOServerConfig config, CommitTable commitTable, MetricsRegistry metrics) throws Exception {
        this.metrics = metrics;
        this.lowWatermarkWriter = commitTable.getWriter();
        ThreadFactoryBuilder lwmThreadFactory = new ThreadFactoryBuilder().setNameFormat("lwm-writer-%d");
        this.lowWatermarkWriterExecutor = Executors.newSingleThreadExecutor(lwmThreadFactory.build());
        this.lwmWriteTimer = metrics.timer(MetricsUtils.name((String)"tso", (String[])new String[]{"lwmWriter", "latency"}));
        LOG.info("PersistentProcessor initialized");
    }

    @Override
    public Future<Void> persistLowWatermark(final long lowWatermark) {
        return this.lowWatermarkWriterExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                try {
                    LowWatermarkWriterImpl.this.lwmWriteTimer.start();
                    LowWatermarkWriterImpl.this.lowWatermarkWriter.updateLowWatermark(lowWatermark);
                    LowWatermarkWriterImpl.this.lowWatermarkWriter.flush();
                }
                finally {
                    LowWatermarkWriterImpl.this.lwmWriteTimer.stop();
                }
                return null;
            }
        });
    }
}

