/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso.client;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.omid.tso.ProgrammableTSOServer;
import org.apache.omid.tso.client.AbortException;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.omid.tso.client.TSOClient;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestTSOClientResponseHandling {
    private static final int TSO_PORT = 4321;
    private static final long START_TS = 1L;
    private static final long COMMIT_TS = 2L;
    private ProgrammableTSOServer tsoServer = new ProgrammableTSOServer(4321);
    private TSOClient tsoClient;

    @BeforeClass
    public void configureAndCreateClient() throws IOException, InterruptedException {
        OmidClientConfiguration tsoClientConf = new OmidClientConfiguration();
        tsoClientConf.setConnectionString("localhost:4321");
        this.tsoClient = TSOClient.newInstance((OmidClientConfiguration)tsoClientConf);
    }

    @BeforeMethod
    public void reset() {
        this.tsoServer.cleanResponses();
    }

    @Test(timeOut=10000L)
    public void testTimestampRequestReceivingASuccessfulResponse() throws Exception {
        this.tsoServer.queueResponse(new ProgrammableTSOServer.TimestampResponse(1L));
        long startTS = (Long)this.tsoClient.getNewStartTimestamp().get();
        Assert.assertEquals((long)startTS, (long)1L);
    }

    @Test(timeOut=10000L)
    public void testCommitRequestReceivingAnAbortResponse() throws Exception {
        this.tsoServer.queueResponse(new ProgrammableTSOServer.AbortResponse(1L));
        try {
            this.tsoClient.commit(1L, Collections.emptySet()).get();
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(ee.getCause().getClass(), AbortException.class);
        }
    }

    @Test(timeOut=10000L)
    public void testCommitRequestReceivingASuccessfulResponse() throws Exception {
        this.tsoServer.queueResponse(new ProgrammableTSOServer.CommitResponse(1L, 2L));
        long commitTS = (Long)this.tsoClient.commit(1L, Collections.emptySet()).get();
        Assert.assertEquals((long)commitTS, (long)2L);
    }
}

