/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.List;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.master.Master;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LocatedTablet {
    private final Partition partition;
    private final byte[] tabletId;
    private final List<Replica> replicas;

    LocatedTablet(RemoteTablet tablet) {
        this.partition = tablet.getPartition();
        this.tabletId = tablet.getTabletIdAsBytes();
        this.replicas = tablet.getReplicas();
    }

    public List<Replica> getReplicas() {
        return this.replicas;
    }

    public Partition getPartition() {
        return this.partition;
    }

    @Deprecated
    public byte[] getStartKey() {
        return this.getPartition().getPartitionKeyStart();
    }

    @Deprecated
    public byte[] getEndKey() {
        return this.getPartition().getPartitionKeyEnd();
    }

    public byte[] getTabletId() {
        return this.tabletId;
    }

    public Replica getLeaderReplica() {
        return this.getOneOfRoleOrNull(Metadata.RaftPeerPB.Role.LEADER);
    }

    private Replica getOneOfRoleOrNull(Metadata.RaftPeerPB.Role role) {
        for (Replica r : this.replicas) {
            if (r.getRole() != role.toString()) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        return Bytes.pretty(this.tabletId) + " " + this.partition.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class Replica {
        private final Master.TabletLocationsPB.ReplicaPB pb;

        Replica(Master.TabletLocationsPB.ReplicaPB pb) {
            this.pb = pb;
        }

        public String getRpcHost() {
            if (this.pb.getTsInfo().getRpcAddressesList().isEmpty()) {
                return null;
            }
            return this.pb.getTsInfo().getRpcAddressesList().get(0).getHost();
        }

        public Integer getRpcPort() {
            if (this.pb.getTsInfo().getRpcAddressesList().isEmpty()) {
                return null;
            }
            return this.pb.getTsInfo().getRpcAddressesList().get(0).getPort();
        }

        public String getRole() {
            return this.pb.getRole().toString();
        }

        public String toString() {
            return this.pb.toString();
        }
    }
}

