/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tub!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t\u001b^\u001b2\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\r\u0011\"\u0001\u0018\u0003\u00111\u0017\u000e\\3\u0016\u0003a\u0001\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u0005%|'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011AAR5mK\"A\u0011\u0005\u0001BA\u0002\u0013\u0005!%\u0001\u0005gS2,w\fJ3r)\t\u0019c\u0005\u0005\u0002\u000bI%\u0011Qe\u0003\u0002\u0005+:LG\u000fC\u0004(A\u0005\u0005\t\u0019\u0001\r\u0002\u0007a$\u0013\u0007\u0003\u0005*\u0001\t\u0005\t\u0015)\u0003\u0019\u0003\u00151\u0017\u000e\\3!Q\tA3\u0006\u0005\u0002\u000bY%\u0011Qf\u0003\u0002\tm>d\u0017\r^5mK\"Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'\u0001\u0006cCN,wJ\u001a4tKR,\u0012!\r\t\u0003\u0015IJ!aM\u0006\u0003\t1{gn\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005Y!-Y:f\u001f\u001a47/\u001a;!\u0011!9\u0004A!b\u0001\n\u0003A\u0014\u0001D7bq&sG-\u001a=TSj,W#A\u001d\u0011\u0005)Q\u0014BA\u001e\f\u0005\rIe\u000e\u001e\u0005\t{\u0001\u0011\t\u0011)A\u0005s\u0005iQ.\u0019=J]\u0012,\u0007pU5{K\u0002B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001Q\u0001\toJLG/\u00192mKV\t\u0011\t\u0005\u0002\u000b\u0005&\u00111i\u0003\u0002\b\u0005>|G.Z1o\u0011!)\u0005A!A!\u0002\u0013\t\u0015!C<sSR\f'\r\\3!\u0011\u00159\u0005\u0001\"\u0001I\u0003\u0019a\u0014N\\5u}Q)\u0011*\u0017.\\9B!!\nA&W\u001b\u0005\u0011\u0001C\u0001'N\u0019\u0001!QA\u0014\u0001C\u0002=\u0013\u0011aS\t\u0003!N\u0003\"AC)\n\u0005I[!a\u0002(pi\"Lgn\u001a\t\u0003\u0015QK!!V\u0006\u0003\u0007\u0005s\u0017\u0010\u0005\u0002M/\u0012)\u0001\f\u0001b\u0001\u001f\n\ta\u000bC\u0003\u0017\r\u0002\u0007\u0001\u0004C\u00030\r\u0002\u0007\u0011\u0007C\u00048\rB\u0005\t\u0019A\u001d\t\u000b}2\u0005\u0019A!\t\u000by\u0003a\u0011\u0003\u001d\u0002\u0013\u0015tGO]=TSj,\u0007b\u00021\u0001\u0005\u0004%\t\"Y\u0001\u0005Y>\u001c7.F\u0001c!\t\u0019'.D\u0001e\u0015\t)g-A\u0003m_\u000e\\7O\u0003\u0002hQ\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005%d\u0012\u0001B;uS2L!a\u001b3\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u0019i\u0007\u0001)A\u0005E\u0006)An\\2lA!9q\u000e\u0001a\u0001\n#\u0001\u0018\u0001B7nCB,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003ir\t1A\\5p\u0013\t18O\u0001\tNCB\u0004X\r\u001a\"zi\u0016\u0014UO\u001a4fe\"9\u0001\u0010\u0001a\u0001\n#I\u0018\u0001C7nCB|F%Z9\u0015\u0005\rR\bbB\u0014x\u0003\u0003\u0005\r!\u001d\u0005\u0007y\u0002\u0001\u000b\u0015B9\u0002\u000b5l\u0017\r\u001d\u0011)\u0005m\\\u0003BB@\u0001A\u0003&\u0011(A\u0006`[\u0006DXI\u001c;sS\u0016\u001c\bF\u0001@,\u0011!\t)\u0001\u0001a\u0001\n#A\u0014\u0001C0f]R\u0014\u0018.Z:\t\u0013\u0005%\u0001\u00011A\u0005\u0012\u0005-\u0011\u0001D0f]R\u0014\u0018.Z:`I\u0015\fHcA\u0012\u0002\u000e!Aq%a\u0002\u0002\u0002\u0003\u0007\u0011\bC\u0004\u0002\u0012\u0001\u0001\u000b\u0015B\u001d\u0002\u0013}+g\u000e\u001e:jKN\u0004\u0003fAA\bW!1\u0011q\u0003\u0001\u0005\u0002\u0001\u000ba![:Gk2d\u0007BBA\u000e\u0001\u0011\u0005\u0001(\u0001\u0006nCb,e\u000e\u001e:jKNDa!a\b\u0001\t\u0003A\u0014aB3oiJLWm\u001d\u0005\b\u0003G\u0001A\u0011AA\u0013\u0003\u0019\u0011Xm]5{KR\u00191%a\n\t\u000f\u0005%\u0012\u0011\u0005a\u0001s\u00059a.Z<TSj,\u0007bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\te\u0016t\u0017-\\3U_R\u00191%!\r\t\u000f\u0005M\u00121\u0006a\u00011\u0005\ta\rC\u0004\u00028\u0001!\t!!\u000f\u0002\u000b\u0019dWo\u001d5\u0015\u0003\rBq!!\u0010\u0001\t\u0003\ty$\u0001\u0004eK2,G/\u001a\u000b\u0002\u0003\"9\u00111\t\u0001\u0005\u0002\u0005e\u0012a\u0004;sS6$vNV1mS\u0012\u001c\u0016N_3\t\r\u0005\u001d\u0003\u0001\"\u00019\u0003-\u0019\u0018N_3J]\nKH/Z:\t\u000f\u0005-\u0003\u0001\"\u0001\u0002:\u0005)1\r\\8tK\"9\u0011q\n\u0001\u0005\u0002\u0005e\u0012\u0001D2m_N,\u0007*\u00198eY\u0016\u0014\bbBA*\u0001\u0019\u0005\u0011\u0011H\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000eC\u0004\u0002X\u00011\t!!\u000f\u0002\u0011Q\u0014XO\\2bi\u0016Dq!a\u0017\u0001\r\u0003\ti&\u0001\u0006ueVt7-\u0019;f)>$2aIA0\u0011\u001d\t\t'!\u0017A\u0002E\naa\u001c4gg\u0016$\bbBA3\u0001\u0011E\u0011\u0011H\u0001\u000fg\u00064WMR8sG\u0016,f.\\1q\u0011!\tI\u0007\u0001C\t\u0005\u0005e\u0012A\u00034pe\u000e,WK\\7ba\"9\u0011Q\u000e\u0001\u0005\u0012\u0005=\u0014!C7bs\n,Gj\\2l+\u0011\t\t(a\u001e\u0015\t\u0005M\u0014Q\u0011\u000b\u0005\u0003k\nY\bE\u0002M\u0003o\"q!!\u001f\u0002l\t\u0007qJA\u0001U\u0011%\ti(a\u001b\u0005\u0002\u0004\ty(A\u0002gk:\u0004RACAA\u0003kJ1!a!\f\u0005!a$-\u001f8b[\u0016t\u0004b\u00021\u0002l\u0001\u0007\u0011q\u0011\t\u0004G\u0006%\u0015bAAFI\n!Aj\\2l\u0011\u001d\ty\t\u0001D\t\u0003#\u000b!\u0002]1sg\u0016,e\u000e\u001e:z)\u0019\t\u0019*!'\u0002$B\u0019!*!&\n\u0007\u0005]%A\u0001\u0006J]\u0012,\u00070\u00128uefD\u0001\"a'\u0002\u000e\u0002\u0007\u0011QT\u0001\u0007EV4g-\u001a:\u0011\u0007I\fy*C\u0002\u0002\"N\u0014!BQ=uK\n+hMZ3s\u0011\u001d\t)+!$A\u0002e\n\u0011A\u001c\u0005\b\u0003S\u0003A\u0011CAV\u0003aa\u0017M]4fgRdun^3s\u0005>,h\u000eZ*m_R4uN\u001d\u000b\bs\u00055\u0016\u0011WA[\u0011!\ty+a*A\u0002\u0005u\u0015aA5eq\"9\u00111WAT\u0001\u0004\t\u0014A\u0002;be\u001e,G\u000f\u0003\u0005\u00028\u0006\u001d\u0006\u0019AA]\u00031\u0019X-\u0019:dQ\u0016sG/\u001b;z!\u0011\tY,a4\u000f\t\u0005u\u00161\u001a\b\u0005\u0003\u007f\u000bIM\u0004\u0003\u0002B\u0006\u001dWBAAb\u0015\r\t)MB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!a\u0001\u0003\n\u0007\u00055'!A\bJ]\u0012,\u0007pU3be\u000eDG+\u001f9f\u0013\u0011\t\t.a5\u0003#%sG-\u001a=TK\u0006\u00148\r[#oi&$\u0018PC\u0002\u0002N\nAq!a6\u0001\t#\tI.A\rt[\u0006dG.Z:u+B\u0004XM\u001d\"pk:$7\u000b\\8u\r>\u0014HcB\u001d\u0002\\\u0006u\u0017q\u001c\u0005\t\u0003_\u000b)\u000e1\u0001\u0002\u001e\"9\u00111WAk\u0001\u0004\t\u0004\u0002CA\\\u0003+\u0004\r!!/\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\u0006\t\u0012N\u001c3fqNcw\u000e\u001e*b]\u001e,gi\u001c:\u0015\u0011\u0005\u001d\u0018Q^Ax\u0003c\u0004RACAuseJ1!a;\f\u0005\u0019!V\u000f\u001d7fe!A\u0011qVAq\u0001\u0004\ti\nC\u0004\u00024\u0006\u0005\b\u0019A\u0019\t\u0011\u0005]\u0016\u0011\u001da\u0001\u0003sCq!!>\u0001\t\u0013\t90A\td_6\u0004\u0018M]3J]\u0012,\u00070\u00128uef$r!OA}\u0003{\fy\u0010\u0003\u0005\u0002|\u0006M\b\u0019AAJ\u0003)Ig\u000eZ3y\u000b:$(/\u001f\u0005\b\u0003g\u000b\u0019\u00101\u00012\u0011!\t9,a=A\u0002\u0005e\u0006b\u0002B\u0002\u0001\u0011%!QA\u0001\u0019e>,h\u000e\u001a#po:$v.\u0012=bGRlU\u000f\u001c;ja2,G#B\u001d\u0003\b\t-\u0001b\u0002B\u0005\u0005\u0003\u0001\r!O\u0001\u0007]Vl'-\u001a:\t\u000f\t5!\u0011\u0001a\u0001s\u00051a-Y2u_J<\u0011B!\u0005\u0003\u0003\u0003E\tAa\u0005\u0002\u001b\u0005\u00137\u000f\u001e:bGRLe\u000eZ3y!\rQ%Q\u0003\u0004\t\u0003\t\t\t\u0011#\u0001\u0003\u0018M\u0019!QC\u0005\t\u000f\u001d\u0013)\u0002\"\u0001\u0003\u001cQ\u0011!1\u0003\u0005\u000b\u0005?\u0011)\"%A\u0005\u0002\t\u0005\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0004\u0003$\te\"1H\u000b\u0003\u0005KQ3!\u000fB\u0014W\t\u0011I\u0003\u0005\u0003\u0003,\tURB\u0001B\u0017\u0015\u0011\u0011yC!\r\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001a\u0017\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t]\"Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002(\u0003\u001e\t\u0007q\n\u0002\u0004Y\u0005;\u0011\ra\u0014")
public abstract class AbstractIndex<K, V>
implements Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    public volatile int kafka$log$AbstractIndex$$_maxEntries;
    private volatile int _entries;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    public abstract int entrySize();

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int maxEntries() {
        return this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public void resize(int newSize) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;
            private final int newSize$1;

            /*
             * WARNING - void declaration
             */
            public final Buffer apply() {
                Buffer buffer;
                RandomAccessFile raf = new RandomAccessFile(this.$outer.file(), "rw");
                int roundedNewSize = this.$outer.kafka$log$AbstractIndex$$roundDownToExactMultiple(this.newSize$1, this.$outer.entrySize());
                int position = this.$outer.mmap().position();
                if (OperatingSystem.IS_WINDOWS) {
                    this.$outer.safeForceUnmap();
                }
                try {
                    raf.setLength(roundedNewSize);
                    this.$outer.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.kafka$log$AbstractIndex$$_maxEntries = this.$outer.mmap().limit() / this.$outer.entrySize();
                    buffer = this.$outer.mmap().position(position);
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var1_1;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                return buffer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
            return;
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean delete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.file().delete();
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resize(this.$outer.entrySize() * this.$outer._entries());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.safeForceUnmap();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AbstractIndex $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unmapping index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
            return;
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (OperatingSystem.IS_WINDOWS) {
            lock2.lock();
        }
        try {
            return (T)fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock2.unlock();
            }
        }
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        int lo = 0;
        int hi = this._entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx, mid);
            int compareResult = this.compareIndexEntry(found, target, searchEntity);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        Enumeration.Value value2;
        block4: {
            int n;
            block3: {
                block2: {
                    value2 = searchEntity;
                    Enumeration.Value value3 = IndexSearchType$.MODULE$.KEY();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                    n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
                    break block3;
                }
                Enumeration.Value value5 = IndexSearchType$.MODULE$.VALUE();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            }
            return n;
        }
        throw new MatchError((Object)value2);
    }

    public int kafka$log$AbstractIndex$$roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            long len = raf.length();
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, len) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, len);
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(idx.limit(), this.entrySize()));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            });
            this.mmap = idx;
        }
        catch (Throwable throwable) {
            void var7_6;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        this.kafka$log$AbstractIndex$$_maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

