/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.resource.Resource;
import org.apache.kafka.common.utils.Utils;

public class CreateAclsRequest
extends AbstractRequest {
    private static final String CREATIONS = "creations";
    private final List<AclCreation> aclCreations;

    CreateAclsRequest(short version, List<AclCreation> aclCreations) {
        super(version);
        this.aclCreations = aclCreations;
    }

    public CreateAclsRequest(Struct struct, short version) {
        super(version);
        this.aclCreations = new ArrayList<AclCreation>();
        for (Object creationStructObj : struct.getArray(CREATIONS)) {
            Struct creationStruct = (Struct)creationStructObj;
            this.aclCreations.add(AclCreation.fromStruct(creationStruct));
        }
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.CREATE_ACLS.requestSchema(this.version()));
        ArrayList<Struct> requests = new ArrayList<Struct>();
        for (AclCreation creation : this.aclCreations) {
            Struct creationStruct = struct.instance(CREATIONS);
            creation.setStructFields(creationStruct);
            requests.add(creationStruct);
        }
        struct.set(CREATIONS, (Object)requests.toArray());
        return struct;
    }

    public List<AclCreation> aclCreations() {
        return this.aclCreations;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                ArrayList<CreateAclsResponse.AclCreationResponse> responses = new ArrayList<CreateAclsResponse.AclCreationResponse>();
                for (int i = 0; i < this.aclCreations.size(); ++i) {
                    responses.add(new CreateAclsResponse.AclCreationResponse(ApiError.fromThrowable(throwable)));
                }
                return new CreateAclsResponse(throttleTimeMs, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CREATE_ACLS.latestVersion()));
    }

    public static CreateAclsRequest parse(ByteBuffer buffer, short version) {
        return new CreateAclsRequest(ApiKeys.CREATE_ACLS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateAclsRequest> {
        private final List<AclCreation> creations;

        public Builder(List<AclCreation> creations) {
            super(ApiKeys.CREATE_ACLS);
            this.creations = creations;
        }

        @Override
        public CreateAclsRequest build(short version) {
            return new CreateAclsRequest(version, this.creations);
        }

        public String toString() {
            return "(type=CreateAclsRequest, creations=" + Utils.join(this.creations, ", ") + ")";
        }
    }

    public static class AclCreation {
        private final AclBinding acl;

        public AclCreation(AclBinding acl) {
            this.acl = acl;
        }

        static AclCreation fromStruct(Struct struct) {
            Resource resource = RequestUtils.resourceFromStructFields(struct);
            AccessControlEntry entry = RequestUtils.aceFromStructFields(struct);
            return new AclCreation(new AclBinding(resource, entry));
        }

        public AclBinding acl() {
            return this.acl;
        }

        void setStructFields(Struct struct) {
            RequestUtils.resourceSetStructFields(this.acl.resource(), struct);
            RequestUtils.aceSetStructFields(this.acl.entry(), struct);
        }

        public String toString() {
            return "(acl=" + this.acl + ")";
        }
    }
}

