/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpTimelineReaderImpl
extends AbstractService
implements TimelineReader {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpTimelineReaderImpl.class);

    public NoOpTimelineReaderImpl() {
        super(NoOpTimelineReaderImpl.class.getName());
        LOG.info("NoOpTimelineReader is configured. Responses to all read requests would be empty");
    }

    @Override
    public TimelineEntity getEntity(TimelineReaderContext context, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        LOG.debug("NoOpTimelineReader is configured. Response to all the read requests would be empty");
        return new TimelineEntity();
    }

    @Override
    public Set<TimelineEntity> getEntities(TimelineReaderContext context, TimelineEntityFilters filters, TimelineDataToRetrieve dataToRetrieve) throws IOException {
        LOG.debug("NoOpTimelineReader is configured. Response to all the read requests would be empty");
        return new HashSet<TimelineEntity>();
    }

    @Override
    public Set<String> getEntityTypes(TimelineReaderContext context) throws IOException {
        LOG.debug("NoOpTimelineReader is configured. Response to all the read requests would be empty");
        return new HashSet<String>();
    }
}

