/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader.filter;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineCompareFilter
extends TimelineFilter {
    private TimelineCompareOp compareOp;
    private String key;
    private Object value;
    private boolean keyMustExist = true;

    public TimelineCompareFilter() {
    }

    public TimelineCompareFilter(TimelineCompareOp op, String key, Object val, boolean keyMustExistFlag) {
        this.compareOp = op;
        this.key = key;
        this.value = val;
        this.keyMustExist = op == TimelineCompareOp.NOT_EQUAL ? keyMustExistFlag : true;
    }

    public TimelineCompareFilter(TimelineCompareOp op, String key, Object val) {
        this(op, key, val, true);
    }

    @Override
    public TimelineFilter.TimelineFilterType getFilterType() {
        return TimelineFilter.TimelineFilterType.COMPARE;
    }

    public TimelineCompareOp getCompareOp() {
        return this.compareOp;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String keyToBeSet) {
        this.key = keyToBeSet;
    }

    public Object getValue() {
        return this.value;
    }

    public void setCompareOp(TimelineCompareOp timelineCompareOp, boolean keyExistFlag) {
        this.compareOp = timelineCompareOp;
        if (timelineCompareOp == TimelineCompareOp.NOT_EQUAL) {
            this.keyMustExist = keyExistFlag;
        }
    }

    public void setValue(Object val) {
        this.value = val;
    }

    public boolean getKeyMustExist() {
        return this.keyMustExist;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.compareOp == null ? 0 : this.compareOp.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.keyMustExist ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineCompareFilter other = (TimelineCompareFilter)obj;
        if (this.compareOp != other.compareOp) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.keyMustExist != other.keyMustExist) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s:%s:%b)", this.getClass().getSimpleName(), this.compareOp.name(), this.key, this.value, this.keyMustExist);
    }
}

