/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class NamespaceInfo
extends StorageInfo {
    String buildVersion;
    int distributedUpgradeVersion;
    public static final String __PARANAMER_DATA = "<init> int,long,int nsID,cT,duVersion \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

    public NamespaceInfo() {
        this.buildVersion = null;
    }

    public NamespaceInfo(int nsID, long cT, int duVersion) {
        super(FSConstants.LAYOUT_VERSION, nsID, cT);
        this.buildVersion = Storage.getBuildVersion();
        this.distributedUpgradeVersion = duVersion;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public int getDistributedUpgradeVersion() {
        return this.distributedUpgradeVersion;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        DeprecatedUTF8.writeString(out, this.getBuildVersion());
        super.write(out);
        out.writeInt(this.getDistributedUpgradeVersion());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.buildVersion = DeprecatedUTF8.readString(in);
        super.readFields(in);
        this.distributedUpgradeVersion = in.readInt();
    }

    static {
        WritableFactories.setFactory(NamespaceInfo.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new NamespaceInfo();
            }
        });
    }
}

