/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeRegistration
extends DatanodeID
implements Writable,
NodeRegistration {
    public StorageInfo storageInfo = new StorageInfo();
    public ExportedBlockKeys exportedKeys = new ExportedBlockKeys();
    public static final String __PARANAMER_DATA = "<init> java.lang.String nodeName \nequals java.lang.Object to \nreadFields java.io.DataInput in \nsetInfoPort int infoPort \nsetIpcPort int ipcPort \nsetName java.lang.String name \nsetStorageInfo org.apache.hadoop.hdfs.server.datanode.DataStorage storage \nwrite java.io.DataOutput out \n";

    public DatanodeRegistration() {
        this("");
    }

    public DatanodeRegistration(String nodeName) {
        super(nodeName);
    }

    public void setInfoPort(int infoPort) {
        this.infoPort = infoPort;
    }

    public void setIpcPort(int ipcPort) {
        this.ipcPort = ipcPort;
    }

    public void setStorageInfo(DataStorage storage) {
        this.storageInfo = new StorageInfo(storage);
        this.storageID = storage.getStorageID();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getVersion() {
        return this.storageInfo.getLayoutVersion();
    }

    @Override
    public String getRegistrationID() {
        return Storage.getRegistrationID(this.storageInfo);
    }

    @Override
    public String getAddress() {
        return this.getName();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ", storageID=" + this.storageID + ", infoPort=" + this.infoPort + ", ipcPort=" + this.ipcPort + ")";
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.ipcPort);
        this.storageInfo.write(out);
        this.exportedKeys.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.ipcPort = in.readShort() & 0xFFFF;
        this.storageInfo.readFields(in);
        this.exportedKeys.readFields(in);
    }

    @Override
    public boolean equals(Object to) {
        return super.equals(to);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    static {
        WritableFactories.setFactory(DatanodeRegistration.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new DatanodeRegistration();
            }
        });
    }
}

