/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

class INodeFileUnderConstruction
extends INodeFile {
    private String clientName;
    private final String clientMachine;
    private final DatanodeDescriptor clientNode;

    INodeFileUnderConstruction(PermissionStatus permissions, short replication, long preferredBlockSize, long modTime, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(permissions.applyUMask(UMASK), 0, replication, modTime, modTime, preferredBlockSize);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    public INodeFileUnderConstruction(byte[] name, short blockReplication, long modificationTime, long preferredBlockSize, BlockInfo[] blocks, PermissionStatus perm, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(perm, blocks, blockReplication, modificationTime, modificationTime, preferredBlockSize);
        this.setLocalName(name);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    String getClientName() {
        return this.clientName;
    }

    void setClientName(String clientName) {
        this.clientName = clientName;
    }

    String getClientMachine() {
        return this.clientMachine;
    }

    DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    @Override
    boolean isUnderConstruction() {
        return true;
    }

    INodeFile convertToInodeFile() {
        INodeFile obj = new INodeFile(this.getPermissionStatus(), this.getBlocks(), this.getReplication(), this.getModificationTime(), this.getModificationTime(), this.getPreferredBlockSize());
        return obj;
    }

    void removeLastBlock(Block oldblock) throws IOException {
        if (this.blocks == null) {
            throw new IOException("Trying to delete non-existant block " + oldblock);
        }
        int size_1 = this.blocks.length - 1;
        if (!this.blocks[size_1].equals(oldblock)) {
            throw new IOException("Trying to delete non-last block " + oldblock);
        }
        BlockInfo[] newlist = new BlockInfo[size_1];
        System.arraycopy(this.blocks, 0, newlist, 0, size_1);
        this.blocks = newlist;
    }

    BlockInfoUnderConstruction setLastBlock(BlockInfo lastBlock, DatanodeDescriptor[] targets) throws IOException {
        if (this.blocks == null || this.blocks.length == 0) {
            throw new IOException("Trying to update non-existant block. File is empty.");
        }
        BlockInfoUnderConstruction ucBlock = lastBlock.convertToBlockUnderConstruction(HdfsConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
        ucBlock.setINode(this);
        this.setBlock(this.numBlocks() - 1, ucBlock);
        return ucBlock;
    }
}

