/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.GenerationStamp;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.BackupStorage;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.DecommissionManager;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.Host2NodesMap;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.UpgradeManagerNamenode;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMetrics;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.Private
public class FSNamesystem
implements FSConstants,
FSNamesystemMBean,
FSClusterStats,
NameNodeMXBean {
    public static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    private static final ThreadLocal<StringBuilder> auditBuffer = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    public static final Log auditLog = LogFactory.getLog((String)(FSNamesystem.class.getName() + ".audit"));
    static final int DEFAULT_MAX_CORRUPT_FILEBLOCKS_RETURNED = 100;
    static int BLOCK_DELETION_INCREMENT = 1000;
    private boolean isPermissionEnabled;
    private UserGroupInformation fsOwner;
    private String supergroup;
    private PermissionStatus defaultPermission;
    private FSNamesystemMetrics myFSMetrics;
    private long capacityTotal = 0L;
    private long capacityUsed = 0L;
    private long capacityRemaining = 0L;
    private int totalLoad = 0;
    boolean isBlockTokenEnabled;
    BlockTokenSecretManager blockTokenSecretManager;
    private long blockKeyUpdateInterval;
    private long blockTokenLifetime;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private DelegationTokenSecretManager dtSecretManager;
    public FSDirectory dir;
    BlockManager blockManager;
    NavigableMap<String, DatanodeDescriptor> datanodeMap = new TreeMap<String, DatanodeDescriptor>();
    Random r = new Random();
    ArrayList<DatanodeDescriptor> heartbeats = new ArrayList();
    public LeaseManager leaseManager = new LeaseManager(this);
    Daemon hbthread = null;
    public Daemon lmthread = null;
    Daemon smmthread = null;
    public Daemon replthread = null;
    private volatile boolean fsRunning = true;
    long systemStart = 0L;
    private long heartbeatRecheckInterval;
    private long heartbeatExpireInterval;
    private long replicationRecheckInterval;
    private FsServerDefaults serverDefaults;
    private boolean supportAppends = true;
    private volatile SafeModeInfo safeMode;
    private Host2NodesMap host2DataNodeMap = new Host2NodesMap();
    NetworkTopology clusterMap = new NetworkTopology();
    private DNSToSwitchMapping dnsToSwitchMapping;
    private HostsFileReader hostsReader;
    private Daemon dnthread = null;
    private long maxFsObjects = 0L;
    private final GenerationStamp generationStamp = new GenerationStamp();
    int blockInvalidateLimit = 1000;
    private long accessTimePrecision = 0L;
    private ReentrantReadWriteLock fsLock;
    static Random randBlockId = new Random();
    final UpgradeManagerNamenode upgradeManager = new UpgradeManagerNamenode(this);
    private ObjectName mbeanName;

    private static final void logAuditEvent(UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, HdfsFileStatus stat) {
        StringBuilder sb = auditBuffer.get();
        sb.setLength(0);
        sb.append("ugi=").append(ugi).append("\t");
        sb.append("ip=").append(addr).append("\t");
        sb.append("cmd=").append(cmd).append("\t");
        sb.append("src=").append(src).append("\t");
        sb.append("dst=").append(dst).append("\t");
        if (null == stat) {
            sb.append("perm=null");
        } else {
            sb.append("perm=");
            sb.append(stat.getOwner()).append(":");
            sb.append(stat.getGroup()).append(":");
            sb.append(stat.getPermission());
        }
        auditLog.info((Object)sb);
    }

    FSNamesystem(Configuration conf) throws IOException {
        try {
            this.initialize(conf, null);
        }
        catch (IOException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
    }

    private void initialize(Configuration conf, FSImage fsImage) throws IOException {
        this.systemStart = Util.now();
        this.blockManager = new BlockManager(this, conf);
        this.fsLock = new ReentrantReadWriteLock(true);
        this.setConfigurationParameters(conf);
        this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
        this.registerMBean(conf);
        if (fsImage == null) {
            this.dir = new FSDirectory(this, conf);
            HdfsConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
            this.dir.loadFSImage(FSNamesystem.getNamespaceDirs(conf), FSNamesystem.getNamespaceEditsDirs(conf), startOpt);
            long timeTakenToLoadFSImage = Util.now() - this.systemStart;
            LOG.info((Object)("Finished loading FSImage in " + timeTakenToLoadFSImage + " msecs"));
            NameNode.getNameNodeMetrics().fsImageLoadTime.set((int)timeTakenToLoadFSImage);
            this.safeMode = new SafeModeInfo(conf);
        } else {
            this.dir = new FSDirectory(fsImage, this, conf);
            this.safeMode = new SafeModeInfo();
        }
        this.hostsReader = new HostsFileReader(conf.get("dfs.hosts", ""), conf.get("dfs.hosts.exclude", ""));
        if (this.isBlockTokenEnabled) {
            this.blockTokenSecretManager = new BlockTokenSecretManager(true, this.blockKeyUpdateInterval, this.blockTokenLifetime);
        }
    }

    void activateSecretManager() throws IOException {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.startThreads();
        }
    }

    void activate(Configuration conf) throws IOException {
        this.setBlockTotal();
        this.blockManager.activate();
        this.hbthread = new Daemon((Runnable)new HeartbeatMonitor());
        this.lmthread = new Daemon((Runnable)new LeaseManager.Monitor(this.leaseManager));
        this.replthread = new Daemon((Runnable)new ReplicationMonitor());
        this.hbthread.start();
        this.lmthread.start();
        this.replthread.start();
        DecommissionManager decommissionManager = new DecommissionManager(this);
        decommissionManager.getClass();
        this.dnthread = new Daemon((Runnable)decommissionManager.new DecommissionManager.Monitor(conf.getInt("dfs.namenode.decommission.interval", 30), conf.getInt("dfs.namenode.decommission.nodes.per.interval", 5)));
        this.dnthread.start();
        this.dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), (Configuration)conf);
        if (this.dnsToSwitchMapping instanceof CachedDNSToSwitchMapping) {
            this.dnsToSwitchMapping.resolve(new ArrayList(this.hostsReader.getHosts()));
        }
        this.registerMXBean();
    }

    public static Collection<URI> getNamespaceDirs(Configuration conf) {
        return FSNamesystem.getStorageDirs(conf, "dfs.namenode.name.dir");
    }

    public static Collection<URI> getStorageDirs(Configuration conf, String propertyName) {
        Collection dirNames = conf.getTrimmedStringCollection(propertyName);
        HdfsConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        if (startOpt == HdfsConstants.StartupOption.IMPORT) {
            HdfsConfiguration cE = new HdfsConfiguration(false);
            cE.addResource("core-default.xml");
            cE.addResource("core-site.xml");
            cE.addResource("hdfs-default.xml");
            Collection dirNames2 = cE.getTrimmedStringCollection(propertyName);
            dirNames.removeAll(dirNames2);
            if (dirNames.isEmpty()) {
                LOG.warn((Object)("!!! WARNING !!!\n\tThe NameNode currently runs without persistent storage.\n\tAny changes to the file system meta-data may be lost.\n\tRecommended actions:\n\t\t- shutdown and restart NameNode with configured \"" + propertyName + "\" in hdfs-site.xml;" + "\n\t\t- use Backup Node as a persistent and up-to-date storage " + "of the file system meta-data."));
            }
        } else if (dirNames.isEmpty()) {
            dirNames.add("file:///tmp/hadoop/dfs/name");
        }
        return Util.stringCollectionAsURIs(dirNames);
    }

    public static Collection<URI> getNamespaceEditsDirs(Configuration conf) {
        return FSNamesystem.getStorageDirs(conf, "dfs.namenode.edits.dir");
    }

    void readLock() {
        this.fsLock.readLock().lock();
    }

    void readUnlock() {
        this.fsLock.readLock().unlock();
    }

    void writeLock() {
        this.fsLock.writeLock().lock();
    }

    void writeUnlock() {
        this.fsLock.writeLock().unlock();
    }

    boolean hasWriteLock() {
        return this.fsLock.isWriteLockedByCurrentThread();
    }

    FSNamesystem(FSImage fsImage, Configuration conf) throws IOException {
        this.fsLock = new ReentrantReadWriteLock(true);
        this.blockManager = new BlockManager(this, conf);
        this.setConfigurationParameters(conf);
        this.dir = new FSDirectory(fsImage, this, conf);
        this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
    }

    FSNamesystem(Configuration conf, BackupStorage bnImage) throws IOException {
        try {
            this.initialize(conf, bnImage);
        }
        catch (IOException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
    }

    private void setConfigurationParameters(Configuration conf) throws IOException {
        this.fsOwner = UserGroupInformation.getCurrentUser();
        LOG.info((Object)("fsOwner=" + this.fsOwner));
        this.supergroup = conf.get("dfs.permissions.superusergroup", "supergroup");
        this.isPermissionEnabled = conf.getBoolean("dfs.permissions.enabled", true);
        LOG.info((Object)("supergroup=" + this.supergroup));
        LOG.info((Object)("isPermissionEnabled=" + this.isPermissionEnabled));
        short filePermission = (short)conf.getInt("dfs.namenode.upgrade.permission", 511);
        this.defaultPermission = PermissionStatus.createImmutable((String)this.fsOwner.getShortUserName(), (String)this.supergroup, (FsPermission)new FsPermission(filePermission));
        long heartbeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        this.heartbeatRecheckInterval = conf.getInt("dfs.namenode.heartbeat.recheck-interval", 300000);
        this.heartbeatExpireInterval = 2L * this.heartbeatRecheckInterval + 10L * heartbeatInterval;
        this.replicationRecheckInterval = (long)conf.getInt("dfs.namenode.replication.interval", 3) * 1000L;
        this.serverDefaults = new FsServerDefaults(conf.getLong("dfs.blocksize", 0x4000000L), conf.getInt("dfs.bytes-per-checksum", 512), conf.getInt("dfs.client-write-packet-size", 65536), (short)conf.getInt("dfs.replication", 3), conf.getInt("io.file.buffer.size", 4096));
        this.maxFsObjects = conf.getLong("dfs.namenode.max.objects", 0L);
        this.blockInvalidateLimit = Math.max(this.blockInvalidateLimit, 20 * (int)(heartbeatInterval / 1000L));
        this.accessTimePrecision = conf.getLong("dfs.namenode.accesstime.precision", 0L);
        this.supportAppends = conf.getBoolean("dfs.support.append", true);
        this.isBlockTokenEnabled = conf.getBoolean("dfs.block.access.token.enable", false);
        if (this.isBlockTokenEnabled) {
            this.blockKeyUpdateInterval = conf.getLong("dfs.block.access.key.update.interval", 600L) * 60L * 1000L;
            this.blockTokenLifetime = conf.getLong("dfs.block.access.token.lifetime", 600L) * 60L * 1000L;
        }
        LOG.info((Object)("isBlockTokenEnabled=" + this.isBlockTokenEnabled + " blockKeyUpdateInterval=" + this.blockKeyUpdateInterval / 60000L + " min(s), blockTokenLifetime=" + this.blockTokenLifetime / 60000L + " min(s)"));
    }

    protected PermissionStatus getUpgradePermission() {
        return this.defaultPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamespaceInfo getNamespaceInfo() {
        this.readLock();
        try {
            NamespaceInfo namespaceInfo = new NamespaceInfo(this.dir.fsImage.getNamespaceID(), this.dir.fsImage.getCTime(), this.getDistributedUpgradeVersion());
            return namespaceInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        block23: {
            block21: {
                this.fsRunning = false;
                if (this.blockManager != null) {
                    this.blockManager.close();
                }
                if (this.hbthread != null) {
                    this.hbthread.interrupt();
                }
                if (this.replthread != null) {
                    this.replthread.interrupt();
                }
                if (this.dnthread != null) {
                    this.dnthread.interrupt();
                }
                if (this.smmthread != null) {
                    this.smmthread.interrupt();
                }
                if (this.dtSecretManager == null) break block21;
                this.dtSecretManager.stopThreads();
            }
            try {
                if (this.lmthread != null) {
                    this.lmthread.interrupt();
                    this.lmthread.join(3000L);
                }
                this.dir.close();
            }
            catch (InterruptedException ie) {
            }
            catch (IOException ie) {
                LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
            }
            break block23;
            catch (Exception e) {
                try {
                    LOG.warn((Object)"Exception shutting down FSNamesystem", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.lmthread != null) {
                            this.lmthread.interrupt();
                            this.lmthread.join(3000L);
                        }
                        this.dir.close();
                    }
                    catch (InterruptedException ie) {
                    }
                    catch (IOException ie) {
                        LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
                    }
                    throw throwable;
                }
                try {
                    if (this.lmthread != null) {
                        this.lmthread.interrupt();
                        this.lmthread.join(3000L);
                    }
                    this.dir.close();
                }
                catch (InterruptedException ie) {
                }
                catch (IOException ie) {
                    LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.dir});
                }
            }
        }
    }

    boolean isRunning() {
        return this.fsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        this.writeLock();
        try {
            this.checkSuperuserPrivilege();
            File file = new File(System.getProperty("hadoop.log.dir"), filename);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            long totalInodes = this.dir.totalInodes();
            long totalBlocks = this.getBlocksTotal();
            ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
            ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
            this.DFSNodesStatus(live, dead);
            String str = totalInodes + " files and directories, " + totalBlocks + " blocks = " + (totalInodes + totalBlocks) + " total";
            out.println(str);
            out.println("Live Datanodes: " + live.size());
            out.println("Dead Datanodes: " + dead.size());
            this.blockManager.metaSave(out);
            this.datanodeDump(out);
            out.flush();
            out.close();
        }
        finally {
            this.writeUnlock();
        }
    }

    long getDefaultBlockSize() {
        return this.serverDefaults.getBlockSize();
    }

    FsServerDefaults getServerDefaults() {
        return this.serverDefaults;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    private boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlocksWithLocations getBlocks(DatanodeID datanode, long size) throws IOException {
        this.readLock();
        try {
            BlockInfo curBlock;
            this.checkSuperuserPrivilege();
            DatanodeDescriptor node = this.getDatanode(datanode);
            if (node == null) {
                NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.getBlocks: Asking for blocks from an unrecorded node " + datanode.getName()));
                throw new IllegalArgumentException("Unexpected exception.  Got getBlocks message for datanode " + datanode.getName() + ", but there is no info for it");
            }
            int numBlocks = node.numBlocks();
            if (numBlocks == 0) {
                BlocksWithLocations blocksWithLocations = new BlocksWithLocations(new BlocksWithLocations.BlockWithLocations[0]);
                return blocksWithLocations;
            }
            Iterator<BlockInfo> iter = node.getBlockIterator();
            int startBlock = this.r.nextInt(numBlocks);
            for (int i = 0; i < startBlock; ++i) {
                iter.next();
            }
            ArrayList<BlocksWithLocations.BlockWithLocations> results = new ArrayList<BlocksWithLocations.BlockWithLocations>();
            long totalSize = 0L;
            while (totalSize < size && iter.hasNext()) {
                curBlock = iter.next();
                if (!curBlock.isComplete()) continue;
                totalSize += this.addBlock(curBlock, results);
            }
            if (totalSize < size) {
                iter = node.getBlockIterator();
                for (int i = 0; i < startBlock && totalSize < size; ++i) {
                    curBlock = iter.next();
                    if (!curBlock.isComplete()) continue;
                    totalSize += this.addBlock(curBlock, results);
                }
            }
            BlocksWithLocations blocksWithLocations = new BlocksWithLocations(results.toArray(new BlocksWithLocations.BlockWithLocations[results.size()]));
            return blocksWithLocations;
        }
        finally {
            this.readUnlock();
        }
    }

    ExportedBlockKeys getBlockKeys() {
        return this.isBlockTokenEnabled ? this.blockTokenSecretManager.exportKeys() : ExportedBlockKeys.DUMMY_KEYS;
    }

    private long addBlock(Block block, List<BlocksWithLocations.BlockWithLocations> results) {
        ArrayList<String> machineSet = this.blockManager.getValidLocations(block);
        if (machineSet.size() == 0) {
            return 0L;
        }
        results.add(new BlocksWithLocations.BlockWithLocations(block, machineSet.toArray(new String[machineSet.size()])));
        return block.getNumBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set permission for " + src, this.safeMode);
            }
            this.checkOwner(src);
            this.dir.setPermission(src, permission);
            this.getEditLog().logSync();
            if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
                HdfsFileStatus stat = this.dir.getFileInfo(src, false);
                FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "setPermission", src, null, stat);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(String src, String username, String group) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set owner for " + src, this.safeMode);
            }
            FSPermissionChecker pc = this.checkOwner(src);
            if (!pc.isSuper) {
                if (username != null && !pc.user.equals(username)) {
                    throw new AccessControlException("Non-super user cannot change owner.");
                }
                if (group != null && !pc.containsGroup(group)) {
                    throw new AccessControlException("User does not belong to " + group + " .");
                }
            }
            this.dir.setOwner(src, username, group);
            this.getEditLog().logSync();
            if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
                HdfsFileStatus stat = this.dir.getFileInfo(src, false);
                FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "setOwner", src, null, stat);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    LocatedBlocks getBlockLocations(String clientMachine, String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        LocatedBlocks blocks = this.getBlockLocations(src, offset, length, true, true);
        if (blocks != null) {
            DatanodeDescriptor client = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
            for (LocatedBlock b : blocks.getLocatedBlocks()) {
                this.clusterMap.pseudoSortByDistance((Node)client, (Node[])b.getLocations());
            }
        }
        return blocks;
    }

    LocatedBlocks getBlockLocations(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken) throws FileNotFoundException, UnresolvedLinkException, IOException {
        if (this.isPermissionEnabled) {
            this.checkPathAccess(src, FsAction.READ);
        }
        if (offset < 0L) {
            throw new HadoopIllegalArgumentException("Negative offset is not supported. File: " + src);
        }
        if (length < 0L) {
            throw new HadoopIllegalArgumentException("Negative length is not supported. File: " + src);
        }
        LocatedBlocks ret = this.getBlockLocationsInternal(src, offset, length, doAccessTime, needBlockToken);
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "open", src, null, null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlocks getBlockLocationsInternal(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken) throws FileNotFoundException, UnresolvedLinkException, IOException {
        for (int attempt = 0; attempt < 2; ++attempt) {
            if (attempt == 0) {
                this.readLock();
            } else {
                this.writeLock();
            }
            try {
                long now = Util.now();
                INodeFile inode = this.dir.getFileINode(src);
                if (inode == null) {
                    throw new FileNotFoundException("File does not exist: " + src);
                }
                assert (!inode.isLink());
                if (doAccessTime && this.isAccessTimeSupported()) {
                    if (now <= inode.getAccessTime() + this.getAccessTimePrecision() && attempt == 0) continue;
                    this.dir.setTimes(src, inode, -1L, now, false);
                }
                LocatedBlocks locatedBlocks = this.getBlockLocationsInternal(inode, offset, length, needBlockToken);
                return locatedBlocks;
            }
            finally {
                if (attempt == 0) {
                    this.readUnlock();
                } else {
                    this.writeUnlock();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlocks getBlockLocationsInternal(INodeFile inode, long offset, long length, boolean needBlockToken) throws IOException {
        this.readLock();
        try {
            BlockInfo[] blocks = inode.getBlocks();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("blocks = " + Arrays.asList(blocks)));
            }
            if (blocks == null) {
                LocatedBlocks locatedBlocks = null;
                return locatedBlocks;
            }
            if (blocks.length == 0) {
                LocatedBlocks locatedBlocks = new LocatedBlocks(0L, inode.isUnderConstruction(), Collections.<LocatedBlock>emptyList(), null, false);
                return locatedBlocks;
            }
            long n = inode.computeFileSize(false);
            List<LocatedBlock> locatedblocks = this.blockManager.getBlockLocations(blocks, offset, length, Integer.MAX_VALUE);
            Object last = inode.getLastBlock();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("last = " + last));
            }
            if (this.isBlockTokenEnabled && needBlockToken) {
                this.setBlockTokens(locatedblocks);
            }
            if (((BlockInfo)last).isComplete()) {
                LocatedBlocks locatedBlocks = new LocatedBlocks(n, inode.isUnderConstruction(), locatedblocks, this.blockManager.getBlockLocation((BlockInfo)last, n - ((Block)last).getNumBytes()), true);
                return locatedBlocks;
            }
            LocatedBlocks locatedBlocks = new LocatedBlocks(n, inode.isUnderConstruction(), locatedblocks, this.blockManager.getBlockLocation((BlockInfo)last, n), false);
            return locatedBlocks;
        }
        finally {
            this.readUnlock();
        }
    }

    private void setBlockTokens(List<LocatedBlock> locatedBlocks) throws IOException {
        for (LocatedBlock l : locatedBlocks) {
            Token<BlockTokenIdentifier> token = this.blockTokenSecretManager.generateToken(l.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.READ));
            l.setBlockToken(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concat(String target, String[] srcs) throws IOException, UnresolvedLinkException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat " + Arrays.toString(srcs) + " to " + target));
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("concat: cannot concat " + target, this.safeMode);
        }
        if (target.isEmpty()) {
            throw new IllegalArgumentException("concat: trg file name is empty");
        }
        if (srcs == null || srcs.length == 0) {
            throw new IllegalArgumentException("concat: srcs list is empty or null");
        }
        String trgParent = target.substring(0, target.lastIndexOf(47));
        for (String s : srcs) {
            String srcParent = s.substring(0, s.lastIndexOf(47));
            if (srcParent.equals(trgParent)) continue;
            throw new IllegalArgumentException("concat:  srcs and target shoould be in same dir");
        }
        this.writeLock();
        try {
            if (this.isPermissionEnabled) {
                this.checkPathAccess(target, FsAction.WRITE);
                for (String aSrc : srcs) {
                    this.checkPathAccess(aSrc, FsAction.READ);
                    this.checkParentAccess(aSrc, FsAction.WRITE);
                }
            }
            HashSet<INodeFile> si = new HashSet<INodeFile>();
            INodeFile inode = this.dir.getFileINode(target);
            if (inode == null) {
                throw new IllegalArgumentException("concat: trg file doesn't exist");
            }
            if (inode.isUnderConstruction()) {
                throw new IllegalArgumentException("concat: trg file is uner construction");
            }
            INodeFile trgInode = inode;
            if (trgInode.blocks.length == 0) {
                throw new IllegalArgumentException("concat: " + target + " file is empty");
            }
            long blockSize = trgInode.getPreferredBlockSize();
            if (blockSize != trgInode.blocks[trgInode.blocks.length - 1].getNumBytes()) {
                throw new IllegalArgumentException(target + " blocks size should be the same");
            }
            si.add(trgInode);
            short repl = trgInode.getReplication();
            boolean endSrc = false;
            for (int i = 0; i < srcs.length; ++i) {
                String src = srcs[i];
                if (i == srcs.length - 1) {
                    endSrc = true;
                }
                INodeFile srcInode = this.dir.getFileINode(src);
                if (src.isEmpty() || srcInode == null || srcInode.isUnderConstruction() || srcInode.blocks.length == 0) {
                    throw new IllegalArgumentException("concat: file " + src + " is invalid or empty or underConstruction");
                }
                if (repl != srcInode.getReplication()) {
                    throw new IllegalArgumentException(src + " and " + target + " " + "should have same replication: " + repl + " vs. " + srcInode.getReplication());
                }
                int idx = srcInode.blocks.length - 1;
                if (endSrc) {
                    idx = srcInode.blocks.length - 2;
                }
                if (idx >= 0 && srcInode.blocks[idx].getNumBytes() != blockSize) {
                    throw new IllegalArgumentException("concat: blocks sizes of " + src + " and " + target + " should all be the same");
                }
                si.add(srcInode);
            }
            if (si.size() < srcs.length + 1) {
                throw new IllegalArgumentException("at least two files are the same");
            }
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.concat: " + Arrays.toString(srcs) + " to " + target));
            }
            this.dir.concatInternal(target, srcs);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(target, false);
            FSNamesystem.logAuditEvent(UserGroupInformation.getLoginUser(), Server.getRemoteIp(), "concat", Arrays.toString(srcs), target, stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimes(String src, long mtime, long atime) throws IOException, UnresolvedLinkException {
        block7: {
            if (!this.isAccessTimeSupported() && atime != -1L) {
                throw new IOException("Access time for hdfs is not configured.  Please set dfs.support.accessTime configuration parameter.");
            }
            this.writeLock();
            try {
                INodeFile inode;
                if (this.isPermissionEnabled) {
                    this.checkPathAccess(src, FsAction.WRITE);
                }
                if ((inode = this.dir.getFileINode(src)) != null) {
                    this.dir.setTimes(src, inode, mtime, atime, true);
                    if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
                        HdfsFileStatus stat = this.dir.getFileInfo(src, false);
                        FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "setTimes", src, null, stat);
                    }
                    break block7;
                }
                throw new FileNotFoundException("File " + src + " does not exist.");
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSymlink(String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        this.writeLock();
        try {
            if (!createParent) {
                this.verifyParentDir(link);
            }
            this.createSymlinkInternal(target, link, dirPerms, createParent);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(link, false);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "createSymlink", link, target, stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSymlinkInternal(String target, String link, PermissionStatus dirPerms, boolean createParent) throws IOException, UnresolvedLinkException {
        this.writeLock();
        try {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.createSymlink: target=" + target + " link=" + link));
            }
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot create symlink " + link, this.safeMode);
            }
            if (!DFSUtil.isValidName(link)) {
                throw new InvalidPathException("Invalid file name: " + link);
            }
            if (!this.dir.isValidToCreate(link)) {
                throw new IOException("failed to create link " + link + " either because the filename is invalid or the file exists");
            }
            if (this.isPermissionEnabled) {
                this.checkAncestorAccess(link, FsAction.WRITE);
            }
            this.checkFsObjectLimit();
            this.dir.addSymlink(link, target, dirPerms, createParent);
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean setReplication(String src, short replication) throws IOException, UnresolvedLinkException {
        boolean status = this.setReplicationInternal(src, replication);
        this.getEditLog().logSync();
        if (status && auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "setReplication", src, null, null);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setReplicationInternal(String src, short replication) throws AccessControlException, QuotaExceededException, SafeModeException, UnresolvedLinkException, IOException {
        this.writeLock();
        try {
            int idx;
            int[] oldReplication;
            Block[] fileBlocks;
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set replication for " + src, this.safeMode);
            }
            this.blockManager.verifyReplication(src, replication, null);
            if (this.isPermissionEnabled) {
                this.checkPathAccess(src, FsAction.WRITE);
            }
            if ((fileBlocks = this.dir.setReplication(src, replication, oldReplication = new int[1])) == null) {
                boolean bl = false;
                return bl;
            }
            int oldRepl = oldReplication[0];
            if (oldRepl == replication) {
                boolean bl = true;
                return bl;
            }
            for (idx = 0; idx < fileBlocks.length; ++idx) {
                this.blockManager.updateNeededReplications(fileBlocks[idx], 0, replication - oldRepl);
            }
            if (oldRepl > replication) {
                LOG.info((Object)("Reducing replication for file " + src + ". New replication is " + replication));
                for (idx = 0; idx < fileBlocks.length; ++idx) {
                    this.blockManager.processOverReplicatedBlock(fileBlocks[idx], replication, null, null);
                }
            } else {
                LOG.info((Object)("Increasing replication for file " + src + ". New replication is " + replication));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
        if (this.isPermissionEnabled) {
            this.checkTraverse(filename);
        }
        return this.dir.getPreferredBlockSize(filename);
    }

    private void verifyParentDir(String src) throws FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException {
        Path parent = new Path(src).getParent();
        if (parent != null) {
            INode[] pathINodes = this.dir.getExistingPathINodes(parent.toString());
            INode parentNode = pathINodes[pathINodes.length - 1];
            if (parentNode == null) {
                throw new FileNotFoundException("Parent directory doesn't exist: " + parent.toString());
            }
            if (!parentNode.isDirectory() && !parentNode.isLink()) {
                throw new ParentNotDirectoryException("Parent path is not a directory: " + parent.toString());
            }
        }
    }

    void startFile(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws AccessControlException, SafeModeException, FileAlreadyExistsException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        this.startFileInternal(src, permissions, holder, clientMachine, flag, createParent, replication, blockSize);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(src, false);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "create", src, null, stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private LocatedBlock startFileInternal(String src, PermissionStatus permissions, String holder, String clientMachine, EnumSet<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws SafeModeException, FileAlreadyExistsException, AccessControlException, UnresolvedLinkException, FileNotFoundException, ParentNotDirectoryException, IOException {
        this.writeLock();
        try {
            block29: {
                block28: {
                    overwrite = flag.contains(CreateFlag.OVERWRITE);
                    append = flag.contains(CreateFlag.APPEND);
                    create = flag.contains(CreateFlag.CREATE);
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: src=" + src + ", holder=" + holder + ", clientMachine=" + clientMachine + ", createParent=" + createParent + ", replication=" + replication + ", overwrite=" + overwrite + ", append=" + append));
                    }
                    if (this.isInSafeMode()) {
                        throw new SafeModeException("Cannot create file" + src, this.safeMode);
                    }
                    if (!DFSUtil.isValidName(src)) {
                        throw new InvalidPathException(src);
                    }
                    pathExists = this.dir.exists(src);
                    if (pathExists && this.dir.isDir(src)) {
                        throw new FileAlreadyExistsException("Cannot create file " + src + "; already exists as a directory.");
                    }
                    if (this.isPermissionEnabled) {
                        if (append || overwrite && pathExists) {
                            this.checkPathAccess(src, FsAction.WRITE);
                        } else {
                            this.checkAncestorAccess(src, FsAction.WRITE);
                        }
                    }
                    if (!createParent) {
                        this.verifyParentDir(src);
                    }
                    myFile = this.dir.getFileINode(src);
                    this.recoverLeaseInternal(myFile, src, holder, clientMachine, false);
                    try {
                        this.blockManager.verifyReplication(src, replication, clientMachine);
                    }
                    catch (IOException e) {
                        throw new IOException("failed to create " + e.getMessage());
                    }
                    if (!append) break block28;
                    if (myFile == null) {
                        if (!create) {
                            throw new FileNotFoundException("failed to append to non-existent file " + src + " on client " + clientMachine);
                        }
                        e = this.startFileInternal(src, permissions, holder, clientMachine, EnumSet.of(CreateFlag.OVERWRITE), createParent, replication, blockSize);
                        return e;
                    }
                    ** if (!myFile.isDirectory()) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        throw new IOException("failed to append to directory " + src + " on client " + clientMachine);
                    }
lbl-1000:
                    // 1 sources

                    {
                        break block29;
                    }
                }
                if (!this.dir.isValidToCreate(src)) {
                    if (overwrite) {
                        this.delete(src, true);
                    } else {
                        throw new IOException("failed to create file " + src + " on client " + clientMachine + " either because the filename is invalid or the file exists");
                    }
                }
            }
            clientNode = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
            if (append) {
                node = myFile;
                cons = new INodeFileUnderConstruction(node.getLocalNameBytes(), node.getReplication(), node.getModificationTime(), node.getPreferredBlockSize(), node.getBlocks(), node.getPermissionStatus(), holder, clientMachine, clientNode);
                this.dir.replaceNode(src, node, cons);
                this.leaseManager.addLease(cons.getClientName(), src);
                lb = this.blockManager.convertLastBlockToUnderConstruction(cons);
                if (lb != null && this.isBlockTokenEnabled) {
                    lb.setBlockToken(this.blockTokenSecretManager.generateToken(lb.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
                }
                var19_23 = lb;
                return var19_23;
            }
            try {
                this.checkFsObjectLimit();
                genstamp = this.nextGenerationStamp();
                newNode = this.dir.addFile(src, permissions, replication, blockSize, holder, clientMachine, clientNode, genstamp);
                if (newNode == null) {
                    throw new IOException("DIR* NameSystem.startFile: Unable to add file to namespace.");
                }
                this.leaseManager.addLease(newNode.getClientName(), src);
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: add " + src + " to namespace for " + holder));
                }
            }
            catch (IOException ie) {
                NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.startFile: " + ie.getMessage()));
                throw ie;
            }
        }
        finally {
            this.writeUnlock();
        }
        return null;
    }

    synchronized boolean recoverLease(String src, String holder, String clientMachine) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot recover the lease of " + src, this.safeMode);
        }
        if (!DFSUtil.isValidName(src)) {
            throw new IOException("Invalid file name: " + src);
        }
        INodeFile inode = this.dir.getFileINode(src);
        if (inode == null) {
            throw new FileNotFoundException("File not found " + src);
        }
        if (!inode.isUnderConstruction()) {
            return true;
        }
        if (this.isPermissionEnabled) {
            this.checkPathAccess(src, FsAction.WRITE);
        }
        this.recoverLeaseInternal(inode, src, holder, clientMachine, true);
        return false;
    }

    private void recoverLeaseInternal(INode fileInode, String src, String holder, String clientMachine, boolean force) throws IOException {
        if (fileInode != null && fileInode.isUnderConstruction()) {
            LeaseManager.Lease leaseFile;
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)fileInode;
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && ((leaseFile = this.leaseManager.getLeaseByPath(src)) != null && leaseFile.equals(lease) || lease.getHolder().equals(holder))) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because current leaseholder is trying to recreate file.");
            }
            lease = this.leaseManager.getLease(pendingFile.getClientName());
            if (lease == null) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because pendingCreates is non-null but no leases found.");
            }
            if (force) {
                LOG.info((Object)("recoverLease: recover lease " + lease + ", src=" + src + " from client " + pendingFile.getClientName()));
                this.internalReleaseLease(lease, src, holder);
            } else {
                assert (lease.getHolder().equals(pendingFile.getClientName())) : "Current lease holder " + lease.getHolder() + " does not match file creator " + pendingFile.getClientName();
                if (lease.expiredSoftLimit()) {
                    LOG.info((Object)("startFile: recover lease " + lease + ", src=" + src + " from client " + pendingFile.getClientName()));
                    boolean isClosed = this.internalReleaseLease(lease, src, null);
                    if (!isClosed) {
                        throw new RecoveryInProgressException("Failed to close file " + src + ". Lease recovery is in progress. Try again later.");
                    }
                } else {
                    BlockInfoUnderConstruction lastBlock = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
                    if (lastBlock != null && lastBlock.getBlockUCState() == HdfsConstants.BlockUCState.UNDER_RECOVERY) {
                        throw new RecoveryInProgressException("Recovery in progress, file [" + src + "], " + "lease owner [" + lease.getHolder() + "]");
                    }
                    throw new AlreadyBeingCreatedException("Failed to create file [" + src + "] for [" + holder + "] on client [" + clientMachine + "], because this file is already being created by [" + pendingFile.getClientName() + "] on [" + pendingFile.getClientMachine() + "]");
                }
            }
        }
    }

    LocatedBlock appendFile(String src, String holder, String clientMachine) throws AccessControlException, SafeModeException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, IOException {
        if (!this.supportAppends) {
            throw new UnsupportedOperationException("Append to hdfs not supported. Please refer to dfs.support.append configuration parameter.");
        }
        LocatedBlock lb = this.startFileInternal(src, null, holder, clientMachine, EnumSet.of(CreateFlag.APPEND), false, (short)this.blockManager.maxReplication, 0L);
        this.getEditLog().logSync();
        if (lb != null && NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.appendFile: file " + src + " for " + holder + " at " + clientMachine + " block " + lb.getBlock() + " block size " + lb.getBlock().getNumBytes()));
        }
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "append", src, null, null);
        }
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatedBlock getAdditionalBlock(String src, String clientName, Block previous, HashMap<Node, Node> excludedNodes) throws LeaseExpiredException, NotReplicatedYetException, QuotaExceededException, SafeModeException, UnresolvedLinkException, IOException {
        short replication;
        long blockSize;
        long fileLength;
        DatanodeDescriptor clientNode = null;
        Block newBlock = null;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.getAdditionalBlock: file " + src + " for " + clientName));
        }
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add block to " + src, this.safeMode);
            }
            this.checkFsObjectLimit();
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            this.blockManager.commitOrCompleteLastBlock(pendingFile, previous);
            if (!this.checkFileProgress(pendingFile, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + src);
            }
            fileLength = pendingFile.computeContentSummary().getLength();
            blockSize = pendingFile.getPreferredBlockSize();
            clientNode = pendingFile.getClientNode();
            replication = pendingFile.getReplication();
        }
        finally {
            this.writeUnlock();
        }
        DatanodeInfo[] targets = this.blockManager.replicator.chooseTarget(src, (int)replication, clientNode, excludedNodes, blockSize);
        if (targets.length < this.blockManager.minReplication) {
            throw new IOException("File " + src + " could only be replicated to " + targets.length + " nodes, instead of " + this.blockManager.minReplication);
        }
        this.writeLock();
        try {
            INode[] pathINodes = this.dir.getExistingPathINodes(src);
            int inodesLen = pathINodes.length;
            this.checkLease(src, clientName, pathINodes[inodesLen - 1]);
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)pathINodes[inodesLen - 1];
            if (!this.checkFileProgress(pendingFile, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + src);
            }
            newBlock = this.allocateBlock(src, pathINodes, (DatanodeDescriptor[])targets);
            for (DatanodeDescriptor datanodeDescriptor : targets) {
                datanodeDescriptor.incBlocksScheduled();
            }
        }
        finally {
            this.writeUnlock();
        }
        LocatedBlock b = new LocatedBlock(newBlock, targets, fileLength);
        if (this.isBlockTokenEnabled) {
            b.setBlockToken(this.blockTokenSecretManager.generateToken(b.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abandonBlock(Block b, String src, String holder) throws LeaseExpiredException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot addbandon block " + b + " for file " + src, this.safeMode);
            }
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + "of file " + src));
            }
            INodeFileUnderConstruction file = this.checkLease(src, holder);
            this.dir.removeBlock(src, file, b);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + " is removed from pendingCreates"));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    private INodeFileUnderConstruction checkLease(String src, String holder) throws LeaseExpiredException, UnresolvedLinkException {
        INodeFile file = this.dir.getFileINode(src);
        this.checkLease(src, holder, file);
        return (INodeFileUnderConstruction)file;
    }

    private void checkLease(String src, String holder, INode file) throws LeaseExpiredException {
        if (file == null || file.isDirectory()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + " File does not exist. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        if (!file.isUnderConstruction()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + " File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)file;
        if (holder != null && !pendingFile.getClientName().equals(holder)) {
            throw new LeaseExpiredException("Lease mismatch on " + src + " owned by " + pendingFile.getClientName() + " but is accessed by " + holder);
        }
    }

    public boolean completeFile(String src, String holder, Block last) throws SafeModeException, UnresolvedLinkException, IOException {
        boolean success = this.completeFileInternal(src, holder, last);
        this.getEditLog().logSync();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeFileInternal(String src, String holder, Block last) throws SafeModeException, UnresolvedLinkException, IOException {
        this.writeLock();
        try {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " for " + holder));
            }
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot complete file " + src, this.safeMode);
            }
            INodeFileUnderConstruction pendingFile = this.checkLease(src, holder);
            this.blockManager.commitOrCompleteLastBlock(pendingFile, last);
            if (!this.checkFileProgress(pendingFile, true)) {
                boolean bl = false;
                return bl;
            }
            this.finalizeINodeFileUnderConstruction(src, pendingFile);
            NameNode.stateChangeLog.info((Object)("DIR* NameSystem.completeFile: file " + src + " is closed by " + holder));
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void checkReplicationFactor(INodeFile file) {
        short numExpectedReplicas = file.getReplication();
        BlockInfo[] pendingBlocks = file.getBlocks();
        int nrBlocks = pendingBlocks.length;
        for (int i = 0; i < nrBlocks; ++i) {
            this.blockManager.checkReplication(pendingBlocks[i], numExpectedReplicas);
        }
    }

    private Block allocateBlock(String src, INode[] inodes, DatanodeDescriptor[] targets) throws QuotaExceededException {
        Block b = new Block(randBlockId.nextLong(), 0L, 0L);
        while (this.isValidBlock(b)) {
            b.setBlockId(randBlockId.nextLong());
        }
        b.setGenerationStamp(this.getGenerationStamp());
        b = this.dir.addBlock(src, inodes, b, targets);
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.allocateBlock: " + src + ". " + b));
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFileProgress(INodeFile v, boolean checkall) {
        this.writeLock();
        try {
            if (checkall) {
                for (BlockInfo block : v.getBlocks()) {
                    if (block.isComplete()) continue;
                    LOG.info((Object)("BLOCK* NameSystem.checkFileProgress: block " + block + " has not reached minimal replication " + this.blockManager.minReplication));
                    boolean bl = false;
                    return bl;
                }
            } else {
                BlockInfo b = v.getPenultimateBlock();
                if (b != null && !b.isComplete()) {
                    LOG.info((Object)("BLOCK* NameSystem.checkFileProgress: block " + b + " has not reached minimal replication " + this.blockManager.minReplication));
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markBlockAsCorrupt(Block blk, DatanodeInfo dn) throws IOException {
        this.writeLock();
        try {
            this.blockManager.findAndMarkBlockAsCorrupt(blk, dn);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Deprecated
    boolean renameTo(String src, String dst) throws IOException, UnresolvedLinkException {
        boolean status = this.renameToInternal(src, dst);
        this.getEditLog().logSync();
        if (status && auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(dst, false);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "rename", src, dst, stat);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private boolean renameToInternal(String src, String dst) throws IOException, UnresolvedLinkException {
        this.writeLock();
        try {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: " + src + " to " + dst));
            }
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot rename " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(dst)) {
                throw new IOException("Invalid name: " + dst);
            }
            if (this.isPermissionEnabled) {
                String actualdst = this.dir.isDir(dst) ? dst + "/" + new Path(src).getName() : dst;
                this.checkParentAccess(src, FsAction.WRITE);
                this.checkAncestorAccess(actualdst, FsAction.WRITE);
            }
            HdfsFileStatus dinfo = this.dir.getFileInfo(dst, false);
            if (this.dir.renameTo(src, dst)) {
                this.changeLease(src, dst, dinfo);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    void renameTo(String src, String dst, Options.Rename ... options) throws IOException, UnresolvedLinkException {
        this.renameToInternal(src, dst, options);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            StringBuilder cmd = new StringBuilder("rename options=");
            for (Options.Rename option : options) {
                cmd.append(option.value()).append(" ");
            }
            HdfsFileStatus stat = this.dir.getFileInfo(dst, false);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), cmd.toString(), src, dst, stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameToInternal(String src, String dst, Options.Rename ... options) throws IOException {
        this.writeLock();
        try {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: with options - " + src + " to " + dst));
            }
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot rename " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(dst)) {
                throw new InvalidPathException("Invalid name: " + dst);
            }
            if (this.isPermissionEnabled) {
                this.checkParentAccess(src, FsAction.WRITE);
                this.checkAncestorAccess(dst, FsAction.WRITE);
            }
            HdfsFileStatus dinfo = this.dir.getFileInfo(dst, false);
            this.dir.renameTo(src, dst, options);
            this.changeLease(src, dst, dinfo);
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean delete(String src, boolean recursive) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        boolean status;
        if (!recursive && !this.dir.isDirEmpty(src)) {
            throw new IOException(src + " is non empty");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.delete: " + src));
        }
        if ((status = this.deleteInternal(src, true)) && auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "delete", src, null, null);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteInternal(String src, boolean enforcePermission) throws AccessControlException, SafeModeException, UnresolvedLinkException, IOException {
        boolean deleteNow = false;
        ArrayList<Block> collectedBlocks = new ArrayList<Block>();
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot delete " + src, this.safeMode);
            }
            if (enforcePermission && this.isPermissionEnabled) {
                this.checkPermission(src, false, null, FsAction.WRITE, null, FsAction.ALL);
            }
            if (!this.dir.delete(src, collectedBlocks)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = deleteNow = collectedBlocks.size() <= BLOCK_DELETION_INCREMENT;
            if (deleteNow) {
                this.removeBlocks(collectedBlocks);
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        if (!deleteNow) {
            this.removeBlocks(collectedBlocks);
        }
        collectedBlocks.clear();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* Namesystem.delete: " + src + " is removed"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBlocks(List<Block> blocks) {
        int start = 0;
        int end = 0;
        while (start < blocks.size()) {
            end = BLOCK_DELETION_INCREMENT + start;
            end = end > blocks.size() ? blocks.size() : end;
            this.writeLock();
            try {
                for (int i = start; i < end; ++i) {
                    this.blockManager.removeBlock(blocks.get(i));
                }
            }
            finally {
                this.writeUnlock();
            }
            start = end;
        }
    }

    void removePathAndBlocks(String src, List<Block> blocks) {
        this.leaseManager.removeLeaseWithPrefixPath(src);
        if (blocks == null) {
            return;
        }
        for (Block b : blocks) {
            this.blockManager.removeBlock(b);
        }
    }

    HdfsFileStatus getFileInfo(String src, boolean resolveLink) throws AccessControlException, UnresolvedLinkException {
        if (!DFSUtil.isValidName(src)) {
            throw new InvalidPathException("Invalid file name: " + src);
        }
        if (this.isPermissionEnabled) {
            this.checkTraverse(src);
        }
        return this.dir.getFileInfo(src, resolveLink);
    }

    public boolean mkdirs(String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        boolean status = this.mkdirsInternal(src, permissions, createParent);
        this.getEditLog().logSync();
        if (status && auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(src, false);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "mkdirs", src, null, stat);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mkdirsInternal(String src, PermissionStatus permissions, boolean createParent) throws IOException, UnresolvedLinkException {
        this.writeLock();
        try {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.mkdirs: " + src));
            }
            if (this.isPermissionEnabled) {
                this.checkTraverse(src);
            }
            if (this.dir.isDir(src)) {
                boolean bl = true;
                return bl;
            }
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot create directory " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(src)) {
                throw new InvalidPathException(src);
            }
            if (this.isPermissionEnabled) {
                this.checkAncestorAccess(src, FsAction.WRITE);
            }
            if (!createParent) {
                this.verifyParentDir(src);
            }
            this.checkFsObjectLimit();
            if (!this.dir.mkdirs(src, permissions, false, Util.now())) {
                throw new IOException("Failed to create directory: " + src);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    ContentSummary getContentSummary(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException {
        if (this.isPermissionEnabled) {
            this.checkPermission(src, false, null, null, null, FsAction.READ_EXECUTE);
        }
        return this.dir.getContentSummary(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String path, long nsQuota, long dsQuota) throws IOException, UnresolvedLinkException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set quota on " + path, this.safeMode);
            }
            if (this.isPermissionEnabled) {
                this.checkSuperuserPrivilege();
            }
            this.dir.setQuota(path, nsQuota, dsQuota);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync(String src, String clientName) throws IOException, UnresolvedLinkException {
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.fsync: file " + src + " for " + clientName));
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot fsync file " + src, this.safeMode);
            }
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            this.dir.persistBlocks(src, pendingFile);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    boolean internalReleaseLease(LeaseManager.Lease lease, String src, String recoveryLeaseHolder) throws AlreadyBeingCreatedException, IOException, UnresolvedLinkException {
        boolean penultimateBlockMinReplication;
        HdfsConstants.BlockUCState penultimateBlockState;
        int nrCompleteBlocks;
        LOG.info((Object)("Recovering lease=" + lease + ", src=" + src));
        INodeFile iFile = this.dir.getFileINode(src);
        if (iFile == null) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " file does not exist.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        if (!iFile.isUnderConstruction()) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)iFile;
        int nrBlocks = pendingFile.numBlocks();
        BlockInfo[] blocks = pendingFile.getBlocks();
        BlockInfo curBlock = null;
        for (nrCompleteBlocks = 0; nrCompleteBlocks < nrBlocks && (curBlock = blocks[nrCompleteBlocks]).isComplete(); ++nrCompleteBlocks) {
            assert (this.blockManager.checkMinReplication(curBlock)) : "A COMPLETE block is not minimally replicated in " + src;
        }
        if (nrCompleteBlocks == nrBlocks) {
            this.finalizeINodeFileUnderConstruction(src, pendingFile);
            NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: All existing blocks are COMPLETE, lease removed, file closed.");
            return true;
        }
        if (nrCompleteBlocks < nrBlocks - 2 || nrCompleteBlocks == nrBlocks - 2 && curBlock.getBlockUCState() != HdfsConstants.BlockUCState.COMMITTED) {
            String message = "DIR* NameSystem.internalReleaseLease: attempt to release a create lock on " + src + " but file is already closed.";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        BlockInfoUnderConstruction lastBlock = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
        HdfsConstants.BlockUCState lastBlockState = lastBlock.getBlockUCState();
        BlockInfo penultimateBlock = pendingFile.getPenultimateBlock();
        if (penultimateBlock == null) {
            penultimateBlockState = HdfsConstants.BlockUCState.COMPLETE;
            penultimateBlockMinReplication = true;
        } else {
            penultimateBlockState = HdfsConstants.BlockUCState.COMMITTED;
            penultimateBlockMinReplication = this.blockManager.checkMinReplication(penultimateBlock);
        }
        assert (penultimateBlockState == HdfsConstants.BlockUCState.COMPLETE || penultimateBlockState == HdfsConstants.BlockUCState.COMMITTED) : "Unexpected state of penultimate block in " + src;
        switch (lastBlockState) {
            case COMPLETE: {
                assert (false) : "Already checked that the last block is incomplete";
                break;
            }
            case COMMITTED: {
                if (penultimateBlockMinReplication && this.blockManager.checkMinReplication(lastBlock)) {
                    this.finalizeINodeFileUnderConstruction(src, pendingFile);
                    NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: Committed blocks are minimally replicated, lease removed, file closed.");
                    return true;
                }
                String message = "DIR* NameSystem.internalReleaseLease: Failed to release lease for file " + src + ". Committed blocks are waiting to be minimally replicated." + " Try again later.";
                NameNode.stateChangeLog.warn((Object)message);
                throw new AlreadyBeingCreatedException(message);
            }
            case UNDER_CONSTRUCTION: 
            case UNDER_RECOVERY: {
                if (lastBlock.getNumExpectedLocations() == 0) {
                    lastBlock.setExpectedLocations(this.blockManager.getNodes(lastBlock));
                }
                long blockRecoveryId = this.nextGenerationStamp();
                lease = this.reassignLease(lease, src, recoveryLeaseHolder, pendingFile);
                lastBlock.initializeBlockRecovery(blockRecoveryId);
                this.leaseManager.renewLease(lease);
                NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.internalReleaseLease: File " + src + " has not been closed." + " Lease recovery is in progress. " + "RecoveryId = " + blockRecoveryId + " for block " + lastBlock));
            }
        }
        return false;
    }

    LeaseManager.Lease reassignLease(LeaseManager.Lease lease, String src, String newHolder, INodeFileUnderConstruction pendingFile) {
        if (newHolder == null) {
            return lease;
        }
        pendingFile.setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, src, newHolder);
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFileUnderConstruction pendingFile) throws IOException, UnresolvedLinkException {
        this.leaseManager.removeLease(pendingFile.getClientName(), src);
        INodeFile newFile = pendingFile.convertToInodeFile();
        this.dir.replaceNode(src, pendingFile, newFile);
        this.dir.closeFile(src, newFile);
        this.checkReplicationFactor(newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitBlockSynchronization(Block lastblock, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets) throws IOException, UnresolvedLinkException {
        String src = "";
        this.writeLock();
        try {
            LOG.info((Object)("commitBlockSynchronization(lastblock=" + lastblock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteblock + ")"));
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot commitBlockSynchronization " + lastblock, this.safeMode);
            }
            BlockInfo storedBlock = this.blockManager.getStoredBlock(lastblock);
            if (storedBlock == null) {
                throw new IOException("Block (=" + lastblock + ") not found");
            }
            INodeFile iFile = storedBlock.getINode();
            if (!iFile.isUnderConstruction() || storedBlock.isComplete()) {
                throw new IOException("Unexpected block (=" + lastblock + ") since the file (=" + iFile.getLocalName() + ") is not under construction");
            }
            long recoveryId = ((BlockInfoUnderConstruction)storedBlock).getBlockRecoveryId();
            if (recoveryId != newgenerationstamp) {
                throw new IOException("The recovery id " + newgenerationstamp + " does not match current recovery id " + recoveryId + " for block " + lastblock);
            }
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)iFile;
            if (deleteblock) {
                pendingFile.removeLastBlock(lastblock);
                this.blockManager.removeBlockFromMap(storedBlock);
            } else {
                int i;
                storedBlock.setGenerationStamp(newgenerationstamp);
                storedBlock.setNumBytes(newlength);
                DatanodeDescriptor[] descriptors = null;
                if (newtargets.length > 0) {
                    descriptors = new DatanodeDescriptor[newtargets.length];
                    for (i = 0; i < newtargets.length; ++i) {
                        descriptors[i] = this.getDatanode(newtargets[i]);
                    }
                }
                if (closeFile) {
                    for (i = 0; i < descriptors.length; ++i) {
                        descriptors[i].addBlock(storedBlock);
                    }
                }
                pendingFile.setLastBlock(storedBlock, descriptors);
            }
            src = this.leaseManager.findPath(pendingFile);
            if (!closeFile) {
                if (this.supportAppends) {
                    this.dir.persistBlocks(src, pendingFile);
                    this.getEditLog().logSync();
                }
                LOG.info((Object)("commitBlockSynchronization(" + lastblock + ") successful"));
                return;
            }
            this.blockManager.commitOrCompleteLastBlock(pendingFile, storedBlock);
            this.finalizeINodeFileUnderConstruction(src, pendingFile);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        LOG.info((Object)("commitBlockSynchronization(newblock=" + lastblock + ", file=" + src + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewLease(String holder) throws IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot renew lease for " + holder, this.safeMode);
            }
            this.leaseManager.renewLease(holder);
        }
        finally {
            this.writeUnlock();
        }
    }

    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, UnresolvedLinkException, IOException {
        if (this.isPermissionEnabled) {
            if (this.dir.isDir(src)) {
                this.checkPathAccess(src, FsAction.READ_EXECUTE);
            } else {
                this.checkTraverse(src);
            }
        }
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "listStatus", src, null, null);
        }
        return this.dir.getListing(src, startAfter, needLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.writeLock();
        try {
            String dnAddress = Server.getRemoteAddress();
            if (dnAddress == null) {
                dnAddress = nodeReg.getHost();
            }
            if (!this.verifyNodeRegistration(nodeReg, dnAddress)) {
                throw new DisallowedDatanodeException(nodeReg);
            }
            String hostName = nodeReg.getHost();
            DatanodeID dnReg = new DatanodeID(dnAddress + ":" + nodeReg.getPort(), nodeReg.getStorageID(), nodeReg.getInfoPort(), nodeReg.getIpcPort());
            nodeReg.updateRegInfo(dnReg);
            nodeReg.exportedKeys = this.getBlockKeys();
            NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.registerDatanode: node registration from " + nodeReg.getName() + " storage " + nodeReg.getStorageID()));
            DatanodeDescriptor nodeS = (DatanodeDescriptor)this.datanodeMap.get(nodeReg.getStorageID());
            DatanodeDescriptor nodeN = this.host2DataNodeMap.getDatanodeByName(nodeReg.getName());
            if (nodeN != null && nodeN != nodeS) {
                NameNode.LOG.info((Object)("BLOCK* NameSystem.registerDatanode: node from name: " + nodeN.getName()));
                this.removeDatanode(nodeN);
                this.wipeDatanode(nodeN);
                nodeN = null;
            }
            if (nodeS != null) {
                if (nodeN == nodeS) {
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug((Object)"BLOCK* NameSystem.registerDatanode: node restarted.");
                    }
                } else {
                    NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.registerDatanode: node " + nodeS.getName() + " is replaced by " + nodeReg.getName() + " with the same storageID " + nodeReg.getStorageID()));
                }
                this.clusterMap.remove((Node)nodeS);
                nodeS.updateRegInfo(nodeReg);
                nodeS.setHostName(hostName);
                this.resolveNetworkLocation(nodeS);
                this.clusterMap.add((Node)nodeS);
                ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
                synchronized (arrayList) {
                    if (!this.heartbeats.contains(nodeS)) {
                        this.heartbeats.add(nodeS);
                        nodeS.updateHeartbeat(0L, 0L, 0L, 0, 0);
                        nodeS.isAlive = true;
                    }
                }
                return;
            }
            if (nodeReg.getStorageID().equals("")) {
                nodeReg.storageID = this.newStorageID();
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.registerDatanode: new storageID " + nodeReg.getStorageID() + " assigned."));
                }
            }
            DatanodeDescriptor nodeDescr = new DatanodeDescriptor(nodeReg, "/default-rack", hostName);
            this.resolveNetworkLocation(nodeDescr);
            this.unprotectedAddDatanode(nodeDescr);
            this.clusterMap.add((Node)nodeDescr);
            ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
            synchronized (arrayList) {
                this.heartbeats.add(nodeDescr);
                nodeDescr.isAlive = true;
            }
            if (this.safeMode != null) {
                this.safeMode.checkMode();
            }
            return;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void resolveNetworkLocation(DatanodeDescriptor node) {
        String networkLocation;
        ArrayList<String> names = new ArrayList<String>(1);
        if (this.dnsToSwitchMapping instanceof CachedDNSToSwitchMapping) {
            names.add(node.getHost());
        } else {
            String hostName = node.getHostName();
            int colon = hostName.indexOf(":");
            hostName = colon == -1 ? hostName : hostName.substring(0, colon);
            names.add(hostName);
        }
        List rName = this.dnsToSwitchMapping.resolve(names);
        if (rName == null) {
            LOG.error((Object)("The resolve call returned null! Using /default-rack for host " + names));
            networkLocation = "/default-rack";
        } else {
            networkLocation = (String)rName.get(0);
        }
        node.setNetworkLocation(networkLocation);
    }

    public String getRegistrationID() {
        return Storage.getRegistrationID(this.dir.fsImage);
    }

    private String newStorageID() {
        String newID = null;
        while (newID == null) {
            newID = "DS" + Integer.toString(this.r.nextInt());
            if (this.datanodeMap.get(newID) == null) continue;
            newID = null;
        }
        return newID;
    }

    private boolean isDatanodeDead(DatanodeDescriptor node) {
        return node.getLastUpdate() < Util.now() - this.heartbeatExpireInterval;
    }

    private void setDatanodeDead(DatanodeDescriptor node) throws IOException {
        node.setLastUpdate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeCommand[] handleHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, int xceiverCount, int xmitsInProgress, int failedVolumes) throws IOException {
        DatanodeCommand cmd = null;
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
            synchronized (navigableMap) {
                DatanodeDescriptor nodeinfo = null;
                try {
                    nodeinfo = this.getDatanode(nodeReg);
                }
                catch (UnregisteredNodeException e) {
                    return new DatanodeCommand[]{DatanodeCommand.REGISTER};
                }
                if (nodeinfo != null && this.shouldNodeShutdown(nodeinfo)) {
                    this.setDatanodeDead(nodeinfo);
                    throw new DisallowedDatanodeException(nodeinfo);
                }
                if (nodeinfo == null || !nodeinfo.isAlive) {
                    return new DatanodeCommand[]{DatanodeCommand.REGISTER};
                }
                this.updateStats(nodeinfo, false);
                nodeinfo.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount, failedVolumes);
                this.updateStats(nodeinfo, true);
                cmd = nodeinfo.getLeaseRecoveryCommand(Integer.MAX_VALUE);
                if (cmd != null) {
                    return new DatanodeCommand[]{cmd};
                }
                ArrayList<DatanodeCommand> cmds = new ArrayList<DatanodeCommand>(3);
                cmd = nodeinfo.getReplicationCommand(this.blockManager.maxReplicationStreams - xmitsInProgress);
                if (cmd != null) {
                    cmds.add(cmd);
                }
                if ((cmd = nodeinfo.getInvalidateBlocks(this.blockInvalidateLimit)) != null) {
                    cmds.add(cmd);
                }
                if (this.isBlockTokenEnabled && nodeinfo.needKeyUpdate) {
                    cmds.add(new KeyUpdateCommand(this.blockTokenSecretManager.exportKeys()));
                    nodeinfo.needKeyUpdate = false;
                }
                if (!cmds.isEmpty()) {
                    return cmds.toArray(new DatanodeCommand[cmds.size()]);
                }
            }
        }
        cmd = this.getDistributedUpgradeCommand();
        if (cmd != null) {
            return new DatanodeCommand[]{cmd};
        }
        return null;
    }

    private void updateStats(DatanodeDescriptor node, boolean isAdded) {
        assert (Thread.holdsLock(this.heartbeats));
        if (isAdded) {
            this.capacityTotal += node.getCapacity();
            this.capacityUsed += node.getDfsUsed();
            this.capacityRemaining += node.getRemaining();
            this.totalLoad += node.getXceiverCount();
        } else {
            this.capacityTotal -= node.getCapacity();
            this.capacityUsed -= node.getDfsUsed();
            this.capacityRemaining -= node.getRemaining();
            this.totalLoad -= node.getXceiverCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBlockKey() throws IOException {
        this.blockTokenSecretManager.updateKeys();
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            for (DatanodeDescriptor nodeInfo : this.heartbeats) {
                nodeInfo.needKeyUpdate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeDatanodeWork() throws IOException {
        int workFound = 0;
        int blocksToProcess = 0;
        int nodesToProcess = 0;
        if (this.isInSafeMode()) {
            return workFound;
        }
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            blocksToProcess = (int)((float)this.heartbeats.size() * 2.0f);
            nodesToProcess = (int)Math.ceil((double)this.heartbeats.size() * 32.0 / 100.0);
        }
        workFound = this.blockManager.computeReplicationWork(blocksToProcess);
        this.writeLock();
        try {
            this.blockManager.updateState();
            this.blockManager.scheduledReplicationBlocksCount = workFound;
        }
        finally {
            this.writeUnlock();
        }
        return workFound += this.blockManager.computeInvalidateWork(nodesToProcess);
    }

    public void setNodeReplicationLimit(int limit) {
        this.blockManager.maxReplicationStreams = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatanode(DatanodeID nodeID) throws IOException {
        this.writeLock();
        try {
            DatanodeDescriptor nodeInfo = this.getDatanode(nodeID);
            if (nodeInfo != null) {
                this.removeDatanode(nodeInfo);
            } else {
                NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.removeDatanode: " + nodeID.getName() + " does not exist"));
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatanode(DatanodeDescriptor nodeInfo) {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (nodeInfo.isAlive) {
                this.updateStats(nodeInfo, false);
                this.heartbeats.remove(nodeInfo);
                nodeInfo.isAlive = false;
            }
        }
        Iterator<BlockInfo> it = nodeInfo.getBlockIterator();
        while (it.hasNext()) {
            this.blockManager.removeStoredBlock(it.next(), nodeInfo);
        }
        this.unprotectedRemoveDatanode(nodeInfo);
        this.clusterMap.remove((Node)nodeInfo);
        if (this.safeMode != null) {
            this.safeMode.checkMode();
        }
    }

    void unprotectedRemoveDatanode(DatanodeDescriptor nodeDescr) {
        nodeDescr.resetBlocks();
        this.blockManager.removeFromInvalidates(nodeDescr.getStorageID());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.unprotectedRemoveDatanode: " + nodeDescr.getName() + " is out of service now."));
        }
    }

    void unprotectedAddDatanode(DatanodeDescriptor nodeDescr) {
        this.host2DataNodeMap.remove(this.datanodeMap.put(nodeDescr.getStorageID(), nodeDescr));
        this.host2DataNodeMap.add(nodeDescr);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.unprotectedAddDatanode: node " + nodeDescr.getName() + " is added to datanodeMap."));
        }
    }

    void wipeDatanode(DatanodeID nodeID) throws IOException {
        String key = nodeID.getStorageID();
        this.host2DataNodeMap.remove((DatanodeDescriptor)this.datanodeMap.remove(key));
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.wipeDatanode: " + nodeID.getName() + " storage " + key + " is removed from datanodeMap."));
        }
    }

    FSImage getFSImage() {
        return this.dir.fsImage;
    }

    FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void heartbeatCheck() {
        boolean allAlive = false;
        while (!allAlive) {
            boolean foundDead = false;
            DatanodeDescriptor nodeID = null;
            ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
            synchronized (arrayList) {
                for (DatanodeDescriptor nodeInfo : this.heartbeats) {
                    if (!this.isDatanodeDead(nodeInfo)) continue;
                    this.myFSMetrics.numExpiredHeartbeats.inc();
                    foundDead = true;
                    nodeID = nodeInfo;
                    break;
                }
            }
            if (foundDead) {
                this.writeLock();
                try {
                    arrayList = this.heartbeats;
                    synchronized (arrayList) {
                        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
                        synchronized (navigableMap) {
                            DatanodeDescriptor nodeInfo;
                            nodeInfo = null;
                            try {
                                nodeInfo = this.getDatanode(nodeID);
                            }
                            catch (IOException e) {
                                nodeInfo = null;
                            }
                            if (nodeInfo != null && this.isDatanodeDead(nodeInfo)) {
                                NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.heartbeatCheck: lost heartbeat from " + nodeInfo.getName()));
                                this.removeDatanode(nodeInfo);
                            }
                        }
                    }
                }
                finally {
                    this.writeUnlock();
                }
            }
            allAlive = !foundDead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReport(DatanodeID nodeID, BlockListAsLongs newReport) throws IOException {
        this.writeLock();
        try {
            DatanodeDescriptor node;
            long startTime = Util.now();
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.processReport: from " + nodeID.getName() + " " + newReport.getNumberOfBlocks() + " blocks"));
            }
            if ((node = this.getDatanode(nodeID)) == null || !node.isAlive) {
                throw new IOException("ProcessReport from dead or unregisterted node: " + nodeID.getName());
            }
            if (this.shouldNodeShutdown(node)) {
                this.setDatanodeDead(node);
                throw new DisallowedDatanodeException(node);
            }
            this.blockManager.processReport(node, newReport);
            NameNode.getNameNodeMetrics().blockReport.inc((long)((int)(Util.now() - startTime)));
        }
        finally {
            this.writeUnlock();
        }
    }

    void chooseExcessReplicates(Collection<DatanodeDescriptor> nonExcess, Block b, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint, BlockPlacementPolicy replicator) {
        INodeFile inode = this.blockManager.getINode(b);
        HashMap<String, ArrayList<DatanodeDescriptor>> rackMap = new HashMap<String, ArrayList<DatanodeDescriptor>>();
        for (DatanodeDescriptor node : nonExcess) {
            String rackName = node.getNetworkLocation();
            ArrayList<DatanodeDescriptor> datanodeList = (ArrayList<DatanodeDescriptor>)rackMap.get(rackName);
            if (datanodeList == null) {
                datanodeList = new ArrayList<DatanodeDescriptor>();
            }
            datanodeList.add(node);
            rackMap.put(rackName, datanodeList);
        }
        ArrayList<DatanodeDescriptor> priSet = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> remains = new ArrayList<DatanodeDescriptor>();
        for (Map.Entry rackEntry : rackMap.entrySet()) {
            ArrayList datanodeList = (ArrayList)rackEntry.getValue();
            if (datanodeList.size() == 1) {
                remains.add((DatanodeDescriptor)datanodeList.get(0));
                continue;
            }
            priSet.addAll(datanodeList);
        }
        boolean firstOne = true;
        while (nonExcess.size() - replication > 0) {
            DatanodeDescriptor cur = null;
            cur = firstOne && delNodeHint != null && nonExcess.contains(delNodeHint) && (priSet.contains(delNodeHint) || addedNode != null && !priSet.contains(addedNode)) ? delNodeHint : replicator.chooseReplicaToDelete(inode, b, replication, priSet, remains);
            firstOne = false;
            String rack = cur.getNetworkLocation();
            ArrayList datanodes = (ArrayList)rackMap.get(rack);
            datanodes.remove(cur);
            if (datanodes.isEmpty()) {
                rackMap.remove(rack);
            }
            if (priSet.remove(cur)) {
                if (datanodes.size() == 1) {
                    priSet.remove(datanodes.get(0));
                    remains.add((DatanodeDescriptor)datanodes.get(0));
                }
            } else {
                remains.remove(cur);
            }
            nonExcess.remove(cur);
            this.blockManager.addToExcessReplicate(cur, b);
            this.blockManager.addToInvalidates(b, cur);
            NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.chooseExcessReplicates: (" + cur.getName() + ", " + b + ") is added to recentInvalidateSets"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockReceived(DatanodeID nodeID, Block block, String delHint) throws IOException {
        this.writeLock();
        try {
            DatanodeDescriptor node = this.getDatanode(nodeID);
            if (node == null || !node.isAlive) {
                NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.blockReceived: " + block + " is received from dead or unregistered node " + nodeID.getName()));
                throw new IOException("Got blockReceived message from unregistered or dead node " + block);
            }
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.blockReceived: " + block + " is received from " + nodeID.getName()));
            }
            if (this.shouldNodeShutdown(node)) {
                this.setDatanodeDead(node);
                throw new DisallowedDatanodeException(node);
            }
            this.blockManager.addBlock(node, block, delHint);
        }
        finally {
            this.writeUnlock();
        }
    }

    public long getMissingBlocksCount() {
        return this.blockManager.getMissingBlocksCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getStats() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return new long[]{this.capacityTotal, this.capacityUsed, this.capacityRemaining, this.getUnderReplicatedBlocks(), this.getCorruptReplicaBlocks(), this.getMissingBlocksCount()};
        }
    }

    @Override
    public long getCapacityTotal() {
        return this.getStats()[0];
    }

    @Override
    public long getCapacityUsed() {
        return this.getStats()[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCapacityUsedPercent() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (this.capacityTotal <= 0L) {
                return 100.0f;
            }
            return (float)this.capacityUsed * 100.0f / (float)this.capacityTotal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacityUsedNonDFS() {
        long nonDFSUsed = 0L;
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            nonDFSUsed = this.capacityTotal - this.capacityRemaining - this.capacityUsed;
        }
        return nonDFSUsed < 0L ? 0L : nonDFSUsed;
    }

    @Override
    public long getCapacityRemaining() {
        return this.getStats()[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCapacityRemainingPercent() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (this.capacityTotal <= 0L) {
                return 0.0f;
            }
            return (float)this.capacityRemaining * 100.0f / (float)this.capacityTotal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalLoad() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.totalLoad;
        }
    }

    int getNumberOfDatanodes(FSConstants.DatanodeReportType type) {
        return this.getDatanodeListForReport(type).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<DatanodeDescriptor> getDatanodeListForReport(FSConstants.DatanodeReportType type) {
        boolean listLiveNodes = type == FSConstants.DatanodeReportType.ALL || type == FSConstants.DatanodeReportType.LIVE;
        boolean listDeadNodes = type == FSConstants.DatanodeReportType.ALL || type == FSConstants.DatanodeReportType.DEAD;
        HashMap mustList = new HashMap();
        this.readLock();
        try {
            if (listDeadNodes) {
                Iterator it = this.hostsReader.getHosts().iterator();
                while (it.hasNext()) {
                    mustList.put(it.next(), "");
                }
                it = this.hostsReader.getExcludedHosts().iterator();
                while (it.hasNext()) {
                    mustList.put(it.next(), "");
                }
            }
            ArrayList<DatanodeDescriptor> nodes = null;
            Object object = this.datanodeMap;
            synchronized (object) {
                nodes = new ArrayList<DatanodeDescriptor>(this.datanodeMap.size() + mustList.size());
                for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                    boolean isDead = this.isDatanodeDead(dn);
                    if (isDead && listDeadNodes || !isDead && listLiveNodes) {
                        nodes.add(dn);
                    }
                    mustList.remove(dn.getName());
                    mustList.remove(dn.getHost());
                    mustList.remove(dn.getHostName());
                }
            }
            if (listDeadNodes) {
                Iterator it = mustList.keySet().iterator();
                while (it.hasNext()) {
                    DatanodeDescriptor dn = new DatanodeDescriptor(new DatanodeID((String)it.next()));
                    dn.setLastUpdate(0L);
                    nodes.add(dn);
                }
            }
            object = nodes;
            return object;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeInfo[] datanodeReport(FSConstants.DatanodeReportType type) throws AccessControlException {
        this.readLock();
        try {
            this.checkSuperuserPrivilege();
            ArrayList<DatanodeDescriptor> results = this.getDatanodeListForReport(type);
            DatanodeInfo[] arr = new DatanodeInfo[results.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new DatanodeInfo(results.get(i));
            }
            DatanodeInfo[] datanodeInfoArray = arr;
            return datanodeInfoArray;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNamespace() throws AccessControlException, IOException {
        this.writeLock();
        try {
            this.checkSuperuserPrivilege();
            if (!this.isInSafeMode()) {
                throw new IOException("Safe mode should be turned ON in order to create namespace image.");
            }
            this.getFSImage().saveNamespace(true);
            LOG.info((Object)"New namespace image has been created.");
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean restoreFailedStorage(String arg) throws AccessControlException {
        this.writeLock();
        try {
            this.checkSuperuserPrivilege();
            if (arg.equals("check")) {
                boolean bl = this.getFSImage().getRestoreFailedStorage();
                return bl;
            }
            boolean val = arg.equals("true");
            this.getFSImage().setRestoreFailedStorage(val);
            boolean bl = val;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DFSNodesStatus(ArrayList<DatanodeDescriptor> live, ArrayList<DatanodeDescriptor> dead) {
        this.readLock();
        try {
            ArrayList<DatanodeDescriptor> results = this.getDatanodeListForReport(FSConstants.DatanodeReportType.ALL);
            for (DatanodeDescriptor node : results) {
                if (this.isDatanodeDead(node)) {
                    dead.add(node);
                    continue;
                }
                live.add(node);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void datanodeDump(PrintWriter out) {
        this.readLock();
        try {
            NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
            synchronized (navigableMap) {
                out.println("Metasave: Number of datanodes: " + this.datanodeMap.size());
                for (DatanodeDescriptor node : this.datanodeMap.values()) {
                    out.println(node.dumpDatanode());
                }
            }
        }
        finally {
            this.readUnlock();
        }
    }

    private void startDecommission(DatanodeDescriptor node) throws IOException {
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            LOG.info((Object)("Start Decommissioning node " + node.getName()));
            node.startDecommission();
            node.decommissioningStatus.setStartTime(Util.now());
            this.checkDecommissionStateInternal(node);
        }
    }

    public void stopDecommission(DatanodeDescriptor node) throws IOException {
        LOG.info((Object)("Stop Decommissioning node " + node.getName()));
        node.stopDecommission();
    }

    public DatanodeInfo getDataNodeInfo(String name) {
        return (DatanodeInfo)this.datanodeMap.get(name);
    }

    public Date getStartTime() {
        return new Date(this.systemStart);
    }

    short getMaxReplication() {
        return (short)this.blockManager.maxReplication;
    }

    short getMinReplication() {
        return (short)this.blockManager.minReplication;
    }

    short getDefaultReplication() {
        return (short)this.blockManager.defaultReplication;
    }

    short adjustReplication(short replication) {
        short maxReplication;
        short minReplication = this.getMinReplication();
        if (replication < minReplication) {
            replication = minReplication;
        }
        if (replication > (maxReplication = this.getMaxReplication())) {
            replication = maxReplication;
        }
        return replication;
    }

    boolean checkDecommissionStateInternal(DatanodeDescriptor node) {
        if (node.isDecommissionInProgress() && !this.blockManager.isReplicationInProgress(node)) {
            node.setDecommissioned();
            LOG.info((Object)("Decommission complete for node " + node.getName()));
        }
        return node.isDecommissioned();
    }

    private boolean inHostsList(DatanodeID node, String ipAddr) {
        Set hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || ipAddr != null && hostsList.contains(ipAddr) || hostsList.contains(node.getHost()) || hostsList.contains(node.getName()) || node instanceof DatanodeInfo && hostsList.contains(((DatanodeInfo)node).getHostName());
    }

    private boolean inExcludedHostsList(DatanodeID node, String ipAddr) {
        Set excludeList = this.hostsReader.getExcludedHosts();
        return ipAddr != null && excludeList.contains(ipAddr) || excludeList.contains(node.getHost()) || excludeList.contains(node.getName()) || node instanceof DatanodeInfo && excludeList.contains(((DatanodeInfo)node).getHostName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNodes(Configuration conf) throws IOException {
        this.checkSuperuserPrivilege();
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        this.hostsReader.updateFileNames(conf.get("dfs.hosts", ""), conf.get("dfs.hosts.exclude", ""));
        this.hostsReader.refresh();
        this.writeLock();
        try {
            for (DatanodeDescriptor node : this.datanodeMap.values()) {
                if (!this.inHostsList(node, null)) {
                    node.setDecommissioned();
                    continue;
                }
                if (this.inExcludedHostsList(node, null)) {
                    if (node.isDecommissionInProgress() || node.isDecommissioned()) continue;
                    this.startDecommission(node);
                    continue;
                }
                if (!node.isDecommissionInProgress() && !node.isDecommissioned()) continue;
                this.stopDecommission(node);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    void finalizeUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.getFSImage().finalizeUpgrade();
    }

    private boolean verifyNodeRegistration(DatanodeID nodeReg, String ipAddr) throws IOException {
        assert (this.hasWriteLock());
        if (!this.inHostsList(nodeReg, ipAddr)) {
            return false;
        }
        if (this.inExcludedHostsList(nodeReg, ipAddr)) {
            DatanodeDescriptor node = this.getDatanode(nodeReg);
            if (node == null) {
                throw new IOException("verifyNodeRegistration: unknown datanode " + nodeReg.getName());
            }
            if (!this.checkDecommissionStateInternal(node)) {
                this.startDecommission(node);
            }
        }
        return true;
    }

    private boolean shouldNodeShutdown(DatanodeDescriptor node) {
        return node.isDecommissioned();
    }

    public DatanodeDescriptor getDatanode(DatanodeID nodeID) throws IOException {
        UnregisteredNodeException e = null;
        DatanodeDescriptor node = (DatanodeDescriptor)this.datanodeMap.get(nodeID.getStorageID());
        if (node == null) {
            return null;
        }
        if (!node.getName().equals(nodeID.getName())) {
            e = new UnregisteredNodeException(nodeID, node);
            NameNode.stateChangeLog.fatal((Object)("BLOCK* NameSystem.getDatanode: " + e.getLocalizedMessage()));
            throw e;
        }
        return node;
    }

    DatanodeDescriptor getRandomDatanode() {
        return (DatanodeDescriptor)this.clusterMap.chooseRandom("");
    }

    boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        if (action != FSConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode(false);
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode();
                }
            }
        }
        return this.isInSafeMode();
    }

    boolean isInSafeMode() {
        if (this.safeMode == null) {
            return false;
        }
        return this.safeMode.isOn();
    }

    void incrementSafeBlockCount(int replication) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.incrementSafeBlockCount((short)replication);
    }

    void decrementSafeBlockCount(Block b) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.decrementSafeBlockCount((short)this.blockManager.countNodes(b).liveReplicas());
    }

    void setBlockTotal() {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.setBlockTotal((int)this.getCompleteBlocksTotal());
    }

    @Override
    public long getBlocksTotal() {
        return this.blockManager.getTotalBlocks();
    }

    long getCompleteBlocksTotal() {
        long numUCBlocks = 0L;
        for (LeaseManager.Lease lease : this.leaseManager.getSortedLeases()) {
            for (String path : lease.getPaths()) {
                INodeFile node;
                try {
                    node = this.dir.getFileINode(path);
                }
                catch (UnresolvedLinkException e) {
                    throw new AssertionError((Object)"Lease files should reside on this FS");
                }
                assert (node != null) : "Found a lease for nonexisting file.";
                assert (node.isUnderConstruction()) : "Found a lease for file that is not under construction.";
                INodeFileUnderConstruction cons = (INodeFileUnderConstruction)node;
                BlockInfo[] blocks = cons.getBlocks();
                if (blocks == null) continue;
                for (BlockInfo b : blocks) {
                    if (b.isComplete()) continue;
                    ++numUCBlocks;
                }
            }
        }
        LOG.info((Object)("Number of blocks under construction: " + numUCBlocks));
        return this.getBlocksTotal() - numUCBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterSafeMode() throws IOException {
        this.writeLock();
        try {
            this.getEditLog().logSyncAll();
            if (!this.isInSafeMode()) {
                this.safeMode = new SafeModeInfo();
                return;
            }
            this.safeMode.setManual();
            this.getEditLog().logSyncAll();
            NameNode.stateChangeLog.info((Object)("STATE* Safe mode is ON. " + this.safeMode.getTurnOffTip()));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveSafeMode(boolean checkForUpgrades) throws SafeModeException {
        this.writeLock();
        try {
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is already OFF.");
                return;
            }
            if (this.getDistributedUpgradeState()) {
                throw new SafeModeException("Distributed upgrade is in progress", this.safeMode);
            }
            this.safeMode.leave(checkForUpgrades);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSafeModeTip() {
        this.readLock();
        try {
            if (!this.isInSafeMode()) {
                String string = "";
                return string;
            }
            String string = this.safeMode.getTurnOffTip();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    long getEditLogSize() throws IOException {
        return this.getEditLog().getEditLogSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CheckpointSignature rollEditLog() throws IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Checkpoint not created", this.safeMode);
            }
            LOG.info((Object)("Roll Edit Log from " + Server.getRemoteAddress()));
            CheckpointSignature checkpointSignature = this.getFSImage().rollEditLog();
            return checkpointSignature;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollFSImage(CheckpointSignature sig) throws IOException {
        this.writeLock();
        try {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Checkpoint not created", this.safeMode);
            }
            LOG.info((Object)("Roll FSImage from " + Server.getRemoteAddress()));
            this.getFSImage().rollFSImage(sig, true);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamenodeCommand startCheckpoint(NamenodeRegistration bnReg, NamenodeRegistration nnReg) throws IOException {
        this.writeLock();
        try {
            LOG.info((Object)("Start checkpoint for " + bnReg.getAddress()));
            NamenodeCommand cmd = this.getFSImage().startCheckpoint(bnReg, nnReg);
            this.getEditLog().logSync();
            NamenodeCommand namenodeCommand = cmd;
            return namenodeCommand;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.writeLock();
        try {
            LOG.info((Object)("End checkpoint for " + registration.getAddress()));
            this.getFSImage().endCheckpoint(sig, registration.getRole());
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean isValidBlock(Block b) {
        return this.blockManager.getINode(b) != null;
    }

    UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.upgradeManager.distributedUpgradeProgress(action);
    }

    UpgradeCommand processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.upgradeManager.processUpgradeCommand(comm);
    }

    int getDistributedUpgradeVersion() {
        return this.upgradeManager.getUpgradeVersion();
    }

    UpgradeCommand getDistributedUpgradeCommand() throws IOException {
        return this.upgradeManager.getBroadcastCommand();
    }

    boolean getDistributedUpgradeState() {
        return this.upgradeManager.getUpgradeState();
    }

    short getDistributedUpgradeStatus() {
        return this.upgradeManager.getUpgradeStatus();
    }

    boolean startDistributedUpgradeIfNeeded() throws IOException {
        return this.upgradeManager.startUpgrade();
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.supergroup, permission);
    }

    private FSPermissionChecker checkOwner(String path) throws AccessControlException, UnresolvedLinkException {
        return this.checkPermission(path, true, null, null, null, null);
    }

    private FSPermissionChecker checkPathAccess(String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        return this.checkPermission(path, false, null, null, access, null);
    }

    private FSPermissionChecker checkParentAccess(String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        return this.checkPermission(path, false, null, access, null, null);
    }

    private FSPermissionChecker checkAncestorAccess(String path, FsAction access) throws AccessControlException, UnresolvedLinkException {
        return this.checkPermission(path, false, access, null, null, null);
    }

    private FSPermissionChecker checkTraverse(String path) throws AccessControlException, UnresolvedLinkException {
        return this.checkPermission(path, false, null, null, null, null);
    }

    private void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker.checkSuperuserPrivilege(this.fsOwner, this.supergroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSPermissionChecker checkPermission(String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException, UnresolvedLinkException {
        FSPermissionChecker pc = new FSPermissionChecker(this.fsOwner.getShortUserName(), this.supergroup);
        if (!pc.isSuper) {
            this.dir.waitForReady();
            this.readLock();
            try {
                pc.checkPermission(path, this.dir.rootDir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess);
            }
            finally {
                this.readUnlock();
            }
        }
        return pc;
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    long getMaxObjects() {
        return this.maxFsObjects;
    }

    @Override
    public long getFilesTotal() {
        return this.dir.totalInodes();
    }

    @Override
    public long getPendingReplicationBlocks() {
        return this.blockManager.pendingReplicationBlocksCount;
    }

    @Override
    public long getUnderReplicatedBlocks() {
        return this.blockManager.underReplicatedBlocksCount;
    }

    public long getCorruptReplicaBlocks() {
        return this.blockManager.corruptReplicaBlocksCount;
    }

    @Override
    public long getScheduledReplicationBlocks() {
        return this.blockManager.scheduledReplicationBlocksCount;
    }

    public long getPendingDeletionBlocks() {
        return this.blockManager.pendingDeletionBlocksCount;
    }

    public long getExcessBlocks() {
        return this.blockManager.excessBlocksCount;
    }

    public int getBlockCapacity() {
        return this.blockManager.getCapacity();
    }

    @Override
    public String getFSState() {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    void registerMBean(Configuration conf) {
        try {
            this.myFSMetrics = new FSNamesystemMetrics(this, conf);
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeanUtil.registerMBean((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        LOG.info((Object)"Registered FSNamesystemStatusMBean");
    }

    public FSNamesystemMetrics getFSNamesystemMetrics() {
        return this.myFSMetrics;
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mbeanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumLiveDataNodes() {
        int numLive = 0;
        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
        synchronized (navigableMap) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                if (this.isDatanodeDead(dn)) continue;
                ++numLive;
            }
        }
        return numLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumDeadDataNodes() {
        int numDead = 0;
        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
        synchronized (navigableMap) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                if (!this.isDatanodeDead(dn)) continue;
                ++numDead;
            }
        }
        return numDead;
    }

    public void setGenerationStamp(long stamp) {
        this.generationStamp.setStamp(stamp);
    }

    public long getGenerationStamp() {
        return this.generationStamp.getStamp();
    }

    private long nextGenerationStamp() throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot get next generation stamp", this.safeMode);
        }
        long gs = this.generationStamp.nextStamp();
        this.getEditLog().logGenerationStamp(gs);
        return gs;
    }

    private INodeFileUnderConstruction checkUCBlock(Block block, String clientName) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot get a new generation stamp and an access token for block " + block, this.safeMode);
        }
        BlockInfo storedBlock = this.blockManager.getStoredBlock(block);
        if (storedBlock == null || storedBlock.getBlockUCState() != HdfsConstants.BlockUCState.UNDER_CONSTRUCTION) {
            throw new IOException(block + " does not exist or is not under Construction" + storedBlock);
        }
        INodeFile file = storedBlock.getINode();
        if (file == null || !file.isUnderConstruction()) {
            throw new IOException("The file " + storedBlock + " is belonged to does not exist or it is not under construction.");
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)file;
        if (clientName == null || !clientName.equals(pendingFile.getClientName())) {
            throw new LeaseExpiredException("Lease mismatch: " + block + " is accessed by a non lease holder " + clientName);
        }
        return pendingFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock updateBlockForPipeline(Block block, String clientName) throws IOException {
        LocatedBlock locatedBlock;
        this.writeLock();
        try {
            this.checkUCBlock(block, clientName);
            block.setGenerationStamp(this.nextGenerationStamp());
            locatedBlock = new LocatedBlock(block, new DatanodeInfo[0]);
            if (this.isBlockTokenEnabled) {
                locatedBlock.setBlockToken(this.blockTokenSecretManager.generateToken(block, EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
            }
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
        return locatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePipeline(String clientName, Block oldBlock, Block newBlock, DatanodeID[] newNodes) throws IOException {
        this.writeLock();
        try {
            assert (newBlock.getBlockId() == oldBlock.getBlockId()) : newBlock + " and " + oldBlock + " has different block identifier";
            LOG.info((Object)("updatePipeline(block=" + oldBlock + ", newGenerationStamp=" + newBlock.getGenerationStamp() + ", newLength=" + newBlock.getNumBytes() + ", newNodes=" + Arrays.asList(newNodes) + ", clientName=" + clientName + ")"));
            INodeFileUnderConstruction pendingFile = this.checkUCBlock(oldBlock, clientName);
            BlockInfoUnderConstruction blockinfo = (BlockInfoUnderConstruction)pendingFile.getLastBlock();
            if (newBlock.getGenerationStamp() <= blockinfo.getGenerationStamp() || newBlock.getNumBytes() < blockinfo.getNumBytes()) {
                String msg = "Update " + oldBlock + " (len = " + blockinfo.getNumBytes() + ") to an older state: " + newBlock + " (len = " + newBlock.getNumBytes() + ")";
                LOG.warn((Object)msg);
                throw new IOException(msg);
            }
            blockinfo.setGenerationStamp(newBlock.getGenerationStamp());
            blockinfo.setNumBytes(newBlock.getNumBytes());
            DatanodeDescriptor[] descriptors = null;
            if (newNodes.length > 0) {
                descriptors = new DatanodeDescriptor[newNodes.length];
                for (int i = 0; i < newNodes.length; ++i) {
                    descriptors[i] = this.getDatanode(newNodes[i]);
                }
            }
            blockinfo.setExpectedLocations(descriptors);
            String src = this.leaseManager.findPath(pendingFile);
            if (this.supportAppends) {
                this.dir.persistBlocks(src, pendingFile);
                this.getEditLog().logSync();
            }
            LOG.info((Object)("updatePipeline(" + oldBlock + ") successfully to " + newBlock));
            return;
        }
        finally {
            this.writeUnlock();
        }
    }

    void changeLease(String src, String dst, HdfsFileStatus dinfo) {
        String replaceBy;
        String overwrite;
        boolean destinationExisted = true;
        if (dinfo == null) {
            destinationExisted = false;
        }
        if (destinationExisted && dinfo.isDir()) {
            Path spath = new Path(src);
            overwrite = spath.getParent().toString() + "/";
            replaceBy = dst + "/";
        } else {
            overwrite = src;
            replaceBy = dst;
        }
        this.leaseManager.changeLease(src, dst, overwrite, replaceBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFilesUnderConstruction(DataOutputStream out) throws IOException {
        LeaseManager leaseManager = this.leaseManager;
        synchronized (leaseManager) {
            out.writeInt(this.leaseManager.countPath());
            for (LeaseManager.Lease lease : this.leaseManager.getSortedLeases()) {
                for (String path : lease.getPaths()) {
                    INodeFile node;
                    try {
                        node = this.dir.getFileINode(path);
                    }
                    catch (UnresolvedLinkException e) {
                        throw new AssertionError((Object)"Lease files should reside on this FS");
                    }
                    if (node == null) {
                        throw new IOException("saveLeases found path " + path + " but no matching entry in namespace.");
                    }
                    if (!node.isUnderConstruction()) {
                        throw new IOException("saveLeases found path " + path + " but is not under construction.");
                    }
                    INodeFileUnderConstruction cons = (INodeFileUnderConstruction)node;
                    FSImageSerialization.writeINodeUnderConstruction(out, cons, path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerBackupNode(NamenodeRegistration registration) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getNamespaceID() != registration.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getNamespaceID() + "; " + (Object)((Object)registration.getRole()) + " node namespaceID = " + registration.getNamespaceID());
            }
            boolean regAllowed = this.getEditLog().checkBackupRegistration(registration);
            if (!regAllowed) {
                throw new IOException("Registration is not allowed. Another node is registered as a backup.");
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseBackupNode(NamenodeRegistration registration) throws IOException {
        this.writeLock();
        try {
            if (this.getFSImage().getNamespaceID() != registration.getNamespaceID()) {
                throw new IOException("Incompatible namespaceIDs:  Namenode namespaceID = " + this.getFSImage().getNamespaceID() + "; " + (Object)((Object)registration.getRole()) + " node namespaceID = " + registration.getNamespaceID());
            }
            this.getEditLog().releaseBackupStream(registration);
        }
        finally {
            this.writeUnlock();
        }
    }

    public int numCorruptReplicas(Block blk) {
        return this.blockManager.numCorruptReplicas(blk);
    }

    DatanodeDescriptor getDatanode(String nodeID) {
        return (DatanodeDescriptor)this.datanodeMap.get(nodeID);
    }

    long[] getCorruptReplicaBlockIds(int numExpectedBlocks, Long startingBlockId) {
        return this.blockManager.getCorruptReplicaBlockIds(numExpectedBlocks, startingBlockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CorruptFileBlockInfo> listCorruptFileBlocks(String path, String startBlockAfter) throws AccessControlException, IOException {
        this.readLock();
        try {
            this.checkSuperuserPrivilege();
            long startBlockId = 0L;
            int count = 0;
            ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
            if (startBlockAfter != null) {
                startBlockId = Block.filename2id(startBlockAfter);
            }
            UnderReplicatedBlocks.BlockIterator blkIterator = this.blockManager.getCorruptReplicaBlockIterator();
            while (blkIterator.hasNext()) {
                Block blk = blkIterator.next();
                INodeFile inode = this.blockManager.getINode(blk);
                if (inode == null || this.blockManager.countNodes(blk).liveReplicas() != 0) continue;
                String src = FSDirectory.getFullPathName(inode);
                if (startBlockAfter != null && blk.getBlockId() <= startBlockId || !src.startsWith(path)) continue;
                corruptFiles.add(new CorruptFileBlockInfo(src, blk));
                if (++count < 100) continue;
                break;
            }
            LOG.info((Object)("list corrupt file blocks returned: " + count));
            ArrayList<CorruptFileBlockInfo> arrayList = corruptFiles;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DatanodeDescriptor> getDecommissioningNodes() {
        this.readLock();
        try {
            ArrayList<DatanodeDescriptor> decommissioningNodes = new ArrayList<DatanodeDescriptor>();
            ArrayList<DatanodeDescriptor> results = this.getDatanodeListForReport(FSConstants.DatanodeReportType.LIVE);
            for (DatanodeDescriptor node : results) {
                if (!node.isDecommissionInProgress()) continue;
                decommissioningNodes.add(node);
            }
            ArrayList<DatanodeDescriptor> arrayList = decommissioningNodes;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, this);
    }

    public DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot issue delegation token", this.safeMode);
        }
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
        }
        if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
            LOG.warn((Object)"trying to get DT with no secret manager running");
            return null;
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String user = ugi.getUserName();
        Text owner = new Text(user);
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)this.dtSecretManager);
        long expiryTime = this.dtSecretManager.getTokenExpiryTime(dtId);
        this.logGetDelegationToken(dtId, expiryTime);
        return token;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot renew delegation token", this.safeMode);
        }
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
        }
        String renewer = UserGroupInformation.getCurrentUser().getShortUserName();
        long expiryTime = this.dtSecretManager.renewToken(token, renewer);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        id.readFields(in);
        this.logRenewDelegationToken(id, expiryTime);
        return expiryTime;
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot cancel delegation token", this.safeMode);
        }
        String canceller = UserGroupInformation.getCurrentUser().getUserName();
        DelegationTokenIdentifier id = (DelegationTokenIdentifier)this.dtSecretManager.cancelToken(token, canceller);
        this.logCancelDelegationToken(id);
    }

    void saveSecretManagerState(DataOutputStream out) throws IOException {
        this.dtSecretManager.saveSecretManagerState(out);
    }

    void loadSecretManagerState(DataInputStream in) throws IOException {
        this.dtSecretManager.loadSecretManagerState(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logGetDelegationToken(DelegationTokenIdentifier id, long expiryTime) throws IOException {
        this.writeLock();
        try {
            this.getEditLog().logGetDelegationToken(id, expiryTime);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRenewDelegationToken(DelegationTokenIdentifier id, long expiryTime) throws IOException {
        this.writeLock();
        try {
            this.getEditLog().logRenewDelegationToken(id, expiryTime);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCancelDelegationToken(DelegationTokenIdentifier id) throws IOException {
        this.writeLock();
        try {
            this.getEditLog().logCancelDelegationToken(id);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUpdateMasterKey(DelegationKey key) throws IOException {
        this.writeLock();
        try {
            this.getEditLog().logUpdateMasterKey(key);
        }
        finally {
            this.writeUnlock();
        }
        this.getEditLog().logSync();
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private boolean isExternalInvocation() {
        return Server.getRemoteIp() != null;
    }

    void logFsckEvent(String src, InetAddress remoteAddress) throws IOException {
        if (auditLog.isInfoEnabled()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    private void registerMXBean() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mxbeanName = new ObjectName("HadoopInfo:type=NameNodeInfo");
            mbs.registerMBean(this, mxbeanName);
        }
        catch (InstanceAlreadyExistsException iaee) {
            LOG.info((Object)"NameNode MXBean already registered");
        }
        catch (JMException e) {
            LOG.warn((Object)"Failed to register NameNodeMXBean", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public String getSafemode() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON." + this.getSafeModeTip();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.getFSImage().isUpgradeFinalized();
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.getCapacityUsedPercent();
    }

    @Override
    public float getPercentRemaining() {
        return this.getCapacityRemainingPercent();
    }

    @Override
    public long getTotalBlocks() {
        return this.getBlocksTotal();
    }

    @Override
    public long getTotalFiles() {
        return this.getFilesTotal();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> aliveNodeList = this.getDatanodeListForReport(FSConstants.DatanodeReportType.LIVE);
        for (DatanodeDescriptor node : aliveNodeList) {
            HashMap<String, Long> innerinfo = new HashMap<String, Long>();
            innerinfo.put("lastContact", this.getLastContact(node));
            innerinfo.put("usedSpace", this.getDfsUsed(node));
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> deadNodeList = this.getDatanodeListForReport(FSConstants.DatanodeReportType.DEAD);
        for (DatanodeDescriptor node : deadNodeList) {
            HashMap<String, Long> innerinfo = new HashMap<String, Long>();
            innerinfo.put("lastContact", this.getLastContact(node));
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> decomNodeList = this.getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            HashMap<String, Integer> innerinfo = new HashMap<String, Integer>();
            innerinfo.put("underReplicatedBlocks", node.decommissioningStatus.getUnderReplicatedBlocks());
            innerinfo.put("decommissionOnlyReplicas", node.decommissioningStatus.getDecommissionOnlyReplicas());
            innerinfo.put("underReplicateInOpenFiles", node.decommissioningStatus.getUnderReplicatedInOpenFiles());
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    private long getLastContact(DatanodeDescriptor alivenode) {
        return (System.currentTimeMillis() - alivenode.getLastUpdate()) / 1000L;
    }

    private long getDfsUsed(DatanodeDescriptor alivenode) {
        return alivenode.getDfsUsed();
    }

    static class CorruptFileBlockInfo {
        String path;
        Block block;

        public CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && FSNamesystem.this.safeMode != null && !FSNamesystem.this.safeMode.canLeave()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            if (!FSNamesystem.this.fsRunning) {
                LOG.info((Object)"NameNode is being shutdown, exit SafeModeMonitor thread. ");
            } else {
                try {
                    FSNamesystem.this.leaveSafeMode(true);
                }
                catch (SafeModeException es) {
                    String msg = "SafeModeMonitor may not run during distributed upgrade.";
                    assert (false) : msg;
                    throw new RuntimeException(msg, es);
                }
            }
            FSNamesystem.this.smmthread = null;
        }
    }

    class SafeModeInfo {
        private double threshold;
        private int datanodeThreshold;
        private int extension;
        private int safeReplication;
        private long reached = -1L;
        int blockTotal;
        private int blockSafe;
        private int blockThreshold;
        private long lastStatusReport = 0L;

        SafeModeInfo(Configuration conf) {
            this.threshold = conf.getFloat("dfs.namenode.safemode.threshold-pct", 0.999f);
            if (this.threshold > 1.0) {
                LOG.warn((Object)("The threshold value should't be greater than 1, threshold: " + this.threshold));
            }
            this.datanodeThreshold = conf.getInt("dfs.namenode.safemode.min.datanodes", 0);
            this.extension = conf.getInt("dfs.namenode.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.namenode.replication.min", 1);
            this.blockTotal = 0;
            this.blockSafe = 0;
        }

        private SafeModeInfo() {
            this.threshold = 1.5;
            this.datanodeThreshold = Integer.MAX_VALUE;
            this.extension = Integer.MAX_VALUE;
            this.safeReplication = 32768;
            this.blockTotal = -1;
            this.blockSafe = -1;
            this.reached = -1L;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        synchronized boolean isOn() {
            try {
                assert (this.isConsistent()) : " SafeMode: Inconsistent filesystem state: Total num of blocks, active blocks, or total safe blocks don't match.";
            }
            catch (IOException e) {
                System.err.print(StringUtils.stringifyException((Throwable)e));
            }
            return this.reached >= 0L;
        }

        void enter() {
            this.reached = 0L;
        }

        synchronized void leave(boolean checkForUpgrades) {
            if (checkForUpgrades) {
                boolean needUpgrade = false;
                try {
                    needUpgrade = FSNamesystem.this.startDistributedUpgradeIfNeeded();
                }
                catch (IOException e) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                }
                if (needUpgrade) {
                    FSNamesystem.this.safeMode = new SafeModeInfo();
                    return;
                }
            }
            FSNamesystem.this.blockManager.processMisReplicatedBlocks();
            long timeInSafemode = Util.now() - FSNamesystem.this.systemStart;
            NameNode.stateChangeLog.info((Object)("STATE* Leaving safe mode after " + timeInSafemode / 1000L + " secs."));
            NameNode.getNameNodeMetrics().safeModeTime.set((int)timeInSafemode);
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is OFF.");
            }
            this.reached = -1L;
            FSNamesystem.this.safeMode = null;
            NameNode.stateChangeLog.info((Object)("STATE* Network topology has " + FSNamesystem.this.clusterMap.getNumOfRacks() + " racks and " + FSNamesystem.this.clusterMap.getNumOfLeaves() + " datanodes"));
            NameNode.stateChangeLog.info((Object)("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.blockManager.neededReplications.size() + " blocks"));
        }

        synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (Util.now() - this.reached < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return false;
            }
            return !this.needEnter();
        }

        boolean needEnter() {
            return this.threshold != 0.0 && this.blockSafe < this.blockThreshold || FSNamesystem.this.getNumLiveDataNodes() < this.datanodeThreshold;
        }

        private void checkMode() {
            if (this.needEnter()) {
                this.enter();
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave(true);
                return;
            }
            if (this.reached > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            this.reached = Util.now();
            FSNamesystem.this.smmthread = new Daemon((Runnable)new SafeModeMonitor());
            FSNamesystem.this.smmthread.start();
            this.reportStatus("STATE* Safe mode extension entered.", true);
        }

        synchronized void setBlockTotal(int total) {
            this.blockTotal = total;
            this.blockThreshold = (int)((double)this.blockTotal * this.threshold);
            this.checkMode();
        }

        synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
            }
            this.checkMode();
        }

        synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
            }
            this.checkMode();
        }

        boolean isManual() {
            return this.extension == Integer.MAX_VALUE;
        }

        synchronized void setManual() {
            this.extension = Integer.MAX_VALUE;
        }

        String getTurnOffTip() {
            if (this.reached < 0L) {
                return "Safe mode is OFF.";
            }
            String leaveMsg = "Safe mode will be turned off automatically";
            if (this.isManual()) {
                if (FSNamesystem.this.getDistributedUpgradeState()) {
                    return leaveMsg + " upon completion of " + "the distributed upgrade: upgrade progress = " + FSNamesystem.this.getDistributedUpgradeStatus() + "%";
                }
                leaveMsg = "Use \"hdfs dfsadmin -safemode leave\" to turn safe mode off";
            }
            if (this.blockTotal < 0) {
                return leaveMsg + ".";
            }
            int numLive = FSNamesystem.this.getNumLiveDataNodes();
            String msg = "";
            if (this.reached == 0L) {
                if (this.blockSafe < this.blockThreshold) {
                    msg = msg + String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.", this.blockSafe, this.blockThreshold - this.blockSafe + 1, this.threshold, this.blockTotal);
                }
                if (numLive < this.datanodeThreshold) {
                    if (!"".equals(msg)) {
                        msg = msg + "\n";
                    }
                    msg = msg + String.format("The number of live datanodes %d needs an additional %d live datanodes to reach the minimum number %d.", numLive, this.datanodeThreshold - numLive + 1, this.datanodeThreshold);
                }
                msg = msg + " " + leaveMsg;
            } else {
                msg = String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d.", this.blockSafe, this.threshold, this.blockTotal);
                if (this.datanodeThreshold > 0) {
                    msg = msg + String.format(" The number of live datanodes %d has reached the minimum number %d.", numLive, this.datanodeThreshold);
                }
                msg = msg + " " + leaveMsg;
            }
            if (this.reached == 0L || this.isManual()) {
                return msg + ".";
            }
            return msg + " in " + Math.abs(this.reached + (long)this.extension - Util.now()) / 1000L + " seconds.";
        }

        private void reportStatus(String msg, boolean rightNow) {
            long curTime = Util.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.info((Object)(msg + " \n" + this.getTurnOffTip()));
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String resText = "Current safe blocks = " + this.blockSafe + ". Target blocks = " + this.blockThreshold + " for threshold = %" + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reached) + ".";
            }
            return resText;
        }

        boolean isConsistent() throws IOException {
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return true;
            }
            int activeBlocks = FSNamesystem.this.blockManager.getActiveBlockCount();
            return this.blockTotal == activeBlocks || this.blockSafe >= 0 && this.blockSafe <= this.blockTotal;
        }
    }

    static class NumberReplicas {
        private int liveReplicas;
        int decommissionedReplicas;
        private int corruptReplicas;
        private int excessReplicas;

        NumberReplicas() {
            this.initialize(0, 0, 0, 0);
        }

        NumberReplicas(int live, int decommissioned, int corrupt, int excess) {
            this.initialize(live, decommissioned, corrupt, excess);
        }

        void initialize(int live, int decommissioned, int corrupt, int excess) {
            this.liveReplicas = live;
            this.decommissionedReplicas = decommissioned;
            this.corruptReplicas = corrupt;
            this.excessReplicas = excess;
        }

        int liveReplicas() {
            return this.liveReplicas;
        }

        int decommissionedReplicas() {
            return this.decommissionedReplicas;
        }

        int corruptReplicas() {
            return this.corruptReplicas;
        }

        int excessReplicas() {
            return this.excessReplicas;
        }
    }

    class ReplicationMonitor
    implements Runnable {
        static final int INVALIDATE_WORK_PCT_PER_ITERATION = 32;
        static final float REPLICATION_WORK_MULTIPLIER_PER_ITERATION = 2.0f;

        ReplicationMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    FSNamesystem.this.computeDatanodeWork();
                    FSNamesystem.this.blockManager.processPendingReplications();
                    Thread.sleep(FSNamesystem.this.replicationRecheckInterval);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("ReplicationMonitor thread received InterruptedException." + ie));
                    break;
                }
                catch (IOException ie) {
                    LOG.warn((Object)("ReplicationMonitor thread received exception. " + ie));
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ReplicationMonitor thread received Runtime exception. " + t));
                    Runtime.getRuntime().exit(-1);
                }
            }
        }
    }

    class HeartbeatMonitor
    implements Runnable {
        private long lastHeartbeatCheck;
        private long lastBlockKeyUpdate;

        HeartbeatMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    long now = Util.now();
                    if (this.lastHeartbeatCheck + FSNamesystem.this.heartbeatRecheckInterval < now) {
                        FSNamesystem.this.heartbeatCheck();
                        this.lastHeartbeatCheck = now;
                    }
                    if (FSNamesystem.this.isBlockTokenEnabled && this.lastBlockKeyUpdate + FSNamesystem.this.blockKeyUpdateInterval < now) {
                        FSNamesystem.this.updateBlockKey();
                        this.lastBlockKeyUpdate = now;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

