/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImageSerialization {
    private static final ThreadLocal<TLData> TL_DATA = new ThreadLocal<TLData>(){

        @Override
        protected TLData initialValue() {
            return new TLData();
        }
    };

    private FSImageSerialization() {
    }

    static INodeFileUnderConstruction readINodeUnderConstruction(DataInputStream in) throws IOException {
        int i;
        byte[] name = FSImageSerialization.readBytes(in);
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlockInfo[] blocks = new BlockInfo[numBlocks];
        Block blk = new Block();
        for (i = 0; i < numBlocks - 1; ++i) {
            blk.readFields(in);
            blocks[i] = new BlockInfo(blk, blockReplication);
        }
        if (numBlocks > 0) {
            blk.readFields(in);
            blocks[i] = new BlockInfoUnderConstruction(blk, blockReplication, HdfsConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        }
        PermissionStatus perm = PermissionStatus.read((DataInput)in);
        String clientName = FSImageSerialization.readString(in);
        String clientMachine = FSImageSerialization.readString(in);
        int numLocs = in.readInt();
        DatanodeDescriptor[] locations = new DatanodeDescriptor[numLocs];
        for (i = 0; i < numLocs; ++i) {
            locations[i] = new DatanodeDescriptor();
            locations[i].readFields(in);
        }
        return new INodeFileUnderConstruction(name, blockReplication, modificationTime, preferredBlockSize, blocks, perm, clientName, clientMachine, null);
    }

    static void writeINodeUnderConstruction(DataOutputStream out, INodeFileUnderConstruction cons, String path) throws IOException {
        FSImageSerialization.writeString(path, out);
        out.writeShort(cons.getReplication());
        out.writeLong(cons.getModificationTime());
        out.writeLong(cons.getPreferredBlockSize());
        int nrBlocks = cons.getBlocks().length;
        out.writeInt(nrBlocks);
        for (int i = 0; i < nrBlocks; ++i) {
            cons.getBlocks()[i].write(out);
        }
        cons.getPermissionStatus().write((DataOutput)out);
        FSImageSerialization.writeString(cons.getClientName(), out);
        FSImageSerialization.writeString(cons.getClientMachine(), out);
        out.writeInt(0);
    }

    static void saveINode2Image(ByteBuffer name, INode node, DataOutputStream out) throws IOException {
        int nameLen = name.position();
        out.writeShort(nameLen);
        out.write(name.array(), name.arrayOffset(), nameLen);
        FsPermission filePerm = FSImageSerialization.TL_DATA.get().FILE_PERM;
        if (node.isDirectory()) {
            out.writeShort(0);
            out.writeLong(node.getModificationTime());
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeInt(-1);
            out.writeLong(node.getNsQuota());
            out.writeLong(node.getDsQuota());
            filePerm.fromShort(node.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)node.getUserName(), (String)node.getGroupName(), (FsPermission)filePerm);
        } else if (node.isLink()) {
            out.writeShort(0);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeInt(-2);
            Text.writeString((DataOutput)out, (String)((INodeSymlink)node).getLinkValue());
            filePerm.fromShort(node.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)node.getUserName(), (String)node.getGroupName(), (FsPermission)filePerm);
        } else {
            INodeFile fileINode = (INodeFile)node;
            out.writeShort(fileINode.getReplication());
            out.writeLong(fileINode.getModificationTime());
            out.writeLong(fileINode.getAccessTime());
            out.writeLong(fileINode.getPreferredBlockSize());
            BlockInfo[] blocks = fileINode.getBlocks();
            out.writeInt(blocks.length);
            for (BlockInfo blk : blocks) {
                blk.write(out);
            }
            filePerm.fromShort(fileINode.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)fileINode.getUserName(), (String)fileINode.getGroupName(), (FsPermission)filePerm);
        }
    }

    public static String readString(DataInputStream in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return ustr.toString();
    }

    static String readString_EmptyAsNull(DataInputStream in) throws IOException {
        String s = FSImageSerialization.readString(in);
        return s.isEmpty() ? null : s;
    }

    static void writeString(String str, DataOutputStream out) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.set(str);
        ustr.write(out);
    }

    public static byte[] readBytes(DataInputStream in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        int len = ustr.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(ustr.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    public static byte[][] readPathComponents(DataInputStream in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return DFSUtil.bytes2byteArray(ustr.getBytes(), ustr.getLength(), (byte)47);
    }

    static class DatanodeImage
    implements Writable {
        DatanodeDescriptor node = new DatanodeDescriptor();

        DatanodeImage() {
        }

        static void skipOne(DataInput in) throws IOException {
            DatanodeImage nodeImage = new DatanodeImage();
            nodeImage.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            new DatanodeID(this.node).write(out);
            out.writeLong(this.node.getCapacity());
            out.writeLong(this.node.getRemaining());
            out.writeLong(this.node.getLastUpdate());
            out.writeInt(this.node.getXceiverCount());
        }

        public void readFields(DataInput in) throws IOException {
            DatanodeID id = new DatanodeID();
            id.readFields(in);
            long capacity = in.readLong();
            long remaining = in.readLong();
            long lastUpdate = in.readLong();
            int xceiverCount = in.readInt();
            this.node.updateRegInfo(id);
            this.node.setStorageID(id.getStorageID());
            this.node.setCapacity(capacity);
            this.node.setRemaining(remaining);
            this.node.setLastUpdate(lastUpdate);
            this.node.setXceiverCount(xceiverCount);
        }
    }

    private static final class TLData {
        final DeprecatedUTF8 U_STR = new DeprecatedUTF8();
        final FsPermission FILE_PERM = new FsPermission(0);

        private TLData() {
        }
    }
}

