/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.security.token.delegation.DelegationKey;

public class FSEditLogLoader {
    private final FSNamesystem fsNamesys;
    private static final LongWritable longWritable = new LongWritable();

    public FSEditLogLoader(FSNamesystem fsNamesys) {
        this.fsNamesys = fsNamesys;
    }

    int loadFSEdits(EditLogInputStream edits) throws IOException {
        DataInputStream in = edits.getDataInputStream();
        long startTime = Util.now();
        int numEdits = this.loadFSEdits(in, true);
        FSImage.LOG.info((Object)("Edits file " + edits.getName() + " of size " + edits.length() + " edits # " + numEdits + " loaded in " + (Util.now() - startTime) / 1000L + " seconds."));
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int loadFSEdits(DataInputStream in, boolean closeOnExit) throws IOException {
        int numEdits = 0;
        int logVersion = 0;
        try {
            in.mark(4);
            boolean available = true;
            try {
                logVersion = in.readByte();
            }
            catch (EOFException e) {
                available = false;
            }
            if (available) {
                in.reset();
                logVersion = in.readInt();
                if (logVersion < FSConstants.LAYOUT_VERSION) {
                    throw new IOException("Unexpected version of the file system log file: " + logVersion + ". Current version = " + FSConstants.LAYOUT_VERSION + ".");
                }
            }
            assert (logVersion <= -7) : "Unsupported version " + logVersion;
            numEdits = this.loadEditRecords(logVersion, in, false);
        }
        finally {
            if (closeOnExit) {
                in.close();
            }
        }
        if (logVersion != FSConstants.LAYOUT_VERSION) {
            ++numEdits;
        }
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int loadEditRecords(int logVersion, DataInputStream in, boolean closeOnExit) throws IOException {
        int numOpOther;
        int numOpUpdateMasterKey;
        int numOpCancelDelegationToken;
        int numOpRenewDelegationToken;
        int numOpGetDelegationToken;
        int numOpConcatDelete;
        int numOpRename;
        int numOpTimes;
        int numOpSetGenStamp;
        int numOpSetOwner;
        int numOpSetPerm;
        int numOpMkDir;
        int numOpSetRepl;
        int numOpRenameOld;
        int numOpDelete;
        int numOpClose;
        int numOpAdd;
        int numEdits;
        block55: {
            FSDirectory fsDir = this.fsNamesys.dir;
            numEdits = 0;
            String clientName = null;
            String clientMachine = null;
            String path = null;
            numOpAdd = 0;
            numOpClose = 0;
            numOpDelete = 0;
            numOpRenameOld = 0;
            numOpSetRepl = 0;
            numOpMkDir = 0;
            numOpSetPerm = 0;
            numOpSetOwner = 0;
            numOpSetGenStamp = 0;
            numOpTimes = 0;
            numOpRename = 0;
            numOpConcatDelete = 0;
            int numOpSymlink = 0;
            numOpGetDelegationToken = 0;
            numOpRenewDelegationToken = 0;
            numOpCancelDelegationToken = 0;
            numOpUpdateMasterKey = 0;
            numOpOther = 0;
            try {
                int opcode;
                block30: while (true) {
                    long timestamp = 0L;
                    long mtime = 0L;
                    long atime = 0L;
                    long blockSize = 0L;
                    opcode = -1;
                    try {
                        in.mark(1);
                        opcode = in.readByte();
                        if (opcode == -1) {
                            in.reset();
                        }
                    }
                    catch (EOFException e) {}
                    break block55;
                    ++numEdits;
                    switch (opcode) {
                        case 0: 
                        case 9: {
                            int length = in.readInt();
                            if (-7 == logVersion && length != 3 || -17 < logVersion && logVersion < -7 && length != 4 || logVersion <= -17 && length != 5) {
                                throw new IOException("Incorrect data format. logVersion is " + logVersion + " but writables.length is " + length + ". ");
                            }
                            path = FSImageSerialization.readString(in);
                            short replication = this.fsNamesys.adjustReplication(FSEditLogLoader.readShort(in));
                            mtime = FSEditLogLoader.readLong(in);
                            if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, logVersion)) {
                                atime = FSEditLogLoader.readLong(in);
                            }
                            if (logVersion < -7) {
                                blockSize = FSEditLogLoader.readLong(in);
                            }
                            boolean isFileUnderConstruction = opcode == 0;
                            BlockInfo[] blocks = FSEditLogLoader.readBlocks(in, logVersion, isFileUnderConstruction, replication);
                            if (-8 <= logVersion && blockSize == 0L) {
                                if (blocks.length > 1) {
                                    blockSize = blocks[0].getNumBytes();
                                } else {
                                    long first = blocks.length == 1 ? blocks[0].getNumBytes() : 0L;
                                    blockSize = Math.max(this.fsNamesys.getDefaultBlockSize(), first);
                                }
                            }
                            PermissionStatus permissions = this.fsNamesys.getUpgradePermission();
                            if (logVersion <= -11) {
                                permissions = PermissionStatus.read((DataInput)in);
                            }
                            if (opcode == 0 && logVersion <= -12) {
                                clientName = FSImageSerialization.readString(in);
                                clientMachine = FSImageSerialization.readString(in);
                                if (-13 <= logVersion) {
                                    FSEditLogLoader.readDatanodeDescriptorArray(in);
                                }
                            } else {
                                clientName = "";
                                clientMachine = "";
                            }
                            if (FSNamesystem.LOG.isDebugEnabled()) {
                                FSNamesystem.LOG.debug((Object)(opcode + ": " + path + " numblocks : " + blocks.length + " clientHolder " + clientName + " clientMachine " + clientMachine));
                            }
                            fsDir.unprotectedDelete(path, mtime);
                            INodeFile node = (INodeFile)fsDir.unprotectedAddFile(path, permissions, blocks, replication, mtime, atime, blockSize);
                            if (!isFileUnderConstruction) continue block30;
                            ++numOpAdd;
                            INodeFileUnderConstruction cons = new INodeFileUnderConstruction(node.getLocalNameBytes(), node.getReplication(), node.getModificationTime(), node.getPreferredBlockSize(), node.getBlocks(), node.getPermissionStatus(), clientName, clientMachine, null);
                            fsDir.replaceNode(path, node, cons);
                            this.fsNamesys.leaseManager.addLease(cons.getClientName(), path);
                            continue block30;
                        }
                        case 4: {
                            ++numOpSetRepl;
                            path = FSImageSerialization.readString(in);
                            short replication = this.fsNamesys.adjustReplication(FSEditLogLoader.readShort(in));
                            fsDir.unprotectedSetReplication(path, replication, null);
                            continue block30;
                        }
                        case 16: {
                            ++numOpConcatDelete;
                            int length = in.readInt();
                            if (length < 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            String trg = FSImageSerialization.readString(in);
                            int srcSize = length - 1 - 1;
                            String[] srcs = new String[srcSize];
                            for (int i = 0; i < srcSize; ++i) {
                                srcs[i] = FSImageSerialization.readString(in);
                            }
                            timestamp = FSEditLogLoader.readLong(in);
                            fsDir.unprotectedConcat(trg, srcs);
                            continue block30;
                        }
                        case 1: {
                            ++numOpRenameOld;
                            int length = in.readInt();
                            if (length != 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            String s = FSImageSerialization.readString(in);
                            String d = FSImageSerialization.readString(in);
                            timestamp = FSEditLogLoader.readLong(in);
                            HdfsFileStatus dinfo = fsDir.getFileInfo(d, false);
                            fsDir.unprotectedRenameTo(s, d, timestamp);
                            this.fsNamesys.changeLease(s, d, dinfo);
                            continue block30;
                        }
                        case 2: {
                            ++numOpDelete;
                            int length = in.readInt();
                            if (length != 2) {
                                throw new IOException("Incorrect data format. delete operation.");
                            }
                            path = FSImageSerialization.readString(in);
                            timestamp = FSEditLogLoader.readLong(in);
                            fsDir.unprotectedDelete(path, timestamp);
                            continue block30;
                        }
                        case 3: {
                            ++numOpMkDir;
                            PermissionStatus permissions = this.fsNamesys.getUpgradePermission();
                            int length = in.readInt();
                            if (-17 < logVersion && length != 2 || logVersion <= -17 && length != 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            path = FSImageSerialization.readString(in);
                            timestamp = FSEditLogLoader.readLong(in);
                            if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, logVersion)) {
                                atime = FSEditLogLoader.readLong(in);
                            }
                            if (logVersion <= -11) {
                                permissions = PermissionStatus.read((DataInput)in);
                            }
                            fsDir.unprotectedMkdir(path, permissions, timestamp);
                            continue block30;
                        }
                        case 10: {
                            ++numOpSetGenStamp;
                            long lw = in.readLong();
                            this.fsNamesys.setGenerationStamp(lw);
                            continue block30;
                        }
                        case 5: {
                            ++numOpOther;
                            FSImageSerialization.DatanodeImage.skipOne(in);
                            continue block30;
                        }
                        case 6: {
                            ++numOpOther;
                            DatanodeID nodeID = new DatanodeID();
                            nodeID.readFields(in);
                            continue block30;
                        }
                        case 7: {
                            ++numOpSetPerm;
                            fsDir.unprotectedSetPermission(FSImageSerialization.readString(in), FsPermission.read((DataInput)in));
                            continue block30;
                        }
                        case 8: {
                            ++numOpSetOwner;
                            fsDir.unprotectedSetOwner(FSImageSerialization.readString(in), FSImageSerialization.readString_EmptyAsNull(in), FSImageSerialization.readString_EmptyAsNull(in));
                            continue block30;
                        }
                        case 11: {
                            fsDir.unprotectedSetQuota(FSImageSerialization.readString(in), FSEditLogLoader.readLongWritable(in), Long.MAX_VALUE);
                            continue block30;
                        }
                        case 12: {
                            fsDir.unprotectedSetQuota(FSImageSerialization.readString(in), -1L, Long.MAX_VALUE);
                            continue block30;
                        }
                        case 14: {
                            fsDir.unprotectedSetQuota(FSImageSerialization.readString(in), FSEditLogLoader.readLongWritable(in), FSEditLogLoader.readLongWritable(in));
                            continue block30;
                        }
                        case 13: {
                            ++numOpTimes;
                            int length = in.readInt();
                            if (length != 3) {
                                throw new IOException("Incorrect data format. times operation.");
                            }
                            path = FSImageSerialization.readString(in);
                            mtime = FSEditLogLoader.readLong(in);
                            atime = FSEditLogLoader.readLong(in);
                            fsDir.unprotectedSetTimes(path, mtime, atime, true);
                            continue block30;
                        }
                        case 17: {
                            ++numOpSymlink;
                            int length = in.readInt();
                            if (length != 4) {
                                throw new IOException("Incorrect data format. symlink operation.");
                            }
                            path = FSImageSerialization.readString(in);
                            String value = FSImageSerialization.readString(in);
                            mtime = FSEditLogLoader.readLong(in);
                            atime = FSEditLogLoader.readLong(in);
                            PermissionStatus perm = PermissionStatus.read((DataInput)in);
                            fsDir.unprotectedSymlink(path, value, mtime, atime, perm);
                            continue block30;
                        }
                        case 15: {
                            ++numOpRename;
                            int length = in.readInt();
                            if (length != 3) {
                                throw new IOException("Incorrect data format. Mkdir operation.");
                            }
                            String s = FSImageSerialization.readString(in);
                            String d = FSImageSerialization.readString(in);
                            timestamp = FSEditLogLoader.readLong(in);
                            Options.Rename[] options = FSEditLogLoader.readRenameOptions(in);
                            HdfsFileStatus dinfo = fsDir.getFileInfo(d, false);
                            fsDir.unprotectedRenameTo(s, d, timestamp, options);
                            this.fsNamesys.changeLease(s, d, dinfo);
                            continue block30;
                        }
                        case 18: {
                            ++numOpGetDelegationToken;
                            DelegationTokenIdentifier delegationTokenId = new DelegationTokenIdentifier();
                            delegationTokenId.readFields(in);
                            long expiryTime = FSEditLogLoader.readLong(in);
                            this.fsNamesys.getDelegationTokenSecretManager().addPersistedDelegationToken(delegationTokenId, expiryTime);
                            continue block30;
                        }
                        case 19: {
                            ++numOpRenewDelegationToken;
                            DelegationTokenIdentifier delegationTokenId = new DelegationTokenIdentifier();
                            delegationTokenId.readFields(in);
                            long expiryTime = FSEditLogLoader.readLong(in);
                            this.fsNamesys.getDelegationTokenSecretManager().updatePersistedTokenRenewal(delegationTokenId, expiryTime);
                            continue block30;
                        }
                        case 20: {
                            ++numOpCancelDelegationToken;
                            DelegationTokenIdentifier delegationTokenId = new DelegationTokenIdentifier();
                            delegationTokenId.readFields(in);
                            this.fsNamesys.getDelegationTokenSecretManager().updatePersistedTokenCancellation(delegationTokenId);
                            continue block30;
                        }
                        case 21: {
                            ++numOpUpdateMasterKey;
                            DelegationKey delegationKey = new DelegationKey();
                            delegationKey.readFields((DataInput)in);
                            this.fsNamesys.getDelegationTokenSecretManager().updatePersistedMasterKey(delegationKey);
                            continue block30;
                        }
                    }
                    break;
                }
                throw new IOException("Never seen opcode " + opcode);
            }
            catch (IOException ex) {
                this.check203UpgradeFailure(logVersion, ex);
            }
            finally {
                if (closeOnExit) {
                    in.close();
                }
            }
        }
        if (FSImage.LOG.isDebugEnabled()) {
            FSImage.LOG.debug((Object)("numOpAdd = " + numOpAdd + " numOpClose = " + numOpClose + " numOpDelete = " + numOpDelete + " numOpRenameOld = " + numOpRenameOld + " numOpSetRepl = " + numOpSetRepl + " numOpMkDir = " + numOpMkDir + " numOpSetPerm = " + numOpSetPerm + " numOpSetOwner = " + numOpSetOwner + " numOpSetGenStamp = " + numOpSetGenStamp + " numOpTimes = " + numOpTimes + " numOpConcatDelete  = " + numOpConcatDelete + " numOpRename = " + numOpRename + " numOpGetDelegationToken = " + numOpGetDelegationToken + " numOpRenewDelegationToken = " + numOpRenewDelegationToken + " numOpCancelDelegationToken = " + numOpCancelDelegationToken + " numOpUpdateMasterKey = " + numOpUpdateMasterKey + " numOpOther = " + numOpOther));
        }
        return numEdits;
    }

    private static DatanodeDescriptor[] readDatanodeDescriptorArray(DataInput in) throws IOException {
        DatanodeDescriptor[] locations = new DatanodeDescriptor[in.readInt()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = new DatanodeDescriptor();
            locations[i].readFieldsFromFSEditLog(in);
        }
        return locations;
    }

    private static short readShort(DataInputStream in) throws IOException {
        return Short.parseShort(FSImageSerialization.readString(in));
    }

    private static long readLong(DataInputStream in) throws IOException {
        return Long.parseLong(FSImageSerialization.readString(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readLongWritable(DataInputStream in) throws IOException {
        LongWritable longWritable = FSEditLogLoader.longWritable;
        synchronized (longWritable) {
            FSEditLogLoader.longWritable.readFields((DataInput)in);
            return FSEditLogLoader.longWritable.get();
        }
    }

    static Options.Rename[] readRenameOptions(DataInputStream in) throws IOException {
        BytesWritable writable = new BytesWritable();
        writable.readFields((DataInput)in);
        byte[] bytes = writable.getBytes();
        Options.Rename[] options = new Options.Rename[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            options[i] = Options.Rename.valueOf((byte)bytes[i]);
        }
        return options;
    }

    private static BlockInfo[] readBlocks(DataInputStream in, int logVersion, boolean isFileUnderConstruction, short replication) throws IOException {
        int numBlocks = in.readInt();
        BlockInfo[] blocks = new BlockInfo[numBlocks];
        Block blk = new Block();
        BlockTwo oldblk = new BlockTwo();
        for (int i = 0; i < numBlocks; ++i) {
            if (logVersion <= -14) {
                blk.readFields(in);
            } else {
                oldblk.readFields(in);
                blk.set(oldblk.blkid, oldblk.len, 0L);
            }
            blocks[i] = isFileUnderConstruction && i == numBlocks - 1 ? new BlockInfoUnderConstruction(blk, replication) : new BlockInfo(blk, replication);
        }
        return blocks;
    }

    private void check203UpgradeFailure(int logVersion, IOException ex) throws IOException {
        if (Storage.is203LayoutVersion(logVersion) && logVersion != FSConstants.LAYOUT_VERSION) {
            String msg = "During upgrade failed to load the editlog version " + logVersion + " from release 0.20.203. Please go back to the old " + " release and restart the namenode. This empties the editlog " + " and saves the namespace. Resume the upgrade after this step.";
            throw new IOException(msg, ex);
        }
        throw ex;
    }

    static class BlockTwo
    implements Writable {
        long blkid = 0L;
        long len = 0L;

        BlockTwo() {
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.blkid);
            out.writeLong(this.len);
        }

        public void readFields(DataInput in) throws IOException {
            this.blkid = in.readLong();
            this.len = in.readLong();
        }

        static {
            WritableFactories.setFactory(BlockTwo.class, (WritableFactory)new WritableFactory(){

                public Writable newInstance() {
                    return new BlockTwo();
                }
            });
        }
    }
}

