/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.CyclicIteration;

class DecommissionManager {
    static final Log LOG = LogFactory.getLog(DecommissionManager.class);
    private final FSNamesystem fsnamesystem;

    DecommissionManager(FSNamesystem namesystem) {
        this.fsnamesystem = namesystem;
    }

    class Monitor
    implements Runnable {
        private final long recheckInterval;
        private final int numNodesPerCheck;
        private String firstkey = "";

        Monitor(int recheckIntervalInSecond, int numNodesPerCheck) {
            this.recheckInterval = (long)recheckIntervalInSecond * 1000L;
            this.numNodesPerCheck = numNodesPerCheck;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DecommissionManager.this.fsnamesystem.isRunning()) {
                DecommissionManager.this.fsnamesystem.writeLock();
                try {
                    this.check();
                }
                finally {
                    DecommissionManager.this.fsnamesystem.writeUnlock();
                }
                try {
                    Thread.sleep(this.recheckInterval);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)(this.getClass().getSimpleName() + " interrupted: " + ie));
                }
            }
        }

        private void check() {
            int count = 0;
            for (Map.Entry entry : new CyclicIteration(((DecommissionManager)DecommissionManager.this).fsnamesystem.datanodeMap, (Object)this.firstkey)) {
                DatanodeDescriptor d = (DatanodeDescriptor)entry.getValue();
                this.firstkey = (String)entry.getKey();
                if (!d.isDecommissionInProgress()) continue;
                try {
                    DecommissionManager.this.fsnamesystem.checkDecommissionStateInternal(d);
                }
                catch (Exception e) {
                    LOG.warn((Object)("entry=" + entry), (Throwable)e);
                }
                if (++count != this.numNodesPerCheck) continue;
                return;
            }
        }
    }
}

