/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.WritableComparable;

@InterfaceAudience.Private
public class CheckpointSignature
extends StorageInfo
implements WritableComparable<CheckpointSignature> {
    private static final String FIELD_SEPARATOR = ":";
    long editsTime = -1L;
    long checkpointTime = -1L;
    MD5Hash imageDigest = null;

    public CheckpointSignature() {
    }

    CheckpointSignature(FSImage fsImage) {
        super(fsImage);
        this.editsTime = fsImage.getEditLog().getFsEditTime();
        this.checkpointTime = fsImage.getCheckpointTime();
        this.imageDigest = fsImage.imageDigest;
    }

    CheckpointSignature(String str) {
        String[] fields = str.split(FIELD_SEPARATOR);
        assert (fields.length == 6) : "Must be 6 fields in CheckpointSignature";
        this.layoutVersion = Integer.valueOf(fields[0]);
        this.namespaceID = Integer.valueOf(fields[1]);
        this.cTime = Long.valueOf(fields[2]);
        this.editsTime = Long.valueOf(fields[3]);
        this.checkpointTime = Long.valueOf(fields[4]);
        this.imageDigest = new MD5Hash(fields[5]);
    }

    MD5Hash getImageDigest() {
        return this.imageDigest;
    }

    public String toString() {
        return String.valueOf(this.layoutVersion) + FIELD_SEPARATOR + String.valueOf(this.namespaceID) + FIELD_SEPARATOR + String.valueOf(this.cTime) + FIELD_SEPARATOR + String.valueOf(this.editsTime) + FIELD_SEPARATOR + String.valueOf(this.checkpointTime) + FIELD_SEPARATOR + this.imageDigest.toString();
    }

    void validateStorageInfo(FSImage si) throws IOException {
        if (this.layoutVersion != si.layoutVersion || this.namespaceID != si.namespaceID || this.cTime != si.cTime || this.checkpointTime != si.checkpointTime || !this.imageDigest.equals((Object)si.imageDigest)) {
            throw new IOException("Inconsistent checkpoint fields.\nLV = " + this.layoutVersion + " namespaceID = " + this.namespaceID + " cTime = " + this.cTime + "; checkpointTime = " + this.checkpointTime + " ; imageDigest = " + this.imageDigest + ".\nExpecting respectively: " + si.layoutVersion + "; " + si.namespaceID + "; " + si.cTime + "; " + si.checkpointTime + "; " + si.imageDigest);
        }
    }

    public int compareTo(CheckpointSignature o) {
        return this.layoutVersion < o.layoutVersion ? -1 : (this.layoutVersion > o.layoutVersion ? 1 : (this.namespaceID < o.namespaceID ? -1 : (this.namespaceID > o.namespaceID ? 1 : (this.cTime < o.cTime ? -1 : (this.cTime > o.cTime ? 1 : (this.editsTime < o.editsTime ? -1 : (this.editsTime > o.editsTime ? 1 : (this.checkpointTime < o.checkpointTime ? -1 : (this.checkpointTime > o.checkpointTime ? 1 : this.imageDigest.compareTo(o.imageDigest))))))))));
    }

    public boolean equals(Object o) {
        if (!(o instanceof CheckpointSignature)) {
            return false;
        }
        return this.compareTo((CheckpointSignature)o) == 0;
    }

    public int hashCode() {
        return this.layoutVersion ^ this.namespaceID ^ (int)(this.cTime ^ this.editsTime ^ this.checkpointTime) ^ this.imageDigest.hashCode();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.editsTime);
        out.writeLong(this.checkpointTime);
        this.imageDigest.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.editsTime = in.readLong();
        this.checkpointTime = in.readLong();
        this.imageDigest = new MD5Hash();
        this.imageDigest.readFields(in);
    }
}

