/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.EditLogBackupInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.io.LongWritable;

@InterfaceAudience.Private
public class BackupStorage
extends FSImage {
    private static final String STORAGE_JSPOOL_DIR = "jspool";
    private static final String STORAGE_JSPOOL_FILE = FSImage.NameNodeFile.EDITS_NEW.getName();
    private EditLogBackupInputStream backupInputStream;
    volatile JSpoolState jsState = JSpoolState.OFF;

    BackupStorage() {
    }

    @Override
    public boolean isPreUpgradableLayout(Storage.StorageDirectory sd) throws IOException {
        return false;
    }

    void recoverCreateRead(Collection<URI> imageDirs, Collection<URI> editsDirs) throws IOException {
        this.setStorageDirectories(imageDirs, editsDirs);
        this.checkpointTime = 0L;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                Storage.StorageState curState = sd.analyzeStorage(HdfsConstants.StartupOption.REGULAR);
                switch (curState) {
                    case NON_EXISTENT: {
                        throw new InconsistentFSStateException(sd.getRoot(), "checkpoint directory does not exist or is not accessible.");
                    }
                    case NOT_FORMATTED: {
                        LOG.info((Object)("Storage directory " + sd.getRoot() + " is not formatted."));
                        LOG.info((Object)"Formatting ...");
                        sd.clearDirectory();
                        break;
                    }
                    case NORMAL: {
                        break;
                    }
                    default: {
                        sd.doRecover(curState);
                    }
                }
                if (curState == Storage.StorageState.NOT_FORMATTED) continue;
                sd.read();
            }
            catch (IOException ioe) {
                sd.unlock();
                throw ioe;
            }
        }
    }

    synchronized void reset() throws IOException {
        FSDirectory fsDir = this.getFSNamesystem().dir;
        fsDir.reset();
        this.unlockAll();
        this.recoverCreateRead(this.getImageDirectories(), this.getEditsDirectories());
        for (Storage.StorageDirectory sd : this.storageDirs) {
            this.moveCurrent(sd);
        }
        this.imageDigest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCheckpoint(CheckpointSignature sig) throws IOException {
        FSDirectory fsDir;
        if (!this.editLog.isOpen()) {
            this.editLog.open();
        }
        if ((fsDir = this.getFSNamesystem().dir).isEmpty()) {
            Iterator<Storage.StorageDirectory> itImage = this.dirIterator(FSImage.NameNodeDirType.IMAGE);
            Iterator<Storage.StorageDirectory> itEdits = this.dirIterator(FSImage.NameNodeDirType.EDITS);
            if (!itImage.hasNext() || !itEdits.hasNext()) {
                throw new IOException("Could not locate checkpoint directories");
            }
            Storage.StorageDirectory sdName = itImage.next();
            Storage.StorageDirectory sdEdits = itEdits.next();
            fsDir.writeLock();
            try {
                this.imageDigest = sig.imageDigest;
                this.loadFSImage(FSImage.getImageFile(sdName, FSImage.NameNodeFile.IMAGE));
            }
            finally {
                fsDir.writeUnlock();
            }
            this.loadFSEdits(sdEdits);
        }
        this.setStorageInfo(sig);
        this.imageDigest = sig.imageDigest;
        this.checkpointTime = sig.checkpointTime;
        fsDir.setReady();
        this.getFSNamesystem().setBlockTotal();
    }

    void saveCheckpoint() throws IOException {
        this.saveNamespace(false);
    }

    static File getJSpoolDir(Storage.StorageDirectory sd) {
        return new File(sd.getRoot(), STORAGE_JSPOOL_DIR);
    }

    static File getJSpoolFile(Storage.StorageDirectory sd) {
        return new File(BackupStorage.getJSpoolDir(sd), STORAGE_JSPOOL_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void journal(int length, byte[] data) throws IOException {
        assert (this.backupInputStream.length() == 0L) : "backup input stream is not empty";
        try {
            switch (this.jsState) {
                case WAIT: 
                case OFF: {
                    this.waitSpoolEnd();
                    this.backupInputStream.setBytes(data);
                    FSEditLogLoader logLoader = new FSEditLogLoader(this.namesystem);
                    logLoader.loadEditRecords(this.getLayoutVersion(), this.backupInputStream.getDataInputStream(), true);
                    this.getFSNamesystem().dir.updateCountForINodeWithQuota();
                    break;
                }
            }
            this.editLog.logEdit(length, data);
            this.editLog.logSync();
        }
        finally {
            this.backupInputStream.clear();
        }
    }

    private synchronized void waitSpoolEnd() {
        while (this.jsState == JSpoolState.WAIT) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        assert (this.jsState == JSpoolState.OFF) : "Unexpected JSpool state: " + (Object)((Object)this.jsState);
    }

    synchronized void startJournalSpool(NamenodeRegistration nnReg) throws IOException {
        switch (this.jsState) {
            case OFF: {
                break;
            }
            case INPROGRESS: {
                return;
            }
            case WAIT: {
                this.waitSpoolEnd();
            }
        }
        ArrayList<Storage.StorageDirectory> errorSDs = new ArrayList<Storage.StorageDirectory>();
        Iterator<Storage.StorageDirectory> it = this.dirIterator(FSImage.NameNodeDirType.EDITS);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            File jsDir = BackupStorage.getJSpoolDir(sd);
            if (!jsDir.exists() && !jsDir.mkdirs()) {
                throw new IOException("Mkdirs failed to create " + jsDir.getCanonicalPath());
            }
            File eFile = this.getEditFile(sd);
            if (eFile.exists()) continue;
            try {
                this.editLog.createEditLogFile(eFile);
            }
            catch (IOException ie) {
                LOG.error((Object)("Unable to save edits for " + sd.getRoot()), (Throwable)ie);
                errorSDs.add(sd);
            }
        }
        if (errorSDs.size() > 0) {
            this.processIOError(errorSDs, true);
        }
        if (!this.editLog.isOpen()) {
            this.editLog.open();
        }
        this.editLog.divertFileStreams("jspool/" + STORAGE_JSPOOL_FILE);
        this.setCheckpointState(FSImage.CheckpointStates.ROLLED_EDITS);
        if (this.backupInputStream == null) {
            this.backupInputStream = new EditLogBackupInputStream(nnReg.getAddress());
        }
        this.jsState = JSpoolState.INPROGRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setCheckpointTime(int length, byte[] data) throws IOException {
        assert (this.backupInputStream.length() == 0L) : "backup input stream is not empty";
        try {
            this.backupInputStream.setBytes(data);
            DataInputStream in = this.backupInputStream.getDataInputStream();
            byte op = in.readByte();
            assert (op == 103);
            LongWritable lw = new LongWritable();
            lw.readFields((DataInput)in);
            this.setCheckpointTime(lw.get());
        }
        finally {
            this.backupInputStream.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convergeJournalSpool() throws IOException {
        Object edits;
        Iterator<Storage.StorageDirectory> itEdits = this.dirIterator(FSImage.NameNodeDirType.EDITS);
        if (!itEdits.hasNext()) {
            throw new IOException("Could not locate checkpoint directories");
        }
        Storage.StorageDirectory sdEdits = itEdits.next();
        int numEdits = 0;
        File jSpoolFile = BackupStorage.getJSpoolFile(sdEdits);
        long startTime = Util.now();
        if (jSpoolFile.exists()) {
            edits = new EditLogFileInputStream(jSpoolFile);
            DataInputStream in = ((EditLogInputStream)edits).getDataInputStream();
            FSEditLogLoader logLoader = new FSEditLogLoader(this.namesystem);
            numEdits += logLoader.loadFSEdits(in, false);
            this.jsState = JSpoolState.WAIT;
            numEdits += logLoader.loadEditRecords(this.getLayoutVersion(), in, true);
            this.getFSNamesystem().dir.updateCountForINodeWithQuota();
            ((EditLogFileInputStream)edits).close();
        }
        FSImage.LOG.info((Object)("Edits file " + jSpoolFile.getCanonicalPath() + " of size " + jSpoolFile.length() + " edits # " + numEdits + " loaded in " + (Util.now() - startTime) / 1000L + " seconds."));
        this.editLog.revertFileStreams("jspool/" + STORAGE_JSPOOL_FILE);
        this.resetVersion(false, this.imageDigest);
        edits = this;
        synchronized (edits) {
            this.jsState = JSpoolState.OFF;
            this.notifyAll();
        }
        for (Storage.StorageDirectory sd : this.storageDirs) {
            this.moveLastCheckpoint(sd);
        }
    }

    static enum JSpoolState {
        OFF,
        INPROGRESS,
        WAIT;

    }
}

