/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;

class DataXceiverServer
implements Runnable,
FSConstants {
    public static final Log LOG = DataNode.LOG;
    ServerSocket ss;
    DataNode datanode;
    Map<Socket, Socket> childSockets = Collections.synchronizedMap(new HashMap());
    int maxXceiverCount = 4096;
    BlockBalanceThrottler balanceThrottler;
    long estimateBlockSize;

    DataXceiverServer(ServerSocket ss, Configuration conf, DataNode datanode) {
        this.ss = ss;
        this.datanode = datanode;
        this.maxXceiverCount = conf.getInt("dfs.datanode.max.transfer.threads", 4096);
        this.estimateBlockSize = conf.getLong("dfs.blocksize", 0x4000000L);
        this.balanceThrottler = new BlockBalanceThrottler(conf.getLong("dfs.datanode.balance.bandwidthPerSec", 0x100000L));
    }

    @Override
    public void run() {
        while (this.datanode.shouldRun) {
            Socket s = null;
            try {
                s = this.ss.accept();
                s.setTcpNoDelay(true);
                new Daemon(this.datanode.threadGroup, (Runnable)new DataXceiver(s, this.datanode, this)).start();
            }
            catch (SocketTimeoutException ignored) {
            }
            catch (AsynchronousCloseException ace) {
                if (!this.datanode.shouldRun) continue;
                LOG.warn((Object)(this.datanode.dnRegistration + ":DataXceiverServer: "), (Throwable)ace);
            }
            catch (IOException ie) {
                IOUtils.closeSocket((Socket)s);
                LOG.warn((Object)(this.datanode.dnRegistration + ":DataXceiveServer: " + StringUtils.stringifyException((Throwable)ie)));
            }
            catch (OutOfMemoryError ie) {
                IOUtils.closeSocket((Socket)s);
                LOG.warn((Object)"DataNode is out of memory. Will retry in 30 seconds.", (Throwable)ie);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable te) {
                LOG.error((Object)(this.datanode.dnRegistration + ":DataXceiveServer: Exiting due to:" + StringUtils.stringifyException((Throwable)te)));
                this.datanode.shouldRun = false;
            }
        }
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn((Object)(this.datanode.dnRegistration + ":DataXceiveServer: " + StringUtils.stringifyException((Throwable)ie)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        assert (!this.datanode.shouldRun) : "shoudRun should be set to false before killing";
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn((Object)(this.datanode.dnRegistration + ":DataXceiveServer.kill(): " + StringUtils.stringifyException((Throwable)ie)));
        }
        Map<Socket, Socket> map = this.childSockets;
        synchronized (map) {
            for (Socket thissock : this.childSockets.values()) {
                try {
                    thissock.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static class BlockBalanceThrottler
    extends DataTransferThrottler {
        private int numThreads;

        private BlockBalanceThrottler(long bandwidth) {
            super(bandwidth);
            LOG.info((Object)("Balancing bandwith is " + bandwidth + " bytes/s"));
        }

        synchronized boolean acquire() {
            if (this.numThreads >= 5) {
                return false;
            }
            ++this.numThreads;
            return true;
        }

        synchronized void release() {
            --this.numThreads;
        }
    }
}

