/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class UnresolvedPathException
extends UnresolvedLinkException {
    private static final long serialVersionUID = 1L;
    private String path;
    private String preceding;
    private String remainder;
    private String linkTarget;
    public static final String __PARANAMER_DATA = "<init> java.lang.String msg \n<init> java.lang.String,java.lang.String,java.lang.String,java.lang.String path,preceding,remainder,linkTarget \n";

    public UnresolvedPathException(String msg) {
        super(msg);
    }

    public UnresolvedPathException(String path, String preceding, String remainder, String linkTarget) {
        this.path = path;
        this.preceding = preceding;
        this.remainder = remainder;
        this.linkTarget = linkTarget;
    }

    public Path getResolvedPath() throws IOException {
        boolean noRemainder = this.remainder == null || "".equals(this.remainder);
        Path target = new Path(this.linkTarget);
        if (target.isUriPathAbsolute()) {
            return noRemainder ? target : new Path(target, this.remainder);
        }
        return noRemainder ? new Path(this.preceding, target) : new Path(new Path(this.preceding, this.linkTarget), this.remainder);
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg != null) {
            return msg;
        }
        String myMsg = "Unresolved path " + this.path;
        try {
            return this.getResolvedPath().toString();
        }
        catch (IOException iOException) {
            return myMsg;
        }
    }
}

