/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface DataTransferProtocol {
    public static final int DATA_TRANSFER_VERSION = 19;
    @Deprecated
    public static final byte OP_WRITE_BLOCK = Op.WRITE_BLOCK.code;
    @Deprecated
    public static final byte OP_READ_BLOCK = Op.READ_BLOCK.code;
    @Deprecated
    public static final byte OP_READ_METADATA = Op.READ_METADATA.code;
    @Deprecated
    public static final byte OP_REPLACE_BLOCK = Op.REPLACE_BLOCK.code;
    @Deprecated
    public static final byte OP_COPY_BLOCK = Op.COPY_BLOCK.code;
    @Deprecated
    public static final byte OP_BLOCK_CHECKSUM = Op.BLOCK_CHECKSUM.code;
    @Deprecated
    public static final int OP_STATUS_SUCCESS = Status.access$000(Status.SUCCESS);
    @Deprecated
    public static final int OP_STATUS_ERROR = Status.access$000(Status.ERROR);
    @Deprecated
    public static final int OP_STATUS_ERROR_CHECKSUM = Status.access$000(Status.ERROR_CHECKSUM);
    @Deprecated
    public static final int OP_STATUS_ERROR_INVALID = Status.access$000(Status.ERROR_INVALID);
    @Deprecated
    public static final int OP_STATUS_ERROR_EXISTS = Status.access$000(Status.ERROR_EXISTS);
    @Deprecated
    public static final int OP_STATUS_ERROR_ACCESS_TOKEN = Status.access$000(Status.ERROR_ACCESS_TOKEN);
    @Deprecated
    public static final int OP_STATUS_CHECKSUM_OK = Status.access$000(Status.CHECKSUM_OK);
    public static final String __PARANAMER_DATA = "";

    public static class PacketHeader
    implements Writable {
        public static final int PKT_HEADER_LEN = 25;
        private int packetLen;
        private long offsetInBlock;
        private long seqno;
        private boolean lastPacketInBlock;
        private int dataLen;
        public static final String __PARANAMER_DATA = "<init> int,long,long,boolean,int packetLen,offsetInBlock,seqno,lastPacketInBlock,dataLen \nequals java.lang.Object o \nsanityCheck long lastSeqNo \nputInBuffer java.nio.ByteBuffer buf \nreadFields java.io.DataInput in \nreadFields java.nio.ByteBuffer buf \nwrite java.io.DataOutput out \n";

        public PacketHeader() {
        }

        public PacketHeader(int packetLen, long offsetInBlock, long seqno, boolean lastPacketInBlock, int dataLen) {
            this.packetLen = packetLen;
            this.offsetInBlock = offsetInBlock;
            this.seqno = seqno;
            this.lastPacketInBlock = lastPacketInBlock;
            this.dataLen = dataLen;
        }

        public int getDataLen() {
            return this.dataLen;
        }

        public boolean isLastPacketInBlock() {
            return this.lastPacketInBlock;
        }

        public long getSeqno() {
            return this.seqno;
        }

        public long getOffsetInBlock() {
            return this.offsetInBlock;
        }

        public int getPacketLen() {
            return this.packetLen;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PacketHeader(").append("packetLen=").append(this.packetLen).append(" offsetInBlock=").append(this.offsetInBlock).append(" seqno=").append(this.seqno).append(" lastPacketInBlock=").append(this.lastPacketInBlock).append(" dataLen=").append(this.dataLen).append(")");
            return sb.toString();
        }

        public void readFields(DataInput in) throws IOException {
            this.packetLen = in.readInt();
            this.offsetInBlock = in.readLong();
            this.seqno = in.readLong();
            this.lastPacketInBlock = in.readBoolean();
            this.dataLen = in.readInt();
        }

        public void readFields(ByteBuffer buf) throws IOException {
            this.packetLen = buf.getInt();
            this.offsetInBlock = buf.getLong();
            this.seqno = buf.getLong();
            this.lastPacketInBlock = buf.get() != 0;
            this.dataLen = buf.getInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.packetLen);
            out.writeLong(this.offsetInBlock);
            out.writeLong(this.seqno);
            out.writeBoolean(this.lastPacketInBlock);
            out.writeInt(this.dataLen);
        }

        public void putInBuffer(ByteBuffer buf) {
            buf.putInt(this.packetLen).putLong(this.offsetInBlock).putLong(this.seqno).put((byte)(this.lastPacketInBlock ? 1 : 0)).putInt(this.dataLen);
        }

        public boolean sanityCheck(long lastSeqNo) {
            if (this.dataLen <= 0 && this.lastPacketInBlock) {
                return false;
            }
            if (this.lastPacketInBlock && this.dataLen != 0) {
                return false;
            }
            return this.seqno == lastSeqNo + 1L;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PacketHeader)) {
                return false;
            }
            PacketHeader other = (PacketHeader)o;
            return other.packetLen == this.packetLen && other.offsetInBlock == this.offsetInBlock && other.seqno == this.seqno && other.lastPacketInBlock == this.lastPacketInBlock && other.dataLen == this.dataLen;
        }

        public int hashCode() {
            return (int)this.seqno;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class PipelineAck
    implements Writable {
        private long seqno;
        private Status[] replies;
        public static final long UNKOWN_SEQNO = -2L;
        public static final String __PARANAMER_DATA = "<init> long,org.apache.hadoop.hdfs.protocol.DataTransferProtocol.Status[] seqno,replies \ngetReply int i \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

        public PipelineAck() {
        }

        public PipelineAck(long seqno, Status[] replies) {
            this.seqno = seqno;
            this.replies = replies;
        }

        public long getSeqno() {
            return this.seqno;
        }

        public short getNumOfReplies() {
            return (short)this.replies.length;
        }

        public Status getReply(int i) {
            if (i < 0 || i >= this.replies.length) {
                throw new IllegalArgumentException("The input parameter " + i + " should in the range of [0, " + this.replies.length);
            }
            return this.replies[i];
        }

        public boolean isSuccess() {
            for (Status reply : this.replies) {
                if (reply == Status.SUCCESS) continue;
                return false;
            }
            return true;
        }

        public void readFields(DataInput in) throws IOException {
            this.seqno = in.readLong();
            int numOfReplies = in.readShort();
            this.replies = new Status[numOfReplies];
            for (int i = 0; i < numOfReplies; ++i) {
                this.replies[i] = Status.read(in);
            }
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.seqno);
            out.writeShort((short)this.replies.length);
            for (Status reply : this.replies) {
                reply.write(out);
            }
        }

        public String toString() {
            StringBuilder ack = new StringBuilder("Replies for seqno ");
            ack.append(this.seqno).append(" are");
            for (Status reply : this.replies) {
                ack.append(" ");
                ack.append((Object)reply);
            }
            return ack.toString();
        }
    }

    public static abstract class Receiver {
        public static final String __PARANAMER_DATA = "readOp java.io.DataInputStream in \nopBlockChecksum java.io.DataInputStream,org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.security.token.Token in,blk,blockToken \nopCopyBlock java.io.DataInputStream,org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.security.token.Token in,blk,blockToken \nopReadBlock java.io.DataInputStream,org.apache.hadoop.hdfs.protocol.Block,long,long,java.lang.String,org.apache.hadoop.security.token.Token in,blk,offset,length,client,blockToken \nopReplaceBlock java.io.DataInputStream,org.apache.hadoop.hdfs.protocol.Block,java.lang.String,org.apache.hadoop.hdfs.protocol.DatanodeInfo,org.apache.hadoop.security.token.Token in,blk,sourceId,src,blockToken \nopWriteBlock java.io.DataInputStream,org.apache.hadoop.hdfs.protocol.Block,int,org.apache.hadoop.hdfs.protocol.DataTransferProtocol.BlockConstructionStage,long,long,long,java.lang.String,org.apache.hadoop.hdfs.protocol.DatanodeInfo,org.apache.hadoop.hdfs.protocol.DatanodeInfo[],org.apache.hadoop.security.token.Token in,blk,pipelineSize,stage,newGs,minBytesRcvd,maxBytesRcvd,client,src,targets,blockToken \nprocessOp org.apache.hadoop.hdfs.protocol.DataTransferProtocol.Op,java.io.DataInputStream op,in \n";

        protected final Op readOp(DataInputStream in) throws IOException {
            short version = in.readShort();
            if (version != 19) {
                throw new IOException("Version Mismatch (Expected: 19, Received: " + version + " )");
            }
            return Op.read(in);
        }

        protected final void processOp(Op op, DataInputStream in) throws IOException {
            switch (op) {
                case READ_BLOCK: {
                    this.opReadBlock(in);
                    break;
                }
                case WRITE_BLOCK: {
                    this.opWriteBlock(in);
                    break;
                }
                case REPLACE_BLOCK: {
                    this.opReplaceBlock(in);
                    break;
                }
                case COPY_BLOCK: {
                    this.opCopyBlock(in);
                    break;
                }
                case BLOCK_CHECKSUM: {
                    this.opBlockChecksum(in);
                    break;
                }
                default: {
                    throw new IOException("Unknown op " + (Object)((Object)op) + " in data stream");
                }
            }
        }

        private void opReadBlock(DataInputStream in) throws IOException {
            Block blk = new Block();
            blk.readId(in);
            long offset = in.readLong();
            long length = in.readLong();
            String client = Text.readString((DataInput)in);
            Token<BlockTokenIdentifier> blockToken = Receiver.readBlockToken(in);
            this.opReadBlock(in, blk, offset, length, client, blockToken);
        }

        protected abstract void opReadBlock(DataInputStream var1, Block var2, long var3, long var5, String var7, Token<BlockTokenIdentifier> var8) throws IOException;

        private void opWriteBlock(DataInputStream in) throws IOException {
            Block blk = new Block();
            blk.readId(in);
            int pipelineSize = in.readInt();
            BlockConstructionStage stage = BlockConstructionStage.readFields(in);
            long newGs = WritableUtils.readVLong((DataInput)in);
            long minBytesRcvd = WritableUtils.readVLong((DataInput)in);
            long maxBytesRcvd = WritableUtils.readVLong((DataInput)in);
            String client = Text.readString((DataInput)in);
            DatanodeInfo src = in.readBoolean() ? DatanodeInfo.read(in) : null;
            int nTargets = in.readInt();
            if (nTargets < 0) {
                throw new IOException("Mislabelled incoming datastream.");
            }
            DatanodeInfo[] targets = new DatanodeInfo[nTargets];
            for (int i = 0; i < targets.length; ++i) {
                targets[i] = DatanodeInfo.read(in);
            }
            Token<BlockTokenIdentifier> blockToken = Receiver.readBlockToken(in);
            this.opWriteBlock(in, blk, pipelineSize, stage, newGs, minBytesRcvd, maxBytesRcvd, client, src, targets, blockToken);
        }

        protected abstract void opWriteBlock(DataInputStream var1, Block var2, int var3, BlockConstructionStage var4, long var5, long var7, long var9, String var11, DatanodeInfo var12, DatanodeInfo[] var13, Token<BlockTokenIdentifier> var14) throws IOException;

        private void opReplaceBlock(DataInputStream in) throws IOException {
            Block blk = new Block();
            blk.readId(in);
            String sourceId = Text.readString((DataInput)in);
            DatanodeInfo src = DatanodeInfo.read(in);
            Token<BlockTokenIdentifier> blockToken = Receiver.readBlockToken(in);
            this.opReplaceBlock(in, blk, sourceId, src, blockToken);
        }

        protected abstract void opReplaceBlock(DataInputStream var1, Block var2, String var3, DatanodeInfo var4, Token<BlockTokenIdentifier> var5) throws IOException;

        private void opCopyBlock(DataInputStream in) throws IOException {
            Block blk = new Block();
            blk.readId(in);
            Token<BlockTokenIdentifier> blockToken = Receiver.readBlockToken(in);
            this.opCopyBlock(in, blk, blockToken);
        }

        protected abstract void opCopyBlock(DataInputStream var1, Block var2, Token<BlockTokenIdentifier> var3) throws IOException;

        private void opBlockChecksum(DataInputStream in) throws IOException {
            Block blk = new Block();
            blk.readId(in);
            Token<BlockTokenIdentifier> blockToken = Receiver.readBlockToken(in);
            this.opBlockChecksum(in, blk, blockToken);
        }

        protected abstract void opBlockChecksum(DataInputStream var1, Block var2, Token<BlockTokenIdentifier> var3) throws IOException;

        private static Token<BlockTokenIdentifier> readBlockToken(DataInputStream in) throws IOException {
            Token t = new Token();
            t.readFields((DataInput)in);
            return t;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class Sender {
        public static final String __PARANAMER_DATA = "op java.io.DataOutputStream,org.apache.hadoop.hdfs.protocol.DataTransferProtocol.Op out,op \nopBlockChecksum java.io.DataOutputStream,org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.security.token.Token out,blk,blockToken \nopCopyBlock java.io.DataOutputStream,org.apache.hadoop.hdfs.protocol.Block,org.apache.hadoop.security.token.Token out,blk,blockToken \nopReadBlock java.io.DataOutputStream,org.apache.hadoop.hdfs.protocol.Block,long,long,java.lang.String,org.apache.hadoop.security.token.Token out,blk,blockOffset,blockLen,clientName,blockToken \nopReplaceBlock java.io.DataOutputStream,org.apache.hadoop.hdfs.protocol.Block,java.lang.String,org.apache.hadoop.hdfs.protocol.DatanodeInfo,org.apache.hadoop.security.token.Token out,blk,storageId,src,blockToken \nopWriteBlock java.io.DataOutputStream,org.apache.hadoop.hdfs.protocol.Block,int,org.apache.hadoop.hdfs.protocol.DataTransferProtocol.BlockConstructionStage,long,long,long,java.lang.String,org.apache.hadoop.hdfs.protocol.DatanodeInfo,org.apache.hadoop.hdfs.protocol.DatanodeInfo[],org.apache.hadoop.security.token.Token out,blk,pipelineSize,stage,newGs,minBytesRcvd,maxBytesRcvd,client,src,targets,blockToken \n";

        public static void op(DataOutputStream out, Op op) throws IOException {
            out.writeShort(19);
            op.write(out);
        }

        public static void opReadBlock(DataOutputStream out, Block blk, long blockOffset, long blockLen, String clientName, Token<BlockTokenIdentifier> blockToken) throws IOException {
            Sender.op(out, Op.READ_BLOCK);
            blk.writeId(out);
            out.writeLong(blockOffset);
            out.writeLong(blockLen);
            Text.writeString((DataOutput)out, (String)clientName);
            blockToken.write((DataOutput)out);
            out.flush();
        }

        public static void opWriteBlock(DataOutputStream out, Block blk, int pipelineSize, BlockConstructionStage stage, long newGs, long minBytesRcvd, long maxBytesRcvd, String client, DatanodeInfo src, DatanodeInfo[] targets, Token<BlockTokenIdentifier> blockToken) throws IOException {
            Sender.op(out, Op.WRITE_BLOCK);
            blk.writeId(out);
            out.writeInt(pipelineSize);
            stage.write(out);
            WritableUtils.writeVLong((DataOutput)out, (long)newGs);
            WritableUtils.writeVLong((DataOutput)out, (long)minBytesRcvd);
            WritableUtils.writeVLong((DataOutput)out, (long)maxBytesRcvd);
            Text.writeString((DataOutput)out, (String)client);
            out.writeBoolean(src != null);
            if (src != null) {
                src.write(out);
            }
            out.writeInt(targets.length - 1);
            for (int i = 1; i < targets.length; ++i) {
                targets[i].write(out);
            }
            blockToken.write((DataOutput)out);
        }

        public static void opReplaceBlock(DataOutputStream out, Block blk, String storageId, DatanodeInfo src, Token<BlockTokenIdentifier> blockToken) throws IOException {
            Sender.op(out, Op.REPLACE_BLOCK);
            blk.writeId(out);
            Text.writeString((DataOutput)out, (String)storageId);
            src.write(out);
            blockToken.write((DataOutput)out);
            out.flush();
        }

        public static void opCopyBlock(DataOutputStream out, Block blk, Token<BlockTokenIdentifier> blockToken) throws IOException {
            Sender.op(out, Op.COPY_BLOCK);
            blk.writeId(out);
            blockToken.write((DataOutput)out);
            out.flush();
        }

        public static void opBlockChecksum(DataOutputStream out, Block blk, Token<BlockTokenIdentifier> blockToken) throws IOException {
            Sender.op(out, Op.BLOCK_CHECKSUM);
            blk.writeId(out);
            blockToken.write((DataOutput)out);
            out.flush();
        }
    }

    public static enum BlockConstructionStage {
        PIPELINE_SETUP_APPEND,
        PIPELINE_SETUP_APPEND_RECOVERY,
        DATA_STREAMING,
        PIPELINE_SETUP_STREAMING_RECOVERY,
        PIPELINE_CLOSE,
        PIPELINE_CLOSE_RECOVERY,
        PIPELINE_SETUP_CREATE;

        private static final byte RECOVERY_BIT = 1;
        public static final String __PARANAMER_DATA = "";

        public BlockConstructionStage getRecoveryStage() {
            if (this == PIPELINE_SETUP_CREATE) {
                throw new IllegalArgumentException("Unexpected blockStage " + (Object)((Object)this));
            }
            return BlockConstructionStage.values()[this.ordinal() | 1];
        }

        private static BlockConstructionStage valueOf(byte code) {
            return code < 0 || code >= BlockConstructionStage.values().length ? null : BlockConstructionStage.values()[code];
        }

        private static BlockConstructionStage readFields(DataInput in) throws IOException {
            return BlockConstructionStage.valueOf(in.readByte());
        }

        private void write(DataOutput out) throws IOException {
            out.writeByte(this.ordinal());
        }
    }

    public static enum Status {
        SUCCESS(0),
        ERROR(1),
        ERROR_CHECKSUM(2),
        ERROR_INVALID(3),
        ERROR_EXISTS(4),
        ERROR_ACCESS_TOKEN(5),
        CHECKSUM_OK(6);

        private final int code;
        private static final int FIRST_CODE;
        public static final String __PARANAMER_DATA = "read java.io.DataInput in \nwrite java.io.DataOutput out \nwriteOutputStream java.io.OutputStream out \n";

        private Status(int code) {
            this.code = code;
        }

        private static Status valueOf(int code) {
            int i = code - FIRST_CODE;
            return i < 0 || i >= Status.values().length ? null : Status.values()[i];
        }

        public static Status read(DataInput in) throws IOException {
            return Status.valueOf(in.readShort());
        }

        public void write(DataOutput out) throws IOException {
            out.writeShort(this.code);
        }

        public void writeOutputStream(OutputStream out) throws IOException {
            out.write(new byte[]{(byte)(this.code >>> 8), (byte)this.code});
        }

        static /* synthetic */ int access$000(Status x0) {
            return x0.code;
        }

        static {
            FIRST_CODE = Status.values()[0].code;
        }
    }

    public static enum Op {
        WRITE_BLOCK(80),
        READ_BLOCK(81),
        READ_METADATA(82),
        REPLACE_BLOCK(83),
        COPY_BLOCK(84),
        BLOCK_CHECKSUM(85);

        public final byte code;
        private static final int FIRST_CODE;
        public static final String __PARANAMER_DATA = "read java.io.DataInput in \nwrite java.io.DataOutput out \n";

        private Op(byte code) {
            this.code = code;
        }

        private static Op valueOf(byte code) {
            int i = (code & 0xFF) - FIRST_CODE;
            return i < 0 || i >= Op.values().length ? null : Op.values()[i];
        }

        public static Op read(DataInput in) throws IOException {
            return Op.valueOf(in.readByte());
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.code);
        }

        static {
            FIRST_CODE = Op.values()[0].code;
        }
    }
}

