/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ByteRangeInputStream;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HftpFileSystem
extends FileSystem {
    private static final int DEFAULT_PORT = 50470;
    private String nnHttpUrl;
    private URI hdfsURI;
    protected InetSocketAddress nnAddr;
    protected UserGroupInformation ugi;
    protected final Random ran = new Random();
    public static final String HFTP_TIMEZONE = "UTC";
    public static final String HFTP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private Token<DelegationTokenIdentifier> delegationToken;
    public static final String HFTP_SERVICE_NAME_KEY = "hdfs.service.host_";
    protected static final ThreadLocal<SimpleDateFormat> df;
    private static RenewerThread renewer;

    public static final SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(HFTP_DATE_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone(HFTP_TIMEZONE));
        return df;
    }

    protected int getDefaultPort() {
        return 50470;
    }

    public String getCanonicalServiceName() {
        return SecurityUtil.buildDTServiceName((URI)this.hdfsURI, (int)this.getDefaultPort());
    }

    private String buildUri(String schema, String host, int port) {
        StringBuilder sb = new StringBuilder(schema);
        return sb.append(host).append(":").append(port).toString();
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.nnAddr = NetUtils.createSocketAddr((String)name.toString());
        this.nnHttpUrl = this.buildUri("https://", NetUtils.normalizeHostName((String)name.getHost()), conf.getInt("dfs.https.port", 50470));
        String key = HFTP_SERVICE_NAME_KEY + SecurityUtil.buildDTServiceName((URI)name, (int)50470);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to find DT for " + name + " using key=" + key + "; conf=" + conf.get(key, "")));
        }
        String nnServiceName = conf.get(key);
        int nnPort = 8020;
        if (nnServiceName != null) {
            nnPort = NetUtils.createSocketAddr((String)nnServiceName, (int)8020).getPort();
        }
        try {
            this.hdfsURI = new URI(this.buildUri("hdfs://", this.nnAddr.getHostName(), nnPort));
        }
        catch (URISyntaxException ue) {
            throw new IOException("bad uri for hdfs", ue);
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            String canonicalName = this.getCanonicalServiceName();
            for (Token t : this.ugi.getTokens()) {
                if (!DelegationTokenIdentifier.HDFS_DELEGATION_KIND.equals((Object)t.getKind()) || !t.getService().toString().equals(canonicalName)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found existing DT for " + name));
                }
                this.delegationToken = t;
                break;
            }
            this.ugi.reloginFromKeytab();
            if (this.delegationToken == null) {
                this.delegationToken = this.getDelegationToken(null);
                renewer.addTokenToRenew(this);
            }
        }
    }

    public Token<?> getDelegationToken(final String renewer) throws IOException {
        try {
            return (Token)this.ugi.doAs(new PrivilegedExceptionAction<Token<?>>(){

                @Override
                public Token<?> run() throws IOException {
                    Credentials c;
                    try {
                        c = DelegationTokenFetcher.getDTfromRemote(HftpFileSystem.this.nnHttpUrl, renewer);
                    }
                    catch (Exception e) {
                        FileSystem.LOG.info((Object)("Couldn't get a delegation token from " + HftpFileSystem.this.nnHttpUrl + " using https."));
                        if (FileSystem.LOG.isDebugEnabled()) {
                            FileSystem.LOG.debug((Object)"error was ", (Throwable)e);
                        }
                        return null;
                    }
                    Iterator i$ = c.getAllTokens().iterator();
                    if (i$.hasNext()) {
                        Token t = (Token)i$.next();
                        if (FileSystem.LOG.isDebugEnabled()) {
                            FileSystem.LOG.debug((Object)("Got dt for " + HftpFileSystem.this.getUri() + ";t.service=" + t.getService()));
                        }
                        t.setService(new Text(HftpFileSystem.this.getCanonicalServiceName()));
                        return t;
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getUri() {
        try {
            return new URI("hftp", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    URL getNamenodeFileURL(Path f) throws IOException {
        return this.getNamenodeURL("/data" + f.toUri().getPath(), "ugi=" + this.getUgiParameter());
    }

    URL getNamenodeURL(String path, String query) throws IOException {
        try {
            URL url = new URI("http", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), path, query, null).toURL();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("url=" + url));
            }
            return url;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private String getUgiParameter() {
        StringBuilder ugiParamenter = new StringBuilder(this.ugi.getShortUserName());
        for (String g : this.ugi.getGroupNames()) {
            ugiParamenter.append(",");
            ugiParamenter.append(g);
        }
        return ugiParamenter.toString();
    }

    static Void throwIOExceptionFromConnection(HttpURLConnection connection, IOException ioe) throws IOException {
        int code = connection.getResponseCode();
        String s = connection.getResponseMessage();
        throw s == null ? ioe : new IOException(s + " (error code=" + code + ")", ioe);
    }

    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        query = this.updateQuery(query);
        URL url = this.getNamenodeURL(path, query);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        try {
            connection.setRequestMethod("GET");
            connection.connect();
        }
        catch (IOException ioe) {
            HftpFileSystem.throwIOExceptionFromConnection(connection, ioe);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String updateQuery(String query) throws IOException {
        String tokenString = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            HftpFileSystem hftpFileSystem = this;
            synchronized (hftpFileSystem) {
                if (this.delegationToken != null) {
                    tokenString = this.delegationToken.encodeToUrlString();
                    return query + JspHelper.getDelegationTokenUrlParam(tokenString);
                }
            }
        }
        return query;
    }

    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        String query = "ugi=" + this.getUgiParameter();
        query = this.updateQuery(query);
        URL u = this.getNamenodeURL("/data" + f.toUri().getPath(), query);
        return new FSDataInputStream((InputStream)((Object)new ByteRangeInputStream(u)));
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.listStatus(f);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.getFileStatus(f);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        return new ChecksumParser().getFileChecksum(s);
    }

    public Path getWorkingDirectory() {
        return new Path("/").makeQualified(this.getUri(), null);
    }

    public void setWorkingDirectory(Path f) {
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Not supported");
    }

    private static ContentSummary toContentSummary(Attributes attrs) throws SAXException {
        String length = attrs.getValue("length");
        String fileCount = attrs.getValue("fileCount");
        String directoryCount = attrs.getValue("directoryCount");
        String quota = attrs.getValue("quota");
        String spaceConsumed = attrs.getValue("spaceConsumed");
        String spaceQuota = attrs.getValue("spaceQuota");
        if (length == null || fileCount == null || directoryCount == null || quota == null || spaceConsumed == null || spaceQuota == null) {
            return null;
        }
        try {
            return new ContentSummary(Long.parseLong(length), Long.parseLong(fileCount), Long.parseLong(directoryCount), Long.parseLong(quota), Long.parseLong(spaceConsumed), Long.parseLong(spaceQuota));
        }
        catch (Exception e) {
            throw new SAXException("Invalid attributes: length=" + length + ", fileCount=" + fileCount + ", directoryCount=" + directoryCount + ", quota=" + quota + ", spaceConsumed=" + spaceConsumed + ", spaceQuota=" + spaceQuota, e);
        }
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        ContentSummary cs = new ContentSummaryParser().getContentSummary(s);
        return cs != null ? cs : super.getContentSummary(f);
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
        df = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return HftpFileSystem.getDateFormat();
            }
        };
        renewer = new RenewerThread();
        renewer.start();
    }

    private static class RenewerThread
    extends Thread {
        private DelayQueue<RenewAction> queue = new DelayQueue();
        private static final int RENEW_CYCLE = 82079999;

        public RenewerThread() {
            super("HFTP Delegation Token Renewer");
            this.setDaemon(true);
        }

        public void addTokenToRenew(HftpFileSystem fs) {
            this.queue.add(new RenewAction(82079999L + System.currentTimeMillis(), fs));
        }

        @Override
        public void run() {
            RenewAction action = null;
            while (true) {
                try {
                    while (true) {
                        if ((action = (RenewAction)this.queue.take()).renew()) {
                            action.setNewTime(82079999L + System.currentTimeMillis());
                            this.queue.add(action);
                        }
                        action = null;
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Exception ie) {
                    if (action != null) {
                        FileSystem.LOG.warn((Object)("Failure to renew token " + action), (Throwable)ie);
                        continue;
                    }
                    FileSystem.LOG.warn((Object)"Failure in renew queue", (Throwable)ie);
                    continue;
                }
                break;
            }
        }
    }

    private static class RenewAction
    implements Delayed {
        private long timestamp;
        private final WeakReference<HftpFileSystem> weakFs;

        RenewAction(long timestamp, HftpFileSystem fs) {
            this.timestamp = timestamp;
            this.weakFs = new WeakReference<HftpFileSystem>(fs);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long millisLeft = this.timestamp - System.currentTimeMillis();
            return unit.convert(millisLeft, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            if (o.getClass() != RenewAction.class) {
                throw new IllegalArgumentException("Illegal comparision to non-RenewAction");
            }
            RenewAction other = (RenewAction)o;
            return this.timestamp < other.timestamp ? -1 : (this.timestamp == other.timestamp ? 0 : 1);
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 33;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Delayed)) {
                return false;
            }
            return this.compareTo((Delayed)o) == 0;
        }

        public void setNewTime(long newTime) {
            this.timestamp = newTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean renew() throws IOException, InterruptedException {
            final HftpFileSystem fs = (HftpFileSystem)((Object)this.weakFs.get());
            if (fs != null) {
                HftpFileSystem hftpFileSystem = fs;
                synchronized (hftpFileSystem) {
                    fs.ugi.reloginFromKeytab();
                    fs.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            try {
                                DelegationTokenFetcher.renewDelegationToken(fs.nnHttpUrl, (Token<DelegationTokenIdentifier>)fs.delegationToken);
                            }
                            catch (IOException ie) {
                                try {
                                    fs.delegationToken = fs.getDelegationToken(null);
                                }
                                catch (IOException ie2) {
                                    throw new IOException("Can't renew or get new delegation token ", ie);
                                }
                            }
                            return null;
                        }
                    });
                }
            }
            return fs != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder result = new StringBuilder();
            HftpFileSystem fs = (HftpFileSystem)((Object)this.weakFs.get());
            if (fs == null) {
                return "evaporated token renew";
            }
            HftpFileSystem hftpFileSystem = fs;
            synchronized (hftpFileSystem) {
                result.append(fs.delegationToken);
            }
            result.append(" renew in ");
            result.append(this.getDelay(TimeUnit.SECONDS));
            result.append(" secs");
            return result.toString();
        }
    }

    private class ContentSummaryParser
    extends DefaultHandler {
        private ContentSummary contentsummary;

        private ContentSummaryParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!ContentSummary.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.contentsummary = HftpFileSystem.toContentSummary(attrs);
        }

        private ContentSummary getContentSummary(String path) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/contentSummary" + path, "ugi=" + HftpFileSystem.this.getUgiParameter());
            InputStream in = null;
            try {
                in = connection.getInputStream();
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(in));
            }
            catch (FileNotFoundException fnfe) {
                ContentSummary contentSummary = null;
                return contentSummary;
            }
            catch (SAXException saxe) {
                Exception embedded = saxe.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("Invalid xml format", saxe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                connection.disconnect();
            }
            return this.contentsummary;
        }
    }

    private class ChecksumParser
    extends DefaultHandler {
        private FileChecksum filechecksum;

        private ChecksumParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!MD5MD5CRC32FileChecksum.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.filechecksum = MD5MD5CRC32FileChecksum.valueOf((Attributes)attrs);
        }

        private FileChecksum getFileChecksum(String f) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/fileChecksum" + f, "ugi=" + HftpFileSystem.this.getUgiParameter());
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(connection.getInputStream()));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
            finally {
                connection.disconnect();
            }
            return this.filechecksum;
        }
    }

    class LsParser
    extends DefaultHandler {
        ArrayList<FileStatus> fslist = new ArrayList();

        LsParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            long modif;
            if ("listing".equals(qname)) {
                return;
            }
            if (!"file".equals(qname) && !"directory".equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            long atime = 0L;
            try {
                SimpleDateFormat ldf = df.get();
                modif = ldf.parse(attrs.getValue("modified")).getTime();
                String astr = attrs.getValue("accesstime");
                if (astr != null) {
                    atime = ldf.parse(astr).getTime();
                }
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            FileStatus fs = "file".equals(qname) ? new FileStatus(Long.valueOf(attrs.getValue("size")).longValue(), false, (int)Short.valueOf(attrs.getValue("replication")).shortValue(), Long.valueOf(attrs.getValue("blocksize")).longValue(), modif, atime, FsPermission.valueOf((String)attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), HftpFileSystem.this.makeQualified(new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")))) : new FileStatus(0L, true, 0, 0L, modif, atime, FsPermission.valueOf((String)attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), HftpFileSystem.this.makeQualified(new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path"))));
            this.fslist.add(fs);
        }

        private void fetchList(String path, boolean recur) throws IOException {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                HttpURLConnection connection = HftpFileSystem.this.openConnection("/listPaths" + path, "ugi=" + HftpFileSystem.this.getUgiParameter() + (recur ? "&recursive=yes" : ""));
                InputStream resp = connection.getInputStream();
                xr.parse(new InputSource(resp));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            this.fetchList(f.toUri().getPath(), false);
            if (this.fslist.size() == 0) {
                throw new FileNotFoundException("File does not exist: " + f);
            }
            return this.fslist.get(0);
        }

        public FileStatus[] listStatus(Path f, boolean recur) throws IOException {
            this.fetchList(f.toUri().getPath(), recur);
            if (this.fslist.size() > 0 && (this.fslist.size() != 1 || this.fslist.get(0).isDirectory())) {
                this.fslist.remove(0);
            }
            return this.fslist.toArray(new FileStatus[0]);
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return this.listStatus(f, false);
        }
    }
}

