/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.net.NodeBase;

@InterfaceAudience.Private
public class DFSUtil {
    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0 && element.indexOf("/") < 0) continue;
            return false;
        }
        return true;
    }

    public static String bytes2String(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static String byteArray2String(byte[][] pathComponents) {
        if (pathComponents.length == 0) {
            return "";
        }
        if (pathComponents.length == 1 && pathComponents[0].length == 0) {
            return "/";
        }
        try {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < pathComponents.length; ++i) {
                result.append(new String(pathComponents[i], "UTF-8"));
                if (i >= pathComponents.length - 1) continue;
                result.append('/');
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException ex) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[][] bytes2byteArray(byte[] bytes, byte separator) {
        return DFSUtil.bytes2byteArray(bytes, bytes.length, separator);
    }

    public static byte[][] bytes2byteArray(byte[] bytes, int len, byte separator) {
        assert (len <= bytes.length);
        int splits = 0;
        if (len == 0) {
            return new byte[][]{null};
        }
        for (int i = 0; i < len; ++i) {
            if (bytes[i] != separator) continue;
            ++splits;
        }
        int last = len - 1;
        while (last > -1 && bytes[last--] == separator) {
            --splits;
        }
        if (splits == 0 && bytes[0] == separator) {
            return new byte[][]{null};
        }
        byte[][] result = new byte[++splits][];
        int startIndex = 0;
        int nextIndex = 0;
        for (int index = 0; index < splits; ++index) {
            while (nextIndex < len && bytes[nextIndex] != separator) {
                ++nextIndex;
            }
            result[index] = new byte[nextIndex - startIndex];
            System.arraycopy(bytes, startIndex, result[index], 0, nextIndex - startIndex);
            nextIndex = startIndex = nextIndex + 1;
        }
        return result;
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.locatedBlockCount();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        if (nrBlocks == 0) {
            return blkLocations;
        }
        int idx = 0;
        for (LocatedBlock blk : blocks.getLocatedBlocks()) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] names = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                names[hCnt] = locations[hCnt].getName();
                NodeBase node = new NodeBase(names[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            blkLocations[idx] = new BlockLocation(names, hosts, racks, blk.getStartOffset(), blk.getBlockSize(), blk.isCorrupt());
            ++idx;
        }
        return blkLocations;
    }

    @InterfaceAudience.Private
    public static class ErrorSimulator {
        private static boolean[] simulation = null;

        public static void initializeErrorSimulationEvent(int numberOfEvents) {
            simulation = new boolean[numberOfEvents];
            for (int i = 0; i < numberOfEvents; ++i) {
                ErrorSimulator.simulation[i] = false;
            }
        }

        public static boolean getErrorSimulation(int index) {
            if (simulation == null) {
                return false;
            }
            assert (index < simulation.length);
            return simulation[index];
        }

        public static void setErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = true;
        }

        public static void clearErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = false;
        }
    }
}

