/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.SocketCache;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DFSInputStream
extends FSInputStream {
    private final SocketCache socketCache;
    private final DFSClient dfsClient;
    private boolean closed = false;
    private final String src;
    private long prefetchSize;
    private BlockReader blockReader = null;
    private boolean verifyChecksum;
    private LocatedBlocks locatedBlocks = null;
    private long lastBlockBeingWrittenLength = 0L;
    private DatanodeInfo currentNode = null;
    private Block currentBlock = null;
    private long pos = 0L;
    private long blockEnd = -1L;
    private int failures = 0;
    private int timeWindow = 3000;
    private ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap();
    private int buffersize = 1;
    private byte[] oneByteBuf = new byte[1];
    private int nCachedConnRetry;

    void addToDeadNodes(DatanodeInfo dnInfo) {
        this.deadNodes.put(dnInfo, dnInfo);
    }

    DFSInputStream(DFSClient dfsClient, String src, int buffersize, boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.dfsClient = dfsClient;
        this.verifyChecksum = verifyChecksum;
        this.buffersize = buffersize;
        this.src = src;
        this.socketCache = dfsClient.socketCache;
        this.prefetchSize = this.dfsClient.conf.getLong("dfs.client.read.prefetch.size", 10L * dfsClient.defaultBlockSize);
        this.timeWindow = this.dfsClient.conf.getInt("dfs.client.retry.window.base", this.timeWindow);
        this.nCachedConnRetry = this.dfsClient.conf.getInt("dfs.client.cached.conn.retry", 3);
        this.openInfo();
    }

    synchronized void openInfo() throws IOException, UnresolvedLinkException {
        LocatedBlock last;
        LocatedBlocks newInfo = DFSClient.callGetBlockLocations(this.dfsClient.namenode, this.src, 0L, this.prefetchSize);
        if (DFSClient.LOG.isDebugEnabled()) {
            DFSClient.LOG.debug((Object)("newInfo = " + newInfo));
        }
        if (newInfo == null) {
            throw new IOException("Cannot open filename " + this.src);
        }
        if (this.locatedBlocks != null) {
            Iterator<LocatedBlock> oldIter = this.locatedBlocks.getLocatedBlocks().iterator();
            Iterator<LocatedBlock> newIter = newInfo.getLocatedBlocks().iterator();
            while (oldIter.hasNext() && newIter.hasNext()) {
                if (oldIter.next().getBlock().equals(newIter.next().getBlock())) continue;
                throw new IOException("Blocklist for " + this.src + " has changed!");
            }
        }
        this.locatedBlocks = newInfo;
        this.lastBlockBeingWrittenLength = 0L;
        if (!this.locatedBlocks.isLastBlockComplete() && (last = this.locatedBlocks.getLastLocatedBlock()) != null) {
            long len = this.readBlockLength(last);
            last.getBlock().setNumBytes(len);
            this.lastBlockBeingWrittenLength = len;
        }
        this.currentNode = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readBlockLength(LocatedBlock locatedblock) throws IOException {
        if (locatedblock == null || locatedblock.getLocations().length == 0) {
            return 0L;
        }
        int replicaNotFoundCount = locatedblock.getLocations().length;
        for (DatanodeInfo datanode : locatedblock.getLocations()) {
            ClientDatanodeProtocol cdp;
            block10: {
                long l;
                block11: {
                    cdp = null;
                    try {
                        cdp = DFSClient.createClientDatanodeProtocolProxy(datanode, this.dfsClient.conf, this.dfsClient.socketTimeout, locatedblock);
                        long n = cdp.getReplicaVisibleLength(locatedblock.getBlock());
                        if (n < 0L) break block10;
                        l = n;
                        if (cdp == null) break block11;
                    }
                    catch (IOException ioe) {
                        try {
                            if (ioe instanceof RemoteException && ((RemoteException)((Object)ioe)).unwrapRemoteException() instanceof ReplicaNotFoundException) {
                                --replicaNotFoundCount;
                            }
                            if (DFSClient.LOG.isDebugEnabled()) {
                                DFSClient.LOG.debug((Object)("Failed to getReplicaVisibleLength from datanode " + datanode + " for block " + locatedblock.getBlock()), (Throwable)ioe);
                            }
                            if (cdp == null) continue;
                        }
                        catch (Throwable throwable) {
                            if (cdp != null) {
                                RPC.stopProxy(cdp);
                            }
                            throw throwable;
                        }
                        RPC.stopProxy((Object)cdp);
                        continue;
                    }
                    RPC.stopProxy((Object)cdp);
                }
                return l;
            }
            if (cdp == null) continue;
            RPC.stopProxy((Object)cdp);
        }
        if (replicaNotFoundCount == 0) {
            return 0L;
        }
        throw new IOException("Cannot obtain block length for " + locatedblock);
    }

    public synchronized long getFileLength() {
        return this.locatedBlocks == null ? 0L : this.locatedBlocks.getFileLength() + this.lastBlockBeingWrittenLength;
    }

    public DatanodeInfo getCurrentDatanode() {
        return this.currentNode;
    }

    public Block getCurrentBlock() {
        return this.currentBlock;
    }

    synchronized List<LocatedBlock> getAllBlocks() throws IOException {
        return this.getBlockRange(0L, this.getFileLength());
    }

    private synchronized LocatedBlock getBlockAt(long offset, boolean updatePosition) throws IOException {
        LocatedBlock blk;
        assert (this.locatedBlocks != null) : "locatedBlocks is null";
        if (offset < 0L || offset >= this.getFileLength()) {
            throw new IOException("offset < 0 || offset > getFileLength(), offset=" + offset + ", updatePosition=" + updatePosition + ", locatedBlocks=" + this.locatedBlocks);
        }
        if (offset >= this.locatedBlocks.getFileLength()) {
            blk = this.locatedBlocks.getLastLocatedBlock();
        } else {
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
                LocatedBlocks newBlocks = DFSClient.callGetBlockLocations(this.dfsClient.namenode, this.src, offset, this.prefetchSize);
                assert (newBlocks != null) : "Could not find target position " + offset;
                this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
            }
            blk = this.locatedBlocks.get(targetBlockIdx);
        }
        if (updatePosition) {
            this.pos = offset;
            this.blockEnd = blk.getStartOffset() + blk.getBlockSize() - 1L;
            this.currentBlock = blk.getBlock();
        }
        return blk;
    }

    private synchronized void fetchBlockAt(long offset) throws IOException {
        LocatedBlocks newBlocks;
        int targetBlockIdx = this.locatedBlocks.findBlock(offset);
        if (targetBlockIdx < 0) {
            targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
        }
        if ((newBlocks = DFSClient.callGetBlockLocations(this.dfsClient.namenode, this.src, offset, this.prefetchSize)) == null) {
            throw new IOException("Could not find target position " + offset);
        }
        this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
    }

    private synchronized List<LocatedBlock> getBlockRange(long offset, long length) throws IOException {
        List<LocatedBlock> blocks;
        if (this.locatedBlocks.isLastBlockComplete()) {
            blocks = this.getFinalizedBlockRange(offset, length);
        } else {
            if (length + offset > this.locatedBlocks.getFileLength()) {
                length = this.locatedBlocks.getFileLength() - offset;
            }
            blocks = this.getFinalizedBlockRange(offset, length);
            blocks.add(this.locatedBlocks.getLastLocatedBlock());
        }
        return blocks;
    }

    private synchronized List<LocatedBlock> getFinalizedBlockRange(long offset, long length) throws IOException {
        assert (this.locatedBlocks != null) : "locatedBlocks is null";
        ArrayList<LocatedBlock> blockRange = new ArrayList<LocatedBlock>();
        int blockIdx = this.locatedBlocks.findBlock(offset);
        if (blockIdx < 0) {
            blockIdx = LocatedBlocks.getInsertIndex(blockIdx);
        }
        long remaining = length;
        long curOff = offset;
        while (remaining > 0L) {
            LocatedBlock blk = null;
            if (blockIdx < this.locatedBlocks.locatedBlockCount()) {
                blk = this.locatedBlocks.get(blockIdx);
            }
            if (blk == null || curOff < blk.getStartOffset()) {
                LocatedBlocks newBlocks = DFSClient.callGetBlockLocations(this.dfsClient.namenode, this.src, curOff, remaining);
                this.locatedBlocks.insertRange(blockIdx, newBlocks.getLocatedBlocks());
                continue;
            }
            assert (curOff >= blk.getStartOffset()) : "Block not found";
            blockRange.add(blk);
            long bytesRead = blk.getStartOffset() + blk.getBlockSize() - curOff;
            remaining -= bytesRead;
            curOff += bytesRead;
            ++blockIdx;
        }
        return blockRange;
    }

    private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
        if (target >= this.getFileLength()) {
            throw new IOException("Attempted to read past end of file");
        }
        if (this.blockReader != null) {
            this.closeBlockReader(this.blockReader);
            this.blockReader = null;
        }
        DatanodeInfo chosenNode = null;
        int refetchToken = 1;
        while (true) {
            LocatedBlock targetBlock = this.getBlockAt(target, true);
            assert (target == this.pos) : "Wrong postion " + this.pos + " expect " + target;
            long offsetIntoBlock = target - targetBlock.getStartOffset();
            DNAddrPair retval = this.chooseDataNode(targetBlock);
            chosenNode = retval.info;
            InetSocketAddress targetAddr = retval.addr;
            try {
                Block blk = targetBlock.getBlock();
                Token<BlockTokenIdentifier> accessToken = targetBlock.getBlockToken();
                this.blockReader = this.getBlockReader(targetAddr, this.src, blk, accessToken, offsetIntoBlock, blk.getNumBytes() - offsetIntoBlock, this.buffersize, this.verifyChecksum, this.dfsClient.clientName);
                return chosenNode;
            }
            catch (IOException ex) {
                if (ex instanceof InvalidBlockTokenException && refetchToken > 0) {
                    DFSClient.LOG.info((Object)("Will fetch a new access token and retry, access token was invalid when connecting to " + targetAddr + " : " + ex));
                    --refetchToken;
                    this.fetchBlockAt(target);
                    continue;
                }
                DFSClient.LOG.info((Object)("Failed to connect to " + targetAddr + ", add to deadNodes and continue"), (Throwable)ex);
                this.addToDeadNodes(chosenNode);
                continue;
            }
            break;
        }
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.dfsClient.checkOpen();
        if (this.blockReader != null) {
            this.closeBlockReader(this.blockReader);
            this.blockReader = null;
        }
        super.close();
        this.closed = true;
    }

    public synchronized int read() throws IOException {
        int ret = this.read(this.oneByteBuf, 0, 1);
        return ret <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    private synchronized int readBuffer(byte[] buf, int off, int len) throws IOException {
        boolean retryCurrentNode = true;
        while (true) {
            Throwable ioe;
            try {
                return this.blockReader.read(buf, off, len);
            }
            catch (ChecksumException ce) {
                DFSClient.LOG.warn((Object)("Found Checksum error for " + this.currentBlock + " from " + this.currentNode.getName() + " at " + ce.getPos()));
                this.dfsClient.reportChecksumFailure(this.src, this.currentBlock, this.currentNode);
                ioe = ce;
                retryCurrentNode = false;
            }
            catch (IOException e) {
                if (!retryCurrentNode) {
                    DFSClient.LOG.warn((Object)("Exception while reading from " + this.currentBlock + " of " + this.src + " from " + this.currentNode + ": " + StringUtils.stringifyException((Throwable)e)));
                }
                ioe = e;
            }
            boolean sourceFound = false;
            if (retryCurrentNode) {
                sourceFound = this.seekToBlockSource(this.pos);
            } else {
                this.addToDeadNodes(this.currentNode);
                sourceFound = this.seekToNewSource(this.pos);
            }
            if (!sourceFound) {
                throw ioe;
            }
            retryCurrentNode = false;
        }
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.failures = 0;
        if (this.pos < this.getFileLength()) {
            int retries = 2;
            while (retries > 0) {
                try {
                    int realLen;
                    int result;
                    if (this.pos > this.blockEnd) {
                        this.currentNode = this.blockSeekTo(this.pos);
                    }
                    if ((result = this.readBuffer(buf, off, realLen = (int)Math.min((long)len, this.blockEnd - this.pos + 1L))) >= 0) {
                        this.pos += (long)result;
                    } else {
                        throw new IOException("Unexpected EOS from the reader");
                    }
                    if (this.dfsClient.stats != null && result != -1) {
                        this.dfsClient.stats.incrementBytesRead((long)result);
                    }
                    return result;
                }
                catch (ChecksumException ce) {
                    throw ce;
                }
                catch (IOException e) {
                    if (retries == 1) {
                        DFSClient.LOG.warn((Object)("DFS Read: " + StringUtils.stringifyException((Throwable)e)));
                    }
                    this.blockEnd = -1L;
                    if (this.currentNode != null) {
                        this.addToDeadNodes(this.currentNode);
                    }
                    if (--retries != 0) continue;
                    throw e;
                }
            }
        }
        return -1;
    }

    private DNAddrPair chooseDataNode(LocatedBlock block) throws IOException {
        while (true) {
            DatanodeInfo[] nodes = block.getLocations();
            try {
                DatanodeInfo chosenNode = DFSInputStream.bestNode(nodes, this.deadNodes);
                InetSocketAddress targetAddr = NetUtils.createSocketAddr((String)chosenNode.getName());
                return new DNAddrPair(chosenNode, targetAddr);
            }
            catch (IOException ie) {
                String blockInfo = block.getBlock() + " file=" + this.src;
                if (this.failures >= this.dfsClient.getMaxBlockAcquireFailures()) {
                    throw new BlockMissingException(this.src, "Could not obtain block: " + blockInfo, block.getStartOffset());
                }
                if (nodes == null || nodes.length == 0) {
                    DFSClient.LOG.info((Object)("No node available for block: " + blockInfo));
                }
                DFSClient.LOG.info((Object)("Could not obtain block " + block.getBlock() + " from any node: " + ie + ". Will get new block locations from namenode and retry..."));
                try {
                    double waitTime = (double)(this.timeWindow * this.failures) + (double)(this.timeWindow * (this.failures + 1)) * this.dfsClient.r.nextDouble();
                    DFSClient.LOG.warn((Object)("DFS chooseDataNode: got # " + (this.failures + 1) + " IOException, will wait for " + waitTime + " msec."));
                    Thread.sleep((long)waitTime);
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
                this.deadNodes.clear();
                this.openInfo();
                block = this.getBlockAt(block.getStartOffset(), false);
                ++this.failures;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset) throws IOException {
        refetchToken = 1;
        while (true) {
            block12: {
                block = this.getBlockAt(block.getStartOffset(), false);
                retval = this.chooseDataNode(block);
                chosenNode = retval.info;
                targetAddr = retval.addr;
                reader = null;
                try {
                    blockToken = block.getBlockToken();
                    len = (int)(end - start + 1L);
                    reader = this.getBlockReader(targetAddr, this.src, block.getBlock(), blockToken, start, len, this.buffersize, this.verifyChecksum, this.dfsClient.clientName);
                    nread = reader.readAll(buf, offset, len);
                    if (nread != len) {
                        throw new IOException("truncated return from reader.read(): excpected " + len + ", got " + nread);
                    }
                    if (reader == null) break block12;
                }
                catch (ChecksumException e) {
                    DFSClient.LOG.warn((Object)("fetchBlockByteRange(). Got a checksum exception for " + this.src + " at " + block.getBlock() + ":" + e.getPos() + " from " + chosenNode.getName()));
                    this.dfsClient.reportChecksumFailure(this.src, block.getBlock(), chosenNode);
                    ** if (reader == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        this.closeBlockReader(reader);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (IOException e) {
                    block13: {
                        if (!(e instanceof InvalidBlockTokenException) || refetchToken <= 0) break block13;
                        DFSClient.LOG.info((Object)("Will get a new access token and retry, access token was invalid when connecting to " + targetAddr + " : " + e));
                        --refetchToken;
                        this.fetchBlockAt(block.getStartOffset());
                        if (reader == null) continue;
                        {
                            catch (Throwable var16_16) {
                                if (reader != null) {
                                    this.closeBlockReader(reader);
                                }
                                throw var16_16;
                            }
                        }
                        this.closeBlockReader(reader);
                        continue;
                    }
                    DFSClient.LOG.warn((Object)("Failed to connect to " + targetAddr + " for file " + this.src + " for block " + block.getBlock() + ":" + StringUtils.stringifyException((Throwable)e)));
                    ** if (reader == null) goto lbl45
lbl-1000:
                    // 1 sources

                    {
                        this.closeBlockReader(reader);
                    }
                    {
                    }
                }
                this.closeBlockReader(reader);
            }
            return;
lbl45:
            // 3 sources

            this.addToDeadNodes(chosenNode);
        }
    }

    private void closeBlockReader(BlockReader reader) throws IOException {
        if (reader.hasSentStatusCode()) {
            Socket oldSock = reader.takeSocket();
            this.socketCache.put(oldSock);
        }
        reader.close();
    }

    protected BlockReader getBlockReader(InetSocketAddress dnAddr, String file, Block block, Token<BlockTokenIdentifier> blockToken, long startOffset, long len, int bufferSize, boolean verifyChecksum, String clientName) throws IOException {
        IOException err = null;
        boolean fromCache = true;
        for (int retries = 0; retries <= this.nCachedConnRetry && fromCache; ++retries) {
            Socket sock = this.socketCache.get(dnAddr);
            if (sock == null) {
                fromCache = false;
                sock = this.dfsClient.socketFactory.createSocket();
                sock.setTcpNoDelay(true);
                NetUtils.connect((Socket)sock, (SocketAddress)dnAddr, (int)this.dfsClient.socketTimeout);
                sock.setSoTimeout(this.dfsClient.socketTimeout);
            }
            try {
                BlockReader reader = BlockReader.newBlockReader(sock, file, block, blockToken, startOffset, len, bufferSize, verifyChecksum, clientName);
                return reader;
            }
            catch (IOException ex) {
                DFSClient.LOG.debug((Object)("Error making BlockReader. Closing stale " + sock), (Throwable)ex);
                sock.close();
                err = ex;
                continue;
            }
        }
        throw err;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.failures = 0;
        long filelen = this.getFileLength();
        if (position < 0L || position >= filelen) {
            return -1;
        }
        int realLen = length;
        if (position + (long)length > filelen) {
            realLen = (int)(filelen - position);
        }
        List<LocatedBlock> blockRange = this.getBlockRange(position, realLen);
        int remaining = realLen;
        for (LocatedBlock blk : blockRange) {
            long targetStart = position - blk.getStartOffset();
            long bytesToRead = Math.min((long)remaining, blk.getBlockSize() - targetStart);
            this.fetchBlockByteRange(blk, targetStart, targetStart + bytesToRead - 1L, buffer, offset);
            remaining = (int)((long)remaining - bytesToRead);
            position += bytesToRead;
            offset = (int)((long)offset + bytesToRead);
        }
        assert (remaining == 0) : "Wrong number of bytes read.";
        if (this.dfsClient.stats != null) {
            this.dfsClient.stats.incrementBytesRead((long)realLen);
        }
        return realLen;
    }

    public long skip(long n) throws IOException {
        if (n > 0L) {
            long fileLen;
            long curPos = this.getPos();
            if (n + curPos > (fileLen = this.getFileLength())) {
                n = fileLen - curPos;
            }
            this.seek(curPos + n);
            return n;
        }
        return n < 0L ? -1L : 0L;
    }

    public synchronized void seek(long targetPos) throws IOException {
        boolean done;
        block7: {
            int diff;
            if (targetPos > this.getFileLength()) {
                throw new IOException("Cannot seek after EOF");
            }
            if (this.closed) {
                throw new IOException("Stream is closed!");
            }
            done = false;
            if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= 131072) {
                try {
                    this.pos += this.blockReader.skip(diff);
                    if (this.pos == targetPos) {
                        done = true;
                    }
                }
                catch (IOException e) {
                    if (!DFSClient.LOG.isDebugEnabled()) break block7;
                    DFSClient.LOG.debug((Object)("Exception while seek to " + targetPos + " from " + this.currentBlock + " of " + this.src + " from " + this.currentNode + ": " + StringUtils.stringifyException((Throwable)e)));
                }
            }
        }
        if (!done) {
            this.pos = targetPos;
            this.blockEnd = -1L;
        }
    }

    private synchronized boolean seekToBlockSource(long targetPos) throws IOException {
        this.currentNode = this.blockSeekTo(targetPos);
        return true;
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        boolean markedDead = this.deadNodes.containsKey(this.currentNode);
        this.addToDeadNodes(this.currentNode);
        DatanodeInfo oldNode = this.currentNode;
        DatanodeInfo newNode = this.blockSeekTo(targetPos);
        if (!markedDead) {
            this.deadNodes.remove(oldNode);
        }
        if (!oldNode.getStorageID().equals(newNode.getStorageID())) {
            this.currentNode = newNode;
            return true;
        }
        return false;
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        long remaining = this.getFileLength() - this.pos;
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    static DatanodeInfo bestNode(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes) throws IOException {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (deadNodes.containsKey(nodes[i])) continue;
                return nodes[i];
            }
        }
        throw new IOException("No live nodes contain current block");
    }

    static class DNAddrPair {
        DatanodeInfo info;
        InetSocketAddress addr;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr) {
            this.info = info;
            this.addr = addr;
        }
    }
}

