/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.runtime.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.state.api.StateBootstrapTransformation;
import org.apache.flink.state.api.runtime.OperatorIDGenerator;
import org.apache.flink.state.api.runtime.StateBootstrapTransformationWithID;
import org.apache.flink.state.api.runtime.metadata.OperatorStateSpecV2;
import org.apache.flink.util.Preconditions;

@Internal
public class SavepointMetadataV2 {
    private final int maxParallelism;
    private final Collection<MasterState> masterStates;
    private final Map<OperatorID, OperatorStateSpecV2> operatorStateIndex;

    public SavepointMetadataV2(int maxParallelism, Collection<MasterState> masterStates, Collection<OperatorState> initialStates) {
        Preconditions.checkArgument((maxParallelism > 0 && maxParallelism <= 32768 ? 1 : 0) != 0, (Object)("Maximum parallelism must be between 1 and 32768. Found: " + maxParallelism));
        Preconditions.checkNotNull(masterStates);
        this.maxParallelism = maxParallelism;
        this.masterStates = new ArrayList<MasterState>(masterStates);
        this.operatorStateIndex = new HashMap<OperatorID, OperatorStateSpecV2>(initialStates.size());
        initialStates.forEach(existingState -> this.operatorStateIndex.put(existingState.getOperatorID(), OperatorStateSpecV2.existing(existingState)));
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public Collection<MasterState> getMasterStates() {
        return this.masterStates;
    }

    public OperatorState getOperatorState(String uid) throws IOException {
        OperatorID operatorID = OperatorIDGenerator.fromUid(uid);
        OperatorStateSpecV2 operatorState = this.operatorStateIndex.get(operatorID);
        if (operatorState == null || operatorState.isNewStateTransformation()) {
            throw new IOException("Savepoint does not contain state with operator uid " + uid);
        }
        return operatorState.asExistingState();
    }

    public void removeOperator(String uid) {
        this.operatorStateIndex.remove(OperatorIDGenerator.fromUid(uid));
    }

    public void addOperator(String uid, StateBootstrapTransformation<?> transformation) {
        OperatorID id = OperatorIDGenerator.fromUid(uid);
        if (this.operatorStateIndex.containsKey(id)) {
            throw new IllegalArgumentException("The savepoint already contains uid " + uid + ". All uid's must be unique");
        }
        this.operatorStateIndex.put(id, OperatorStateSpecV2.newWithTransformation(new StateBootstrapTransformationWithID(id, transformation)));
    }

    public List<OperatorState> getExistingOperators() {
        return this.operatorStateIndex.values().stream().filter(OperatorStateSpecV2::isExistingState).map(OperatorStateSpecV2::asExistingState).collect(Collectors.toList());
    }

    public List<StateBootstrapTransformationWithID<?>> getNewOperators() {
        return this.operatorStateIndex.values().stream().filter(OperatorStateSpecV2::isNewStateTransformation).map(OperatorStateSpecV2::asNewStateTransformation).collect(Collectors.toList());
    }
}

