/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.state.api.ExistingSavepoint;
import org.apache.flink.state.api.NewSavepoint;
import org.apache.flink.state.api.runtime.SavepointLoader;
import org.apache.flink.state.api.runtime.metadata.SavepointMetadata;
import org.apache.flink.util.Preconditions;

@Deprecated
@PublicEvolving
public final class Savepoint {
    private Savepoint() {
    }

    public static ExistingSavepoint load(ExecutionEnvironment env, String path) throws IOException {
        CheckpointMetadata metadata = SavepointLoader.loadSavepointMetadata(path);
        int maxParallelism = metadata.getOperatorStates().stream().map(OperatorState::getMaxParallelism).max(Comparator.naturalOrder()).orElseThrow(() -> new RuntimeException("Savepoint must contain at least one operator state."));
        SavepointMetadata savepointMetadata = new SavepointMetadata(maxParallelism, metadata.getMasterStates(), metadata.getOperatorStates());
        return new ExistingSavepoint(env, savepointMetadata, null);
    }

    public static ExistingSavepoint load(ExecutionEnvironment env, String path, StateBackend stateBackend) throws IOException {
        Preconditions.checkNotNull((Object)stateBackend, (String)"The state backend must not be null");
        CheckpointMetadata metadata = SavepointLoader.loadSavepointMetadata(path);
        int maxParallelism = metadata.getOperatorStates().stream().map(OperatorState::getMaxParallelism).max(Comparator.naturalOrder()).orElseThrow(() -> new RuntimeException("Savepoint must contain at least one operator state."));
        SavepointMetadata savepointMetadata = new SavepointMetadata(maxParallelism, metadata.getMasterStates(), metadata.getOperatorStates());
        return new ExistingSavepoint(env, savepointMetadata, stateBackend);
    }

    public static NewSavepoint create(int maxParallelism) {
        Preconditions.checkArgument((maxParallelism > 0 && maxParallelism <= 32768 ? 1 : 0) != 0, (Object)("Maximum parallelism must be between 1 and 32768. Found: " + maxParallelism));
        SavepointMetadata metadata = new SavepointMetadata(maxParallelism, Collections.emptyList(), Collections.emptyList());
        return new NewSavepoint(metadata, null);
    }

    public static NewSavepoint create(StateBackend stateBackend, int maxParallelism) {
        Preconditions.checkNotNull((Object)stateBackend, (String)"The state backend must not be null");
        Preconditions.checkArgument((maxParallelism > 0 && maxParallelism <= 32768 ? 1 : 0) != 0, (Object)("Maximum parallelism must be between 1 and 32768. Found: " + maxParallelism));
        SavepointMetadata metadata = new SavepointMetadata(maxParallelism, Collections.emptyList(), Collections.emptyList());
        return new NewSavepoint(metadata, stateBackend);
    }
}

