/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.ClientId;
import org.apache.hadoop.ipc.RpcConstants;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.util.LightWeightCache;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class RetryCache {
    public static final Log LOG = LogFactory.getLog(RetryCache.class);
    private final LightWeightGSet<CacheEntry, CacheEntry> set;
    private final long expirationTime;

    public RetryCache(String cacheName, double percentage, long expirationTime) {
        int capacity = LightWeightGSet.computeCapacity(percentage, cacheName);
        capacity = capacity > 16 ? capacity : 16;
        this.set = new LightWeightCache<CacheEntry, CacheEntry>(capacity, capacity, expirationTime, 0L);
        this.expirationTime = expirationTime;
    }

    private static boolean skipRetryCache() {
        return !Server.isRpcInvocation() || Server.getCallId() < 0 || Arrays.equals(Server.getClientId(), RpcConstants.DUMMY_CLIENT_ID);
    }

    @VisibleForTesting
    public LightWeightGSet<CacheEntry, CacheEntry> getCacheSet() {
        return this.set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry waitForCompletion(CacheEntry newEntry) {
        CacheEntry mapEntry = null;
        Object object = this;
        synchronized (object) {
            mapEntry = this.set.get(newEntry);
            if (mapEntry == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Adding Rpc request clientId " + newEntry.clientIdMsb + newEntry.clientIdLsb + " callId " + newEntry.callId + " to retryCache"));
                }
                this.set.put(newEntry);
                return newEntry;
            }
        }
        Preconditions.checkNotNull(mapEntry, "Entry from the cache should not be null");
        object = mapEntry;
        synchronized (object) {
            while (mapEntry.state == CacheEntry.INPROGRESS) {
                try {
                    mapEntry.wait();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            if (mapEntry.state != CacheEntry.SUCCESS) {
                mapEntry.state = CacheEntry.INPROGRESS;
            }
        }
        return mapEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheEntry(byte[] clientId, int callId) {
        CacheEntry newEntry = new CacheEntry(clientId, callId, System.nanoTime() + this.expirationTime, true);
        RetryCache retryCache = this;
        synchronized (retryCache) {
            this.set.put(newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheEntryWithPayload(byte[] clientId, int callId, Object payload) {
        CacheEntryWithPayload newEntry = new CacheEntryWithPayload(clientId, callId, payload, System.nanoTime() + this.expirationTime, true);
        RetryCache retryCache = this;
        synchronized (retryCache) {
            this.set.put(newEntry);
        }
    }

    private static CacheEntry newEntry(long expirationTime) {
        return new CacheEntry(Server.getClientId(), Server.getCallId(), System.nanoTime() + expirationTime);
    }

    private static CacheEntryWithPayload newEntry(Object payload, long expirationTime) {
        return new CacheEntryWithPayload(Server.getClientId(), Server.getCallId(), payload, System.nanoTime() + expirationTime);
    }

    public static CacheEntry waitForCompletion(RetryCache cache) {
        if (RetryCache.skipRetryCache()) {
            return null;
        }
        return cache != null ? cache.waitForCompletion(RetryCache.newEntry(cache.expirationTime)) : null;
    }

    public static CacheEntryWithPayload waitForCompletion(RetryCache cache, Object payload) {
        if (RetryCache.skipRetryCache()) {
            return null;
        }
        return (CacheEntryWithPayload)(cache != null ? cache.waitForCompletion(RetryCache.newEntry(payload, cache.expirationTime)) : null);
    }

    public static void setState(CacheEntry e, boolean success) {
        if (e == null) {
            return;
        }
        e.completed(success);
    }

    public static void setState(CacheEntryWithPayload e, boolean success, Object payload) {
        if (e == null) {
            return;
        }
        e.payload = payload;
        e.completed(success);
    }

    public static void clear(RetryCache cache) {
        if (cache != null) {
            cache.set.clear();
        }
    }

    public static class CacheEntryWithPayload
    extends CacheEntry {
        private Object payload;

        CacheEntryWithPayload(byte[] clientId, int callId, Object payload, long expirationTime) {
            super(clientId, callId, expirationTime);
            this.payload = payload;
        }

        CacheEntryWithPayload(byte[] clientId, int callId, Object payload, long expirationTime, boolean success) {
            super(clientId, callId, expirationTime, success);
            this.payload = payload;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        public Object getPayload() {
            return this.payload;
        }
    }

    public static class CacheEntry
    implements LightWeightCache.Entry {
        private static byte INPROGRESS = 0;
        private static byte SUCCESS = 1;
        private static byte FAILED = (byte)2;
        private byte state = INPROGRESS;
        private final long clientIdMsb;
        private final long clientIdLsb;
        private final int callId;
        private final long expirationTime;
        private LightWeightGSet.LinkedElement next;

        CacheEntry(byte[] clientId, int callId, long expirationTime) {
            Preconditions.checkArgument(clientId.length == 16, "Invalid clientId - length is " + clientId.length + " expected length " + 16);
            this.clientIdMsb = ClientId.getMsb(clientId);
            this.clientIdLsb = ClientId.getLsb(clientId);
            this.callId = callId;
            this.expirationTime = expirationTime;
        }

        CacheEntry(byte[] clientId, int callId, long expirationTime, boolean success) {
            this(clientId, callId, expirationTime);
            this.state = success ? SUCCESS : FAILED;
        }

        private static int hashCode(long value) {
            return (int)(value ^ value >>> 32);
        }

        public int hashCode() {
            return (CacheEntry.hashCode(this.clientIdMsb) * 31 + CacheEntry.hashCode(this.clientIdLsb)) * 31 + this.callId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheEntry)) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            return this.callId == other.callId && this.clientIdMsb == other.clientIdMsb && this.clientIdLsb == other.clientIdLsb;
        }

        @Override
        public void setNext(LightWeightGSet.LinkedElement next) {
            this.next = next;
        }

        @Override
        public LightWeightGSet.LinkedElement getNext() {
            return this.next;
        }

        synchronized void completed(boolean success) {
            this.state = success ? SUCCESS : FAILED;
            this.notifyAll();
        }

        public synchronized boolean isSuccess() {
            return this.state == SUCCESS;
        }

        @Override
        public void setExpirationTime(long timeNano) {
        }

        @Override
        public long getExpirationTime() {
            return this.expirationTime;
        }

        public String toString() {
            return new UUID(this.clientIdMsb, this.clientIdLsb).toString() + ":" + this.callId + ":" + this.state;
        }
    }
}

