/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.flink.hadoop.shaded.com.google.common.io.Files;
import org.apache.flink.hadoop.shaded.com.google.common.primitives.Longs;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class BestEffortLongFile
implements Closeable {
    private final File file;
    private final long defaultVal;
    private long value;
    private FileChannel ch = null;
    private ByteBuffer buf = ByteBuffer.allocate(8);

    public BestEffortLongFile(File file, long defaultVal) {
        this.file = file;
        this.defaultVal = defaultVal;
    }

    public long get() throws IOException {
        this.lazyOpen();
        return this.value;
    }

    public void set(long newVal) throws IOException {
        this.lazyOpen();
        this.buf.clear();
        this.buf.putLong(newVal);
        this.buf.flip();
        IOUtils.writeFully(this.ch, this.buf, 0L);
        this.value = newVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyOpen() throws IOException {
        if (this.ch != null) {
            return;
        }
        byte[] data = null;
        try {
            data = Files.toByteArray(this.file);
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        if (data != null && data.length != 0) {
            if (data.length != 8) {
                throw new IOException("File " + this.file + " had invalid length: " + data.length);
            }
            this.value = Longs.fromByteArray(data);
        } else {
            this.value = this.defaultVal;
        }
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        try {
            this.ch = raf.getChannel();
        }
        finally {
            if (this.ch == null) {
                IOUtils.closeStream(raf);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.ch != null) {
            this.ch.close();
        }
    }
}

