/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class BlockInfo
extends Block
implements LightWeightGSet.LinkedElement {
    public static final BlockInfo[] EMPTY_ARRAY = new BlockInfo[0];
    private BlockCollection bc;
    private LightWeightGSet.LinkedElement nextLinkedElement;
    private Object[] triplets;

    public BlockInfo(int replication) {
        this.triplets = new Object[3 * replication];
        this.bc = null;
    }

    public BlockInfo(Block blk, int replication) {
        super(blk);
        this.triplets = new Object[3 * replication];
        this.bc = null;
    }

    protected BlockInfo(BlockInfo from) {
        this(from, from.bc.getBlockReplication());
        this.bc = from.bc;
    }

    public BlockCollection getBlockCollection() {
        return this.bc;
    }

    public void setBlockCollection(BlockCollection bc) {
        this.bc = bc;
    }

    public DatanodeDescriptor getDatanode(int index) {
        DatanodeStorageInfo storage = this.getStorageInfo(index);
        return storage == null ? null : storage.getDatanodeDescriptor();
    }

    DatanodeStorageInfo getStorageInfo(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 < this.triplets.length) : "Index is out of bound";
        return (DatanodeStorageInfo)this.triplets[index * 3];
    }

    private BlockInfo getPrevious(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 1 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)this.triplets[index * 3 + 1];
        assert (info == null || info.getClass().getName().startsWith(BlockInfo.class.getName())) : "BlockInfo is expected at " + index * 3;
        return info;
    }

    BlockInfo getNext(int index) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 2 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)this.triplets[index * 3 + 2];
        assert (info == null || info.getClass().getName().startsWith(BlockInfo.class.getName())) : "BlockInfo is expected at " + index * 3;
        return info;
    }

    private void setStorageInfo(int index, DatanodeStorageInfo storage) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 < this.triplets.length) : "Index is out of bound";
        this.triplets[index * 3] = storage;
    }

    private BlockInfo setPrevious(int index, BlockInfo to) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 1 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)this.triplets[index * 3 + 1];
        this.triplets[index * 3 + 1] = to;
        return info;
    }

    private BlockInfo setNext(int index, BlockInfo to) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (index >= 0 && index * 3 + 2 < this.triplets.length) : "Index is out of bound";
        BlockInfo info = (BlockInfo)this.triplets[index * 3 + 2];
        this.triplets[index * 3 + 2] = to;
        return info;
    }

    public int getCapacity() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        return this.triplets.length / 3;
    }

    private int ensureCapacity(int num) {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        int last = this.numNodes();
        if (this.triplets.length >= (last + num) * 3) {
            return last;
        }
        Object[] old = this.triplets;
        this.triplets = new Object[(last + num) * 3];
        System.arraycopy(old, 0, this.triplets, 0, last * 3);
        return last;
    }

    public int numNodes() {
        assert (this.triplets != null) : "BlockInfo is not initialized";
        assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
        for (int idx = this.getCapacity() - 1; idx >= 0; --idx) {
            if (this.getDatanode(idx) == null) continue;
            return idx + 1;
        }
        return 0;
    }

    boolean addStorage(DatanodeStorageInfo storage) {
        boolean added = true;
        int idx = this.findDatanode(storage.getDatanodeDescriptor());
        if (idx >= 0) {
            if (this.getStorageInfo(idx) == storage) {
                return false;
            }
            this.removeStorage(storage);
            added = false;
        }
        int lastNode = this.ensureCapacity(1);
        this.setStorageInfo(lastNode, storage);
        this.setNext(lastNode, null);
        this.setPrevious(lastNode, null);
        return added;
    }

    boolean removeStorage(DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfo(storage);
        if (dnIndex < 0) {
            return false;
        }
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is still in the list and must be removed first.";
        int lastNode = this.numNodes() - 1;
        this.setStorageInfo(dnIndex, this.getStorageInfo(lastNode));
        this.setNext(dnIndex, this.getNext(lastNode));
        this.setPrevious(dnIndex, this.getPrevious(lastNode));
        this.setStorageInfo(lastNode, null);
        this.setNext(lastNode, null);
        this.setPrevious(lastNode, null);
        return true;
    }

    int findDatanode(DatanodeDescriptor dn) {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeDescriptor cur = this.getDatanode(idx);
            if (cur == dn) {
                return idx;
            }
            if (cur == null) break;
        }
        return -1;
    }

    int findStorageInfo(DatanodeInfo dn) {
        DatanodeStorageInfo cur;
        int len = this.getCapacity();
        for (int idx = 0; idx < len && (cur = this.getStorageInfo(idx)) != null; ++idx) {
            if (cur.getDatanodeDescriptor() != dn) continue;
            return idx;
        }
        return -1;
    }

    int findStorageInfo(DatanodeStorageInfo storageInfo) {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeStorageInfo cur = this.getStorageInfo(idx);
            if (cur == storageInfo) {
                return idx;
            }
            if (cur == null) break;
        }
        return -1;
    }

    BlockInfo listInsert(BlockInfo head, DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfo(storage);
        assert (dnIndex >= 0) : "Data node is not found: current";
        assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is already in the list and cannot be inserted.";
        this.setPrevious(dnIndex, null);
        this.setNext(dnIndex, head);
        if (head != null) {
            head.setPrevious(head.findStorageInfo(storage), this);
        }
        return this;
    }

    BlockInfo listRemove(BlockInfo head, DatanodeStorageInfo storage) {
        if (head == null) {
            return null;
        }
        int dnIndex = this.findStorageInfo(storage);
        if (dnIndex < 0) {
            return head;
        }
        BlockInfo next = this.getNext(dnIndex);
        BlockInfo prev = this.getPrevious(dnIndex);
        this.setNext(dnIndex, null);
        this.setPrevious(dnIndex, null);
        if (prev != null) {
            prev.setNext(prev.findStorageInfo(storage), next);
        }
        if (next != null) {
            next.setPrevious(next.findStorageInfo(storage), prev);
        }
        if (this == head) {
            head = next;
        }
        return head;
    }

    public BlockInfo moveBlockToHead(BlockInfo head, DatanodeStorageInfo storage, int curIndex, int headIndex) {
        if (head == this) {
            return this;
        }
        BlockInfo next = this.setNext(curIndex, head);
        BlockInfo prev = this.setPrevious(curIndex, null);
        head.setPrevious(headIndex, this);
        prev.setNext(prev.findStorageInfo(storage), next);
        if (next != null) {
            next.setPrevious(next.findStorageInfo(storage), prev);
        }
        return this;
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return HdfsServerConstants.BlockUCState.COMPLETE;
    }

    public boolean isComplete() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.COMPLETE);
    }

    public BlockInfoUnderConstruction convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState s, DatanodeStorageInfo[] targets) {
        if (this.isComplete()) {
            return new BlockInfoUnderConstruction(this, this.getBlockCollection().getBlockReplication(), s, targets);
        }
        BlockInfoUnderConstruction ucBlock = (BlockInfoUnderConstruction)this;
        ucBlock.setBlockUCState(s);
        ucBlock.setExpectedLocations(targets);
        return ucBlock;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    @Override
    public LightWeightGSet.LinkedElement getNext() {
        return this.nextLinkedElement;
    }

    @Override
    public void setNext(LightWeightGSet.LinkedElement next) {
        this.nextLinkedElement = next;
    }
}

