/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.hadoop.shaded.com.google.protobuf.ByteString;
import org.apache.flink.hadoop.shaded.com.google.protobuf.RpcController;
import org.apache.flink.hadoop.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class ClientDatanodeProtocolServerSideTranslatorPB
implements ClientDatanodeProtocolPB {
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto REFRESH_NAMENODE_RESP = ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto DELETE_BLOCKPOOL_RESP = ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto.newBuilder().build();
    private final ClientDatanodeProtocol impl;

    public ClientDatanodeProtocolServerSideTranslatorPB(ClientDatanodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto getReplicaVisibleLength(RpcController unused, ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto request) throws ServiceException {
        long len;
        try {
            len = this.impl.getReplicaVisibleLength(PBHelper.convert(request.getBlock()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto.newBuilder().setLength(len).build();
    }

    @Override
    public ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto refreshNamenodes(RpcController unused, ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto request) throws ServiceException {
        try {
            this.impl.refreshNamenodes();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return REFRESH_NAMENODE_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto deleteBlockPool(RpcController unused, ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto request) throws ServiceException {
        try {
            this.impl.deleteBlockPool(request.getBlockPool(), request.getForce());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return DELETE_BLOCKPOOL_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto getBlockLocalPathInfo(RpcController unused, ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto request) throws ServiceException {
        BlockLocalPathInfo resp;
        try {
            resp = this.impl.getBlockLocalPathInfo(PBHelper.convert(request.getBlock()), PBHelper.convert(request.getToken()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto.newBuilder().setBlock(PBHelper.convert(resp.getBlock())).setLocalPath(resp.getBlockPath()).setLocalMetaPath(resp.getMetaPath()).build();
    }

    @Override
    public ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto getHdfsBlockLocations(RpcController controller, ClientDatanodeProtocolProtos.GetHdfsBlockLocationsRequestProto request) throws ServiceException {
        HdfsBlocksMetadata resp;
        try {
            ArrayList<ExtendedBlock> blocks = new ArrayList<ExtendedBlock>(request.getBlocksCount());
            for (HdfsProtos.ExtendedBlockProto extendedBlockProto : request.getBlocksList()) {
                blocks.add(PBHelper.convert(extendedBlockProto));
            }
            ArrayList<Token<BlockTokenIdentifier>> tokens = new ArrayList<Token<BlockTokenIdentifier>>(request.getTokensCount());
            for (SecurityProtos.TokenProto b : request.getTokensList()) {
                tokens.add(PBHelper.convert(b));
            }
            resp = this.impl.getHdfsBlocksMetadata(blocks, tokens);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        ArrayList<ByteString> volumeIdsByteStrings = new ArrayList<ByteString>(resp.getVolumeIds().size());
        for (byte[] byArray : resp.getVolumeIds()) {
            volumeIdsByteStrings.add(ByteString.copyFrom(byArray));
        }
        ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto.Builder builder = ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto.newBuilder();
        builder.addAllVolumeIds(volumeIdsByteStrings);
        builder.addAllVolumeIndexes(resp.getVolumeIndexes());
        return builder.build();
    }
}

