/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.client.ClientMmapManager;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.io.nativeio.NativeIO;

@InterfaceAudience.Private
public class ClientMmap {
    static final Log LOG = LogFactory.getLog(ClientMmap.class);
    private final WeakReference<ClientMmapManager> manager;
    private final MappedByteBuffer map;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final ExtendedBlock block;
    private final DatanodeID datanodeID;
    private long lastEvictableTimeNs;

    public static ClientMmap load(ClientMmapManager manager, FileInputStream in, ExtendedBlock block, DatanodeID datanodeID) throws IOException {
        MappedByteBuffer map = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, in.getChannel().size());
        return new ClientMmap(manager, map, block, datanodeID);
    }

    private ClientMmap(ClientMmapManager manager, MappedByteBuffer map, ExtendedBlock block, DatanodeID datanodeID) throws IOException {
        this.manager = new WeakReference<ClientMmapManager>(manager);
        this.map = map;
        this.block = block;
        this.datanodeID = datanodeID;
        this.lastEvictableTimeNs = 0L;
    }

    public void unref() {
        int count = this.refCount.decrementAndGet();
        if (count < 0) {
            throw new IllegalArgumentException("can't decrement the reference count on this ClientMmap lower than 0.");
        }
        if (count == 0) {
            ClientMmapManager man = (ClientMmapManager)this.manager.get();
            if (man == null) {
                this.unmap();
            } else {
                man.makeEvictable(this);
            }
        }
    }

    public int ref() {
        return this.refCount.getAndIncrement();
    }

    @VisibleForTesting
    public ExtendedBlock getBlock() {
        return this.block;
    }

    DatanodeID getDatanodeID() {
        return this.datanodeID;
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.map;
    }

    public void setLastEvictableTimeNs(long lastEvictableTimeNs) {
        this.lastEvictableTimeNs = lastEvictableTimeNs;
    }

    public long getLastEvictableTimeNs() {
        return this.lastEvictableTimeNs;
    }

    void unmap() {
        assert (this.refCount.get() == 0);
        NativeIO.POSIX.munmap(this.map);
    }
}

