/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3.S3Credentials;
import org.apache.hadoop.fs.s3.S3Exception;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.PartialListing;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.security.AWSCredentials;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Jets3tNativeFileSystemStore
implements NativeFileSystemStore {
    private S3Service s3Service;
    private S3Bucket bucket;
    public static final Log LOG = LogFactory.getLog(Jets3tNativeFileSystemStore.class);

    Jets3tNativeFileSystemStore() {
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        S3Credentials s3Credentials = new S3Credentials();
        s3Credentials.initialize(uri, conf);
        try {
            AWSCredentials awsCredentials = new AWSCredentials(s3Credentials.getAccessKey(), s3Credentials.getSecretAccessKey());
            this.s3Service = new RestS3Service(awsCredentials);
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
        this.bucket = new S3Bucket(uri.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            S3Object object = new S3Object(key);
            object.setDataInputStream(in);
            object.setContentType("binary/octet-stream");
            object.setContentLength(file.length());
            if (md5Hash != null) {
                object.setMd5Hash(md5Hash);
            }
            this.s3Service.putObject(this.bucket, object);
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void storeEmptyFile(String key) throws IOException {
        try {
            S3Object object = new S3Object(key);
            object.setDataInputStream(new ByteArrayInputStream(new byte[0]));
            object.setContentType("binary/octet-stream");
            object.setContentLength(0L);
            this.s3Service.putObject(this.bucket, object);
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileMetadata retrieveMetadata(String key) throws IOException {
        StorageObject object = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting metadata for key: " + key + " from bucket:" + this.bucket.getName()));
            }
            object = this.s3Service.getObjectDetails(this.bucket.getName(), key);
            FileMetadata fileMetadata = new FileMetadata(key, object.getContentLength(), object.getLastModifiedDate().getTime());
            return fileMetadata;
        }
        catch (ServiceException e) {
            if ("NoSuchKey".equals(e.getErrorCode())) {
                FileMetadata fileMetadata = null;
                return fileMetadata;
            }
            this.handleServiceException(e);
            FileMetadata fileMetadata = null;
            return fileMetadata;
        }
        finally {
            if (object != null) {
                object.closeDataInputStream();
            }
        }
    }

    @Override
    public InputStream retrieve(String key) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting key: " + key + " from bucket:" + this.bucket.getName()));
            }
            S3Object object = this.s3Service.getObject(this.bucket.getName(), key);
            return object.getDataInputStream();
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(key, e);
            return null;
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
            return null;
        }
    }

    @Override
    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting key: " + key + " from bucket:" + this.bucket.getName() + " with byteRangeStart: " + byteRangeStart));
            }
            S3Object object = this.s3Service.getObject(this.bucket, key, null, null, null, null, (Long)byteRangeStart, null);
            return object.getDataInputStream();
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(key, e);
            return null;
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
            return null;
        }
    }

    @Override
    public PartialListing list(String prefix, int maxListingLength) throws IOException {
        return this.list(prefix, maxListingLength, null, false);
    }

    @Override
    public PartialListing list(String prefix, int maxListingLength, String priorLastKey, boolean recurse) throws IOException {
        return this.list(prefix, recurse ? null : "/", maxListingLength, priorLastKey);
    }

    private PartialListing list(String prefix, String delimiter, int maxListingLength, String priorLastKey) throws IOException {
        try {
            if (prefix.length() > 0 && !prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            StorageObjectsChunk chunk = this.s3Service.listObjectsChunked(this.bucket.getName(), prefix, delimiter, maxListingLength, priorLastKey);
            FileMetadata[] fileMetadata = new FileMetadata[chunk.getObjects().length];
            for (int i = 0; i < fileMetadata.length; ++i) {
                StorageObject object = chunk.getObjects()[i];
                fileMetadata[i] = new FileMetadata(object.getKey(), object.getContentLength(), object.getLastModifiedDate().getTime());
            }
            return new PartialListing(chunk.getPriorLastKey(), fileMetadata, chunk.getCommonPrefixes());
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
            return null;
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
            return null;
        }
    }

    @Override
    public void delete(String key) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting key:" + key + "from bucket" + this.bucket.getName()));
            }
            this.s3Service.deleteObject(this.bucket, key);
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(key, e);
        }
    }

    @Override
    public void copy(String srcKey, String dstKey) throws IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Copying srcKey: " + srcKey + "to dstKey: " + dstKey + "in bucket: " + this.bucket.getName()));
            }
            this.s3Service.copyObject(this.bucket.getName(), srcKey, this.bucket.getName(), new S3Object(dstKey), false);
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(srcKey, e);
        }
        catch (ServiceException e) {
            this.handleServiceException(e);
        }
    }

    @Override
    public void purge(String prefix) throws IOException {
        try {
            S3Object[] objects;
            for (S3Object object : objects = this.s3Service.listObjects(this.bucket.getName(), prefix, null)) {
                this.s3Service.deleteObject(this.bucket, object.getKey());
            }
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
    }

    @Override
    public void dump() throws IOException {
        StringBuilder sb = new StringBuilder("S3 Native Filesystem, ");
        sb.append(this.bucket.getName()).append("\n");
        try {
            S3Object[] objects;
            for (S3Object object : objects = this.s3Service.listObjects(this.bucket.getName())) {
                sb.append(object.getKey()).append("\n");
            }
        }
        catch (S3ServiceException e) {
            this.handleS3ServiceException(e);
        }
        System.out.println(sb);
    }

    private void handleS3ServiceException(String key, S3ServiceException e) throws IOException {
        if ("NoSuchKey".equals(e.getS3ErrorCode())) {
            throw new FileNotFoundException("Key '" + key + "' does not exist in S3");
        }
        this.handleS3ServiceException(e);
    }

    private void handleS3ServiceException(S3ServiceException e) throws IOException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("S3 Error code: " + e.getS3ErrorCode() + "; S3 Error message: " + e.getS3ErrorMessage()));
        }
        throw new S3Exception(e);
    }

    private void handleServiceException(ServiceException e) throws IOException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got ServiceException with Error code: " + e.getErrorCode() + ";and Error message: " + e.getErrorMessage()));
        }
    }
}

