/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.service;

import java.beans.Transient;
import java.io.Serializable;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.StringUtils;

public class GenericException
extends RuntimeException {
    private static final long serialVersionUID = -1182299763306599962L;
    private boolean useCause;
    private String exceptionClass;
    private String exceptionMessage;
    private final GenericExceptionInfo genericExceptionInfo;

    public GenericException() {
        this((String)null, (String)null);
    }

    public GenericException(String exceptionClass, String exceptionMessage) {
        super(exceptionMessage);
        this.useCause = false;
        this.exceptionClass = exceptionClass;
        this.exceptionMessage = exceptionMessage;
        this.genericExceptionInfo = new GenericExceptionInfo(exceptionClass, exceptionMessage, exceptionMessage, this.getStackTrace());
    }

    public GenericException(Throwable cause) {
        super(StringUtils.toString(cause));
        this.useCause = false;
        this.exceptionClass = cause.getClass().getName();
        this.exceptionMessage = cause.getMessage();
        this.genericExceptionInfo = new GenericExceptionInfo(this.exceptionClass, this.exceptionMessage, super.getMessage(), this.getStackTrace());
    }

    protected GenericException(GenericExceptionInfo info) {
        super(info.getMsg(), null, true, false);
        this.setStackTrace(info.getStackTrace());
        this.useCause = false;
        this.exceptionClass = info.getExClass();
        this.exceptionMessage = info.getExMsg();
        this.genericExceptionInfo = info;
    }

    @Transient
    public String getExceptionClass() {
        if (this.useCause) {
            return ((GenericException)this.getCause()).getExceptionClass();
        }
        return this.exceptionClass;
    }

    public void setExceptionClass(String exceptionClass) {
        if (this.useCause) {
            ((GenericException)this.getCause()).setExceptionClass(exceptionClass);
            return;
        }
        this.exceptionClass = exceptionClass;
    }

    @Transient
    public String getExceptionMessage() {
        if (this.useCause) {
            return ((GenericException)this.getCause()).getExceptionMessage();
        }
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        if (this.useCause) {
            ((GenericException)this.getCause()).setExceptionMessage(exceptionMessage);
            return;
        }
        this.exceptionMessage = exceptionMessage;
    }

    @Override
    @Transient
    public StackTraceElement[] getStackTrace() {
        if (this.useCause) {
            return ((GenericException)this.getCause()).getStackTrace();
        }
        return super.getStackTrace();
    }

    @Override
    @Transient
    public String getMessage() {
        if (this.useCause) {
            return this.getCause().getMessage();
        }
        return JsonUtils.toJson(GenericExceptionInfo.createNoStackTrace(this.genericExceptionInfo));
    }

    public String getGenericException() {
        if (this.useCause) {
            return ((GenericException)this.getCause()).getGenericException();
        }
        return JsonUtils.toJson(this.genericExceptionInfo);
    }

    public void setGenericException(String json) {
        GenericExceptionInfo info = (GenericExceptionInfo)JsonUtils.toJavaObject(json, GenericExceptionInfo.class);
        if (info == null) {
            return;
        }
        this.useCause = true;
        this.initCause(new GenericException(info));
    }

    @Override
    @Transient
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public static class GenericExceptionInfo
    implements Serializable {
        private String exClass;
        private String exMsg;
        private String msg;
        private StackTraceElement[] stackTrace;

        public GenericExceptionInfo() {
        }

        public GenericExceptionInfo(String exceptionClass, String exceptionMessage, String message, StackTraceElement[] stackTrace) {
            this.exClass = exceptionClass;
            this.exMsg = exceptionMessage;
            this.msg = message;
            this.stackTrace = stackTrace;
        }

        public static GenericExceptionInfo createNoStackTrace(GenericExceptionInfo info) {
            return new GenericExceptionInfo(info.getExClass(), info.getExMsg(), info.getMsg(), null);
        }

        public String getMsg() {
            return this.msg;
        }

        public String getExClass() {
            return this.exClass;
        }

        public String getExMsg() {
            return this.exMsg;
        }

        public void setExClass(String exClass) {
            this.exClass = exClass;
        }

        public void setExMsg(String exMsg) {
            this.exMsg = exMsg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public void setStackTrace(StackTraceElement[] stackTrace) {
            this.stackTrace = stackTrace;
        }
    }
}

