/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ComparatorDimensionDictionary;
import org.apache.druid.segment.ComparatorSortedDimensionDictionary;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.nested.GlobalDictionarySortedCollector;
import org.apache.druid.segment.nested.StructuredDataProcessor;

public class GlobalDimensionDictionary {
    private final ComparatorDimensionDictionary<String> stringDictionary = new ComparatorDimensionDictionary<String>((Comparator)ColumnType.STRING.getNullableStrategy()){

        @Override
        public long estimateSizeOfValue(String value) {
            return StructuredDataProcessor.estimateStringSize(value);
        }
    };
    private final ComparatorDimensionDictionary<Long> longDictionary = new ComparatorDimensionDictionary<Long>((Comparator)ColumnType.LONG.getNullableStrategy()){

        @Override
        public long estimateSizeOfValue(Long value) {
            return StructuredDataProcessor.getLongObjectEstimateSize();
        }
    };
    private final ComparatorDimensionDictionary<Double> doubleDictionary = new ComparatorDimensionDictionary<Double>((Comparator)ColumnType.DOUBLE.getNullableStrategy()){

        @Override
        public long estimateSizeOfValue(Double value) {
            return StructuredDataProcessor.getDoubleObjectEstimateSize();
        }
    };

    public void addLongValue(@Nullable Long value) {
        this.longDictionary.add(value);
    }

    public void addDoubleValue(@Nullable Double value) {
        this.doubleDictionary.add(value);
    }

    public void addStringValue(@Nullable String value) {
        this.stringDictionary.add(value);
    }

    public GlobalDictionarySortedCollector getSortedCollector() {
        final ComparatorSortedDimensionDictionary<String> sortedStringDimensionDictionary = this.stringDictionary.sort();
        Indexed<String> strings = new Indexed<String>(){

            @Override
            public int size() {
                return GlobalDimensionDictionary.this.stringDictionary.size();
            }

            @Override
            public String get(int index) {
                return (String)sortedStringDimensionDictionary.getValueFromSortedId(index);
            }

            @Override
            public int indexOf(String value) {
                int id = GlobalDimensionDictionary.this.stringDictionary.getId(value);
                return id < 0 ? -1 : sortedStringDimensionDictionary.getSortedIdFromUnsortedId(id);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
        final ComparatorSortedDimensionDictionary<Long> sortedLongDimensionDictionary = this.longDictionary.sort();
        Indexed<Long> longs = new Indexed<Long>(){

            @Override
            public int size() {
                return GlobalDimensionDictionary.this.longDictionary.size();
            }

            @Override
            public Long get(int index) {
                return (Long)sortedLongDimensionDictionary.getValueFromSortedId(index);
            }

            @Override
            public int indexOf(Long value) {
                int id = GlobalDimensionDictionary.this.longDictionary.getId(value);
                return id < 0 ? -1 : sortedLongDimensionDictionary.getSortedIdFromUnsortedId(id);
            }

            @Override
            public Iterator<Long> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
        final ComparatorSortedDimensionDictionary<Double> sortedDoubleDimensionDictionary = this.doubleDictionary.sort();
        Indexed<Double> doubles = new Indexed<Double>(){

            @Override
            public int size() {
                return GlobalDimensionDictionary.this.doubleDictionary.size();
            }

            @Override
            public Double get(int index) {
                return (Double)sortedDoubleDimensionDictionary.getValueFromSortedId(index);
            }

            @Override
            public int indexOf(Double value) {
                int id = GlobalDimensionDictionary.this.doubleDictionary.getId(value);
                return id < 0 ? -1 : sortedDoubleDimensionDictionary.getSortedIdFromUnsortedId(id);
            }

            @Override
            public Iterator<Double> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        };
        return new GlobalDictionarySortedCollector(strings, longs, doubles);
    }

    public long sizeInBytes() {
        return this.stringDictionary.sizeInBytes() + this.longDictionary.sizeInBytes() + this.doubleDictionary.sizeInBytes();
    }

    public int getCardinality() {
        return this.stringDictionary.size() + this.longDictionary.size() + this.doubleDictionary.size();
    }
}

