/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.Double2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import javax.annotation.Nullable;

public class GlobalDictionaryIdLookup {
    private final Object2IntMap<String> stringLookup = new Object2IntLinkedOpenHashMap();
    private final Long2IntMap longLookup = new Long2IntLinkedOpenHashMap();
    private final Int2LongMap reverseLongLookup = new Int2LongLinkedOpenHashMap();
    private final Double2IntMap doubleLookup = new Double2IntLinkedOpenHashMap();
    private final Int2DoubleMap reverseDoubleLookup = new Int2DoubleLinkedOpenHashMap();
    private int dictionarySize;

    public void addString(@Nullable String value) {
        Preconditions.checkState((this.longLookup.size() == 0 && this.doubleLookup.size() == 0 ? 1 : 0) != 0, (Object)"All string values must be inserted to the lookup before long and double types");
        int id = this.dictionarySize++;
        this.stringLookup.put((Object)value, id);
    }

    public int lookupString(@Nullable String value) {
        return this.stringLookup.getInt((Object)value);
    }

    public void addLong(long value) {
        Preconditions.checkState((this.doubleLookup.size() == 0 ? 1 : 0) != 0, (Object)"All long values must be inserted to the lookup before double types");
        int id = this.dictionarySize++;
        this.longLookup.put(value, id);
        this.reverseLongLookup.put(id, value);
    }

    public int lookupLong(@Nullable Long value) {
        if (value == null) {
            return 0;
        }
        return this.longLookup.get(value.longValue());
    }

    @Nullable
    public Long lookupLong(int id) {
        if (id == 0) {
            return null;
        }
        return this.reverseLongLookup.get(id);
    }

    public void addDouble(double value) {
        int id = this.dictionarySize++;
        this.doubleLookup.put(value, id);
        this.reverseDoubleLookup.put(id, value);
    }

    public int lookupDouble(@Nullable Double value) {
        if (value == null) {
            return 0;
        }
        return this.doubleLookup.get(value.doubleValue());
    }

    @Nullable
    public Double lookupDouble(int id) {
        if (id == 0) {
            return null;
        }
        return this.reverseDoubleLookup.get(id);
    }
}

