/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter.rewrite;

import java.util.Objects;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;

public class JoinFilterRewriteConfig {
    private final boolean enableFilterPushDown;
    private final boolean enableFilterRewrite;
    private final boolean enableRewriteValueColumnFilters;
    private final boolean enableRewriteJoinToFilter;
    private final long filterRewriteMaxSize;

    public JoinFilterRewriteConfig(boolean enableFilterPushDown, boolean enableFilterRewrite, boolean enableRewriteValueColumnFilters, boolean enableRewriteJoinToFilter, long filterRewriteMaxSize) {
        this.enableFilterPushDown = enableFilterPushDown;
        this.enableFilterRewrite = enableFilterRewrite;
        this.enableRewriteValueColumnFilters = enableRewriteValueColumnFilters;
        this.enableRewriteJoinToFilter = enableRewriteJoinToFilter;
        this.filterRewriteMaxSize = filterRewriteMaxSize;
    }

    public static JoinFilterRewriteConfig forQuery(Query<?> query) {
        return new JoinFilterRewriteConfig(QueryContexts.getEnableJoinFilterPushDown(query), QueryContexts.getEnableJoinFilterRewrite(query), QueryContexts.getEnableJoinFilterRewriteValueColumnFilters(query), QueryContexts.getEnableRewriteJoinToFilter(query), QueryContexts.getJoinFilterRewriteMaxSize(query));
    }

    public boolean isEnableFilterPushDown() {
        return this.enableFilterPushDown;
    }

    public boolean isEnableFilterRewrite() {
        return this.enableFilterRewrite;
    }

    public boolean isEnableRewriteValueColumnFilters() {
        return this.enableRewriteValueColumnFilters;
    }

    public boolean isEnableRewriteJoinToFilter() {
        return this.enableRewriteJoinToFilter;
    }

    public long getFilterRewriteMaxSize() {
        return this.filterRewriteMaxSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinFilterRewriteConfig that = (JoinFilterRewriteConfig)o;
        return this.enableFilterPushDown == that.enableFilterPushDown && this.enableFilterRewrite == that.enableFilterRewrite && this.enableRewriteValueColumnFilters == that.enableRewriteValueColumnFilters && this.enableRewriteJoinToFilter == that.enableRewriteJoinToFilter && this.filterRewriteMaxSize == that.filterRewriteMaxSize;
    }

    public int hashCode() {
        return Objects.hash(this.enableFilterPushDown, this.enableFilterRewrite, this.enableRewriteValueColumnFilters, this.enableRewriteJoinToFilter, this.filterRewriteMaxSize);
    }

    public String toString() {
        return "JoinFilterRewriteConfig{enableFilterPushDown=" + this.enableFilterPushDown + ", enableFilterRewrite=" + this.enableFilterRewrite + ", enableRewriteValueColumnFilters=" + this.enableRewriteValueColumnFilters + ", enableRewriteJoinToFilter=" + this.enableRewriteJoinToFilter + ", filterRewriteMaxSize=" + this.filterRewriteMaxSize + '}';
    }
}

