/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.filter.BooleanValueMatcher;

public class ValueMatchers {
    private ValueMatchers() {
    }

    public static ValueMatcher makeStringValueMatcher(DimensionSelector selector, String value, boolean hasMultipleValues) {
        ValueMatcher booleanMatcher = ValueMatchers.toBooleanMatcherIfPossible(selector, hasMultipleValues, (Predicate<String>)((Predicate)s -> Objects.equals(s, NullHandling.emptyToNullIfNeeded((String)value))));
        if (booleanMatcher != null) {
            return booleanMatcher;
        }
        return selector.makeValueMatcher(value);
    }

    public static ValueMatcher makeStringValueMatcher(DimensionSelector selector, DruidPredicateFactory predicateFactory, boolean hasMultipleValues) {
        Predicate<String> predicate = predicateFactory.makeStringPredicate();
        ValueMatcher booleanMatcher = ValueMatchers.toBooleanMatcherIfPossible(selector, hasMultipleValues, predicate);
        if (booleanMatcher != null) {
            return booleanMatcher;
        }
        return selector.makeValueMatcher(predicate);
    }

    public static ValueMatcher makeFloatValueMatcher(final BaseFloatColumnValueSelector selector, String value) {
        Float matchVal = DimensionHandlerUtils.convertObjectToFloat(value);
        if (matchVal == null) {
            return ValueMatchers.makeNumericNullValueMatcher(selector);
        }
        final int matchValIntBits = Float.floatToIntBits(matchVal.floatValue());
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return false;
                }
                return Float.floatToIntBits(selector.getFloat()) == matchValIntBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeLongValueMatcher(final BaseLongColumnValueSelector selector, String value) {
        Long matchVal = DimensionHandlerUtils.convertObjectToLong(value);
        if (matchVal == null) {
            return ValueMatchers.makeNumericNullValueMatcher(selector);
        }
        final long matchValLong = matchVal;
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return false;
                }
                return selector.getLong() == matchValLong;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeLongValueMatcher(final BaseLongColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidLongPredicate predicate = predicateFactory.makeLongPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return predicate.applyNull();
                }
                return predicate.applyLong(selector.getLong());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static ValueMatcher makeFloatValueMatcher(final BaseFloatColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidFloatPredicate predicate = predicateFactory.makeFloatPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return predicate.applyNull();
                }
                return predicate.applyFloat(selector.getFloat());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    public static ValueMatcher makeDoubleValueMatcher(final BaseDoubleColumnValueSelector selector, String value) {
        Double matchVal = DimensionHandlerUtils.convertObjectToDouble(value);
        if (matchVal == null) {
            return ValueMatchers.makeNumericNullValueMatcher(selector);
        }
        final long matchValLongBits = Double.doubleToLongBits(matchVal);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return false;
                }
                return Double.doubleToLongBits(selector.getDouble()) == matchValLongBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    public static ValueMatcher makeDoubleValueMatcher(final BaseDoubleColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidDoublePredicate predicate = predicateFactory.makeDoublePredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return predicate.applyNull();
                }
                return predicate.applyDouble(selector.getDouble());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Nullable
    public static Boolean toBooleanIfPossible(DimensionDictionarySelector selector, boolean hasMultipleValues, Predicate<String> predicate) {
        if (selector.getValueCardinality() == 0) {
            return predicate.apply(null);
        }
        if (!hasMultipleValues && selector.getValueCardinality() == 1 && selector.nameLookupPossibleInAdvance()) {
            return predicate.apply((Object)selector.lookupName(0));
        }
        return null;
    }

    @Nullable
    private static ValueMatcher toBooleanMatcherIfPossible(DimensionSelector selector, boolean hasMultipleValues, Predicate<String> predicate) {
        Boolean booleanValue = ValueMatchers.toBooleanIfPossible(selector, hasMultipleValues, predicate);
        return booleanValue == null ? null : BooleanValueMatcher.of(booleanValue);
    }

    private static ValueMatcher makeNumericNullValueMatcher(final BaseNullableColumnValueSelector selector) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return selector.isNull();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }
}

