/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;

public class ComparableStringArray
implements Comparable<ComparableStringArray> {
    public static final ComparableStringArray EMPTY_ARRAY = new ComparableStringArray(new String[0]);
    final String[] delegate;
    private int hashCode;
    private boolean hashCodeComputed;

    private ComparableStringArray(String[] array) {
        this.delegate = array;
    }

    @JsonCreator
    public static ComparableStringArray of(String ... array) {
        if (array.length == 0) {
            return EMPTY_ARRAY;
        }
        return new ComparableStringArray(array);
    }

    @JsonValue
    public String[] getDelegate() {
        return this.delegate;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = Arrays.hashCode(this.delegate);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this.delegate, ((ComparableStringArray)obj).getDelegate());
    }

    @Override
    public int compareTo(ComparableStringArray rhs) {
        if (rhs == null) {
            return 1;
        }
        int minSize = Math.min(this.getDelegate().length, rhs.getDelegate().length);
        if (this.delegate == rhs.getDelegate()) {
            return 0;
        }
        for (int i = 0; i < minSize; ++i) {
            String first = this.delegate[i];
            String second = rhs.getDelegate()[i];
            int cmp = first == null && second == null ? 0 : (first == null ? -1 : (second == null ? 1 : first.compareTo(second)));
            if (cmp == 0) continue;
            return cmp;
        }
        if (this.getDelegate().length == rhs.getDelegate().length) {
            return 0;
        }
        if (this.getDelegate().length < rhs.getDelegate().length) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return Arrays.toString(this.delegate);
    }

    public static int compareWithComparator(StringComparator stringComparator, ComparableStringArray lhsComparableArray, ComparableStringArray rhsComparableArray) {
        StringComparator comparator;
        StringComparator stringComparator2 = comparator = stringComparator == null ? StringComparators.LEXICOGRAPHIC : stringComparator;
        if (lhsComparableArray == null && rhsComparableArray == null) {
            return 0;
        }
        if (lhsComparableArray == null) {
            return -1;
        }
        if (rhsComparableArray == null) {
            return 1;
        }
        String[] lhs = lhsComparableArray.getDelegate();
        String[] rhs = rhsComparableArray.getDelegate();
        int minLength = Math.min(lhs.length, rhs.length);
        if (lhs == rhs) {
            return 0;
        }
        for (int i = 0; i < minLength; ++i) {
            int cmp = comparator.compare(lhs[i], rhs[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (lhs.length == rhs.length) {
            return 0;
        }
        if (lhs.length < rhs.length) {
            return -1;
        }
        return 1;
    }
}

