/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;

public class ComparableList<T extends Comparable>
implements Comparable<ComparableList> {
    private final List<T> delegate;

    public ComparableList(List<T> input) {
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (String)"Input cannot be null for %s", (Object[])new Object[]{ComparableList.class.getName()});
        this.delegate = input;
    }

    @JsonValue
    public List<T> getDelegate() {
        return this.delegate;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.delegate.equals(((ComparableList)obj).getDelegate());
    }

    @Override
    public int compareTo(ComparableList rhs) {
        if (rhs == null) {
            return 1;
        }
        int minSize = Math.min(this.getDelegate().size(), rhs.getDelegate().size());
        if (this.delegate == rhs.getDelegate()) {
            return 0;
        }
        for (int i = 0; i < minSize; ++i) {
            Comparable first = (Comparable)this.delegate.get(i);
            T second = rhs.getDelegate().get(i);
            int cmp = first == null && second == null ? 0 : (first == null ? -1 : (second == null ? 1 : first.compareTo(second)));
            if (cmp == 0) continue;
            return cmp;
        }
        if (this.getDelegate().size() == rhs.getDelegate().size()) {
            return 0;
        }
        if (this.getDelegate().size() < rhs.getDelegate().size()) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static int compareWithComparator(StringComparator stringComparator, ComparableList lhsComparableArray, ComparableList rhsComparableArray) {
        StringComparator comparator;
        StringComparator stringComparator2 = comparator = stringComparator == null ? StringComparators.NUMERIC : stringComparator;
        if (lhsComparableArray == null && rhsComparableArray == null) {
            return 0;
        }
        if (lhsComparableArray == null) {
            return -1;
        }
        if (rhsComparableArray == null) {
            return 1;
        }
        List lhs = lhsComparableArray.getDelegate();
        List rhs = rhsComparableArray.getDelegate();
        int minLength = Math.min(lhs.size(), rhs.size());
        if (lhs == rhs) {
            return 0;
        }
        for (int i = 0; i < minLength; ++i) {
            int cmp = comparator.compare(String.valueOf(lhs.get(i)), String.valueOf(rhs.get(i)));
            if (cmp == 0) continue;
            return cmp;
        }
        if (lhs.size() == rhs.size()) {
            return 0;
        }
        if (lhs.size() < rhs.size()) {
            return -1;
        }
        return 1;
    }
}

