/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.IOException;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.segment.RowAdapter;
import org.joda.time.DateTime;

public class RowWalker<T> {
    private final Sequence<T> rowSequence;
    private final ToLongFunction<T> timestampFunction;
    @Nullable
    private Yielder<T> rowYielder;

    RowWalker(Sequence<T> rowSequence, RowAdapter<T> rowAdapter) {
        this.rowSequence = rowSequence;
        this.timestampFunction = rowAdapter.timestampFunction();
        this.rowYielder = Yielders.each(rowSequence);
    }

    public boolean isDone() {
        return this.rowYielder == null || this.rowYielder.isDone();
    }

    public T currentRow() {
        if (this.isDone()) {
            throw new ISE("cannot call currentRow when isDone == true", new Object[0]);
        }
        return (T)this.rowYielder.get();
    }

    public void advance() {
        if (this.isDone()) {
            throw new ISE("cannot call advance when isDone == true", new Object[0]);
        }
        this.rowYielder = this.rowYielder.next(null);
    }

    public void reset() {
        this.close();
        this.rowYielder = Yielders.each(this.rowSequence);
    }

    public void skipToDateTime(DateTime timestamp, boolean descending) {
        while (!this.isDone() && (descending ? timestamp.isBefore(this.timestampFunction.applyAsLong(this.rowYielder.get())) : timestamp.isAfter(this.timestampFunction.applyAsLong(this.rowYielder.get())))) {
            this.advance();
        }
    }

    public void close() {
        if (this.rowYielder != null) {
            try {
                this.rowYielder.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.rowYielder = null;
            }
        }
    }
}

